/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.datastore.rocksdb.util;

import com.google.common.collect.Streams;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.locationtech.geowave.core.index.ByteArrayUtils;
import org.locationtech.geowave.core.store.CloseableIterator;
import org.locationtech.geowave.core.store.base.dataidx.DataIndexUtils;
import org.locationtech.geowave.core.store.entities.GeoWaveRow;
import org.locationtech.geowave.core.store.entities.GeoWaveValue;
import org.locationtech.geowave.datastore.rocksdb.util.AbstractRocksDBTable;
import org.locationtech.geowave.datastore.rocksdb.util.DataIndexBoundedReverseRowIterator;
import org.locationtech.geowave.datastore.rocksdb.util.DataIndexForwardRowIterator;
import org.locationtech.geowave.datastore.rocksdb.util.DataIndexReverseRowIterator;
import org.rocksdb.Options;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.Slice;
import org.rocksdb.WriteOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocksDBDataIndexTable
extends AbstractRocksDBTable {
    private static final Logger LOGGER = LoggerFactory.getLogger(RocksDBDataIndexTable.class);

    public RocksDBDataIndexTable(Options writeOptions, WriteOptions batchWriteOptions, String subDirectory, short adapterId, boolean visibilityEnabled, boolean compactOnWrite, int batchSize) {
        super(writeOptions, batchWriteOptions, subDirectory, adapterId, visibilityEnabled, compactOnWrite, batchSize);
    }

    public synchronized void add(byte[] dataId, GeoWaveValue value) {
        this.put(dataId, DataIndexUtils.serializeDataIndexValue((GeoWaveValue)value, (boolean)this.visibilityEnabled));
    }

    public CloseableIterator<GeoWaveRow> dataIndexIterator(byte[][] dataIds) {
        if (dataIds == null || dataIds.length == 0) {
            return new CloseableIterator.Empty();
        }
        RocksDB readDb = this.getDb(true);
        if (readDb == null) {
            return new CloseableIterator.Empty();
        }
        try {
            List dataIdsList = Arrays.asList(dataIds);
            List dataIdxResults = readDb.multiGetAsList(dataIdsList);
            if (dataIdsList.size() == dataIdxResults.size()) {
                return new CloseableIterator.Wrapper(Streams.zip(dataIdsList.stream(), dataIdxResults.stream(), (key, value) -> value == null ? null : DataIndexUtils.deserializeDataIndexRow((byte[])key, (short)this.adapterId, (byte[])value, (boolean)this.visibilityEnabled)).filter(Objects::nonNull).iterator());
            }
            LOGGER.warn("Result size differs from original keys");
        }
        catch (RocksDBException e) {
            LOGGER.error("Unable to get values by data ID", (Throwable)e);
        }
        return new CloseableIterator.Empty();
    }

    public CloseableIterator<GeoWaveRow> dataIndexIterator(byte[] startDataId, byte[] endDataId, boolean reverse) {
        RocksIterator it;
        ReadOptions options;
        RocksDB readDb = this.getDb(true);
        if (readDb == null) {
            return new CloseableIterator.Empty();
        }
        if (reverse) {
            RocksIterator it2 = readDb.newIterator();
            if (endDataId == null) {
                it2.seekToLast();
            } else {
                it2.seekForPrev(ByteArrayUtils.getNextPrefix((byte[])endDataId));
            }
            if (startDataId == null) {
                return new DataIndexReverseRowIterator(it2, this.adapterId, this.visibilityEnabled);
            }
            return new DataIndexBoundedReverseRowIterator(startDataId, it2, this.adapterId, this.visibilityEnabled);
        }
        if (endDataId == null) {
            options = null;
            it = readDb.newIterator();
        } else {
            options = new ReadOptions().setIterateUpperBound(new Slice(ByteArrayUtils.getNextPrefix((byte[])endDataId)));
            it = readDb.newIterator(options);
        }
        if (startDataId == null) {
            it.seekToFirst();
        } else {
            it.seek(startDataId);
        }
        return new DataIndexForwardRowIterator(options, it, this.adapterId, this.visibilityEnabled);
    }
}

