/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.datastore.rocksdb.util;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import org.locationtech.geowave.datastore.rocksdb.util.RocksDBClient;

public class RocksDBClientCache {
    private static RocksDBClientCache singletonInstance;
    private final LoadingCache<ClientKey, RocksDBClient> clientCache = Caffeine.newBuilder().build(subDirectoryVisiblityPair -> new RocksDBClient(((ClientKey)subDirectoryVisiblityPair).directory, ((ClientKey)subDirectoryVisiblityPair).visibilityEnabled, ((ClientKey)subDirectoryVisiblityPair).compactOnWrite, ((ClientKey)subDirectoryVisiblityPair).batchSize, ((ClientKey)subDirectoryVisiblityPair).walOnBatchWrite));

    public static synchronized RocksDBClientCache getInstance() {
        if (singletonInstance == null) {
            singletonInstance = new RocksDBClientCache();
        }
        return singletonInstance;
    }

    protected RocksDBClientCache() {
    }

    public RocksDBClient getClient(String directory, boolean visibilityEnabled, boolean compactOnWrite, int batchWriteSize, boolean walOnBatchWrite) {
        return (RocksDBClient)this.clientCache.get((Object)new ClientKey(directory, visibilityEnabled, compactOnWrite, batchWriteSize, walOnBatchWrite));
    }

    public synchronized void close(String directory, boolean visibilityEnabled, boolean compactOnWrite, int batchWriteSize, boolean walOnBatchWrite) {
        ClientKey key = new ClientKey(directory, visibilityEnabled, compactOnWrite, batchWriteSize, walOnBatchWrite);
        RocksDBClient client = (RocksDBClient)this.clientCache.getIfPresent((Object)key);
        if (client != null) {
            this.clientCache.invalidate((Object)key);
            client.close();
        }
        if (this.clientCache.estimatedSize() == 0L) {
            if (RocksDBClient.metadataOptions != null) {
                RocksDBClient.metadataOptions.close();
                RocksDBClient.metadataOptions = null;
            }
            if (RocksDBClient.indexWriteOptions != null) {
                RocksDBClient.indexWriteOptions.close();
                RocksDBClient.indexWriteOptions = null;
            }
        }
    }

    public synchronized void closeAll() {
        this.clientCache.asMap().forEach((k, v) -> v.close());
        this.clientCache.invalidateAll();
        if (RocksDBClient.metadataOptions != null) {
            RocksDBClient.metadataOptions.close();
            RocksDBClient.metadataOptions = null;
        }
        if (RocksDBClient.indexWriteOptions != null) {
            RocksDBClient.indexWriteOptions.close();
            RocksDBClient.indexWriteOptions = null;
        }
    }

    private static class ClientKey {
        private final String directory;
        private final boolean visibilityEnabled;
        private final boolean compactOnWrite;
        private final int batchSize;
        private final boolean walOnBatchWrite;

        public ClientKey(String directory, boolean visibilityEnabled, boolean compactOnWrite, int batchSize, boolean walOnBatchWrite) {
            this.directory = directory;
            this.visibilityEnabled = visibilityEnabled;
            this.compactOnWrite = compactOnWrite;
            this.batchSize = batchSize;
            this.walOnBatchWrite = walOnBatchWrite;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.batchSize;
            result = 31 * result + (this.compactOnWrite ? 1231 : 1237);
            result = 31 * result + (this.directory == null ? 0 : this.directory.hashCode());
            result = 31 * result + (this.visibilityEnabled ? 1231 : 1237);
            result = 31 * result + (this.walOnBatchWrite ? 1231 : 1237);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ClientKey other = (ClientKey)obj;
            if (this.batchSize != other.batchSize) {
                return false;
            }
            if (this.compactOnWrite != other.compactOnWrite) {
                return false;
            }
            if (this.directory == null ? other.directory != null : !this.directory.equals(other.directory)) {
                return false;
            }
            if (this.visibilityEnabled != other.visibilityEnabled) {
                return false;
            }
            return this.walOnBatchWrite == other.walOnBatchWrite;
        }
    }
}

