/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.datastore.rocksdb.util;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Closeable;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.locationtech.geowave.core.store.operations.MetadataType;
import org.locationtech.geowave.datastore.rocksdb.util.AbstractRocksDBTable;
import org.locationtech.geowave.datastore.rocksdb.util.RocksDBDataIndexTable;
import org.locationtech.geowave.datastore.rocksdb.util.RocksDBIndexTable;
import org.locationtech.geowave.datastore.rocksdb.util.RocksDBMetadataTable;
import org.locationtech.geowave.datastore.rocksdb.util.RocksDBUtils;
import org.rocksdb.Options;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.WriteOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocksDBClient
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(RocksDBClient.class);
    private final Cache<String, CacheKey> keyCache = Caffeine.newBuilder().build();
    private final LoadingCache<IndexCacheKey, RocksDBIndexTable> indexTableCache = Caffeine.newBuilder().build(key -> this.loadIndexTable((IndexCacheKey)key));
    private final LoadingCache<DataIndexCacheKey, RocksDBDataIndexTable> dataIndexTableCache = Caffeine.newBuilder().build(key -> this.loadDataIndexTable((DataIndexCacheKey)key));
    private final LoadingCache<CacheKey, RocksDBMetadataTable> metadataTableCache = Caffeine.newBuilder().build(key -> this.loadMetadataTable((CacheKey)key));
    private final String subDirectory;
    private final boolean visibilityEnabled;
    private final boolean compactOnWrite;
    private final int batchWriteSize;
    private final boolean walOnBatchWrite;
    protected static Options indexWriteOptions = null;
    protected WriteOptions batchWriteOptions = null;
    protected static Options metadataOptions = null;

    public RocksDBClient(String subDirectory, boolean visibilityEnabled, boolean compactOnWrite, int batchWriteSize, boolean walOnBatchWrite) {
        this.subDirectory = subDirectory;
        this.visibilityEnabled = visibilityEnabled;
        this.compactOnWrite = compactOnWrite;
        this.batchWriteSize = batchWriteSize;
        this.walOnBatchWrite = walOnBatchWrite;
    }

    private RocksDBMetadataTable loadMetadataTable(CacheKey key) throws RocksDBException {
        File dir = new File(key.directory);
        if (!dir.exists() && !dir.mkdirs()) {
            LOGGER.error("Unable to create directory for rocksdb store '" + key.directory + "'");
        }
        return new RocksDBMetadataTable(RocksDB.open((Options)metadataOptions, (String)key.directory), key.requiresTimestamp, this.visibilityEnabled, this.compactOnWrite);
    }

    @SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"}, justification="This is only called from the loading cache which is synchronized")
    private RocksDBIndexTable loadIndexTable(IndexCacheKey key) {
        return new RocksDBIndexTable(indexWriteOptions, this.batchWriteOptions, key.directory, key.adapterId, key.partition, key.requiresTimestamp, this.visibilityEnabled, this.compactOnWrite, this.batchWriteSize);
    }

    @SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"}, justification="This is only called from the loading cache which is synchronized")
    private RocksDBDataIndexTable loadDataIndexTable(DataIndexCacheKey key) {
        return new RocksDBDataIndexTable(indexWriteOptions, this.batchWriteOptions, key.directory, key.adapterId, this.visibilityEnabled, this.compactOnWrite, this.batchWriteSize);
    }

    public String getSubDirectory() {
        return this.subDirectory;
    }

    public synchronized RocksDBIndexTable getIndexTable(String tableName, short adapterId, byte[] partition, boolean requiresTimestamp) {
        if (indexWriteOptions == null) {
            RocksDB.loadLibrary();
            int cores = Runtime.getRuntime().availableProcessors();
            indexWriteOptions = new Options().setCreateIfMissing(true).prepareForBulkLoad().setIncreaseParallelism(cores);
        }
        if (this.batchWriteOptions == null) {
            this.batchWriteOptions = new WriteOptions().setDisableWAL(!this.walOnBatchWrite).setNoSlowdown(false).setSync(false);
        }
        String directory = this.subDirectory + "/" + tableName;
        return (RocksDBIndexTable)this.indexTableCache.get((Object)((IndexCacheKey)this.keyCache.get((Object)directory, d -> new IndexCacheKey((String)d, adapterId, partition, requiresTimestamp))));
    }

    public synchronized RocksDBDataIndexTable getDataIndexTable(String tableName, short adapterId) {
        if (indexWriteOptions == null) {
            RocksDB.loadLibrary();
            int cores = Runtime.getRuntime().availableProcessors();
            indexWriteOptions = new Options().setCreateIfMissing(true).prepareForBulkLoad().setIncreaseParallelism(cores);
        }
        if (this.batchWriteOptions == null) {
            this.batchWriteOptions = new WriteOptions().setDisableWAL(!this.walOnBatchWrite).setNoSlowdown(false).setSync(false);
        }
        String directory = this.subDirectory + "/" + tableName;
        return (RocksDBDataIndexTable)this.dataIndexTableCache.get((Object)((DataIndexCacheKey)this.keyCache.get((Object)directory, d -> new DataIndexCacheKey((String)d, adapterId))));
    }

    public synchronized RocksDBMetadataTable getMetadataTable(MetadataType type) {
        if (metadataOptions == null) {
            RocksDB.loadLibrary();
            metadataOptions = new Options().setCreateIfMissing(true).optimizeForSmallDb();
        }
        String directory = this.subDirectory + "/" + type.name();
        return (RocksDBMetadataTable)this.metadataTableCache.get(this.keyCache.get((Object)directory, d -> new CacheKey((String)d, type.equals((Object)MetadataType.STATS))));
    }

    public boolean indexTableExists(String indexName) {
        for (String key : this.keyCache.asMap().keySet()) {
            if (!key.substring(this.subDirectory.length()).contains(indexName)) continue;
            return true;
        }
        String[] listing = new File(this.subDirectory).list((dir, name) -> name.contains(indexName));
        return listing != null && listing.length > 0;
    }

    public boolean metadataTableExists(MetadataType type) {
        return this.keyCache.getIfPresent((Object)(this.subDirectory + "/" + type.name())) != null || new File(this.subDirectory + "/" + type.name()).exists();
    }

    public void close(String indexName, String typeName) {
        String prefix = RocksDBUtils.getTablePrefix(typeName, indexName);
        for (Map.Entry e : this.keyCache.asMap().entrySet()) {
            String key = (String)e.getKey();
            if (!key.substring(this.subDirectory.length() + 1).startsWith(prefix)) continue;
            this.keyCache.invalidate((Object)key);
            AbstractRocksDBTable indexTable = (AbstractRocksDBTable)this.indexTableCache.getIfPresent(e.getValue());
            if (indexTable == null) {
                indexTable = (AbstractRocksDBTable)this.dataIndexTableCache.getIfPresent(e.getValue());
            }
            if (indexTable == null) continue;
            this.indexTableCache.invalidate(e.getValue());
            this.dataIndexTableCache.invalidate(e.getValue());
            indexTable.close();
        }
    }

    public boolean isCompactOnWrite() {
        return this.compactOnWrite;
    }

    public boolean isVisibilityEnabled() {
        return this.visibilityEnabled;
    }

    public List<RocksDBIndexTable> getIndexTables(Predicate<RocksDBIndexTable> filter) {
        return this.indexTableCache.asMap().values().stream().filter(filter).collect(Collectors.toList());
    }

    public List<RocksDBDataIndexTable> getDataIndexTables(Predicate<RocksDBDataIndexTable> filter) {
        return this.dataIndexTableCache.asMap().values().stream().filter(filter).collect(Collectors.toList());
    }

    public List<RocksDBMetadataTable> getMetadataTables(Predicate<RocksDBMetadataTable> filter) {
        return this.metadataTableCache.asMap().values().stream().filter(filter).collect(Collectors.toList());
    }

    public void mergeData() {
        this.indexTableCache.asMap().values().parallelStream().forEach(db -> db.compact());
        this.dataIndexTableCache.asMap().values().parallelStream().forEach(db -> db.compact());
    }

    public void mergeMetadata() {
        this.metadataTableCache.asMap().values().parallelStream().forEach(db -> db.compact());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.keyCache.invalidateAll();
        this.indexTableCache.asMap().values().forEach(db -> db.close());
        this.indexTableCache.invalidateAll();
        this.dataIndexTableCache.asMap().values().forEach(db -> db.close());
        this.dataIndexTableCache.invalidateAll();
        this.metadataTableCache.asMap().values().forEach(db -> db.close());
        this.metadataTableCache.invalidateAll();
        RocksDBClient rocksDBClient = this;
        synchronized (rocksDBClient) {
            if (this.batchWriteOptions != null) {
                this.batchWriteOptions.close();
                this.batchWriteOptions = null;
            }
        }
    }

    private static class DataIndexCacheKey
    extends CacheKey {
        protected final short adapterId;

        public DataIndexCacheKey(String directory, short adapterId) {
            super(directory, false);
            this.adapterId = adapterId;
        }

        private DataIndexCacheKey(String directory, boolean requiresTimestamp, short adapterId) {
            super(directory, requiresTimestamp);
            this.adapterId = adapterId;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + this.adapterId;
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IndexCacheKey other = (IndexCacheKey)obj;
            return this.adapterId == other.adapterId;
        }
    }

    private static class IndexCacheKey
    extends DataIndexCacheKey {
        protected final byte[] partition;

        public IndexCacheKey(String directory, short adapterId, byte[] partition, boolean requiresTimestamp) {
            super(directory, requiresTimestamp, adapterId);
            this.partition = partition;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + this.adapterId;
            result = 31 * result + Arrays.hashCode(this.partition);
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IndexCacheKey other = (IndexCacheKey)obj;
            if (this.adapterId != other.adapterId) {
                return false;
            }
            return Arrays.equals(this.partition, other.partition);
        }
    }

    private static class CacheKey {
        protected final String directory;
        protected final boolean requiresTimestamp;

        public CacheKey(String directory, boolean requiresTimestamp) {
            this.directory = directory;
            this.requiresTimestamp = requiresTimestamp;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.directory == null ? 0 : this.directory.hashCode());
            result = 31 * result + (this.requiresTimestamp ? 1231 : 1237);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            if (this.directory == null ? other.directory != null : !this.directory.equals(other.directory)) {
                return false;
            }
            return this.requiresTimestamp == other.requiresTimestamp;
        }
    }
}

