/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.datastore.rocksdb.util;

import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import com.google.common.primitives.UnsignedBytes;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.locationtech.geowave.core.store.CloseableIterator;
import org.locationtech.geowave.core.store.entities.GeoWaveRow;
import org.locationtech.geowave.datastore.rocksdb.util.DataIndexReverseRowIterator;
import org.rocksdb.RocksIterator;

public class DataIndexBoundedReverseRowIterator
implements CloseableIterator<GeoWaveRow> {
    private final DataIndexReverseRowIterator delegate;
    private final PeekingIterator<GeoWaveRow> peekingIterator;
    private final byte[] startDataId;
    boolean hasNext = true;

    public DataIndexBoundedReverseRowIterator(byte[] startDataId, RocksIterator it, short adapterId, boolean visiblityEnabled) {
        this.delegate = new DataIndexReverseRowIterator(it, adapterId, visiblityEnabled);
        this.startDataId = startDataId;
        this.peekingIterator = Iterators.peekingIterator((Iterator)((Object)this.delegate));
    }

    public boolean hasNext() {
        if (!this.delegate.closed && this.peekingIterator.hasNext() && UnsignedBytes.lexicographicalComparator().compare(this.startDataId, ((GeoWaveRow)this.peekingIterator.peek()).getDataId()) <= 0) {
            return true;
        }
        this.hasNext = false;
        return false;
    }

    public GeoWaveRow next() {
        if (!this.hasNext) {
            throw new NoSuchElementException();
        }
        return (GeoWaveRow)this.peekingIterator.next();
    }

    public void close() {
        this.delegate.close();
        this.hasNext = false;
    }
}

