/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.datastore.rocksdb.util;

import com.google.common.util.concurrent.MoreExecutors;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import org.rocksdb.Options;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.WriteBatch;
import org.rocksdb.WriteOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRocksDBTable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractRocksDBTable.class);
    private static final int BATCH_WRITE_THREAD_SIZE = 16;
    private static final ExecutorService BATCH_WRITE_THREADS = MoreExecutors.getExitingExecutorService((ThreadPoolExecutor)((ThreadPoolExecutor)Executors.newFixedThreadPool(16)));
    private static final int MAX_CONCURRENT_WRITE = 100;
    private final Object BATCH_WRITE_MUTEX = new Object();
    private final Semaphore writeSemaphore = new Semaphore(100);
    private WriteBatch currentBatch;
    private final int batchSize;
    private RocksDB writeDb;
    private final Options writeOptions;
    private final WriteOptions batchWriteOptions;
    protected final String subDirectory;
    private boolean exists;
    protected final short adapterId;
    protected boolean visibilityEnabled;
    protected boolean compactOnWrite;
    private final boolean batchWrite;

    public AbstractRocksDBTable(Options writeOptions, WriteOptions batchWriteOptions, String subDirectory, short adapterId, boolean visibilityEnabled, boolean compactOnWrite, int batchSize) {
        this.writeOptions = writeOptions;
        this.batchWriteOptions = batchWriteOptions;
        this.subDirectory = subDirectory;
        this.adapterId = adapterId;
        this.exists = new File(subDirectory).exists();
        this.visibilityEnabled = visibilityEnabled;
        this.compactOnWrite = compactOnWrite;
        this.batchSize = batchSize;
        this.batchWrite = batchSize > 1;
    }

    public void delete(byte[] key) {
        RocksDB db = this.getDb(true);
        if (db == null) {
            LOGGER.warn("Unable to delete key because directory '" + this.subDirectory + "' doesn't exist");
            return;
        }
        try {
            db.singleDelete(key);
        }
        catch (RocksDBException e) {
            LOGGER.warn("Unable to delete key", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(justification="The null check outside of the synchronized block is intentional to minimize the need for synchronization.")
    protected void put(byte[] key, byte[] value) {
        if (this.batchWrite) {
            WriteBatch thisBatch = this.currentBatch;
            if (thisBatch == null) {
                Object object = this.BATCH_WRITE_MUTEX;
                synchronized (object) {
                    if (this.currentBatch == null) {
                        this.currentBatch = new WriteBatch();
                    }
                    thisBatch = this.currentBatch;
                }
            }
            try {
                thisBatch.put(key, value);
            }
            catch (RocksDBException e) {
                LOGGER.warn("Unable to add data to batched write", (Throwable)e);
            }
            if (thisBatch.count() >= this.batchSize) {
                Object e = this.BATCH_WRITE_MUTEX;
                synchronized (e) {
                    if (this.currentBatch != null) {
                        this.flushWriteQueue();
                    }
                }
            }
        } else {
            RocksDB db = this.getDb(false);
            try {
                db.put(key, value);
            }
            catch (RocksDBException e) {
                LOGGER.warn("Unable to write key-value", (Throwable)e);
            }
        }
    }

    private void flushWriteQueue() {
        try {
            this.writeSemaphore.acquire();
            CompletableFuture.runAsync(new BatchWriter(this.currentBatch, this.getDb(false), this.batchWriteOptions, this.writeSemaphore), BATCH_WRITE_THREADS);
        }
        catch (InterruptedException e) {
            LOGGER.warn("async write semaphore interrupted", (Throwable)e);
            this.writeSemaphore.release();
        }
        this.currentBatch = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(justification="The null check outside of the synchronized block is intentional to minimize the need for synchronization.")
    public void flush() {
        if (this.batchWrite) {
            Object object = this.BATCH_WRITE_MUTEX;
            synchronized (object) {
                if (this.currentBatch != null) {
                    this.flushWriteQueue();
                }
                this.waitForBatchWrite();
            }
        }
        this.internalFlush();
    }

    protected void internalFlush() {
        if (this.compactOnWrite) {
            RocksDB db = this.getDb(true);
            if (db == null) {
                return;
            }
            try {
                db.compactRange();
            }
            catch (RocksDBException e) {
                LOGGER.warn("Unable to compact range", (Throwable)e);
            }
        }
    }

    public void compact() {
        RocksDB db = this.getDb(true);
        if (db == null) {
            return;
        }
        try {
            db.compactRange();
        }
        catch (RocksDBException e) {
            LOGGER.warn("Unable to force compacting range", (Throwable)e);
        }
    }

    private void waitForBatchWrite() {
        if (this.batchWrite) {
            try {
                this.writeSemaphore.acquire(100);
            }
            catch (InterruptedException e) {
                LOGGER.warn("Unable to wait for batch write to complete");
            }
            this.writeSemaphore.release(100);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.waitForBatchWrite();
        AbstractRocksDBTable abstractRocksDBTable = this;
        synchronized (abstractRocksDBTable) {
            if (this.writeDb != null) {
                this.writeDb.close();
                this.writeDb = null;
            }
        }
    }

    public String getSubDirectory() {
        return this.subDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(justification="double check for null is intentional to avoid synchronized blocks when not needed.")
    public RocksDB getDb(boolean read) {
        if (this.writeDb == null) {
            AbstractRocksDBTable abstractRocksDBTable = this;
            synchronized (abstractRocksDBTable) {
                if (this.writeDb == null) {
                    if (read && !this.exists) {
                        return null;
                    }
                    try {
                        if (this.exists || new File(this.subDirectory).mkdirs()) {
                            this.exists = true;
                            this.writeDb = RocksDB.open((Options)this.writeOptions, (String)this.subDirectory);
                        } else {
                            LOGGER.error("Unable to open to create directory '" + this.subDirectory + "'");
                        }
                    }
                    catch (RocksDBException e) {
                        LOGGER.error("Unable to open for writing", (Throwable)e);
                    }
                }
            }
        }
        return this.writeDb;
    }

    private static class BatchWriter
    implements Runnable {
        private final WriteBatch dataToWrite;
        private final RocksDB db;
        private final WriteOptions options;
        private final Semaphore writeSemaphore;

        private BatchWriter(WriteBatch dataToWrite, RocksDB db, WriteOptions options, Semaphore writeSemaphore) {
            this.dataToWrite = dataToWrite;
            this.db = db;
            this.options = options;
            this.writeSemaphore = writeSemaphore;
        }

        @Override
        public void run() {
            try {
                this.db.write(this.options, this.dataToWrite);
                this.dataToWrite.close();
            }
            catch (RocksDBException e) {
                LOGGER.warn("Unable to write batch", (Throwable)e);
            }
            finally {
                this.writeSemaphore.release();
            }
        }
    }
}

