/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.datastore.rocksdb.util;

import java.util.NoSuchElementException;
import org.locationtech.geowave.core.store.CloseableIterator;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksIterator;

public abstract class AbstractRocksDBIterator<T>
implements CloseableIterator<T> {
    protected boolean closed = false;
    protected ReadOptions options;
    protected RocksIterator it;

    public AbstractRocksDBIterator(ReadOptions options, RocksIterator it) {
        this.options = options;
        this.it = it;
    }

    public boolean hasNext() {
        return !this.closed && this.it.isValid();
    }

    public T next() {
        if (this.closed) {
            throw new NoSuchElementException();
        }
        T retVal = this.readRow(this.it.key(), this.it.value());
        this.advance();
        return retVal;
    }

    protected void advance() {
        this.it.next();
    }

    protected abstract T readRow(byte[] var1, byte[] var2);

    public void close() {
        this.closed = true;
        if (this.it != null) {
            this.it.close();
            this.it = null;
        }
        if (this.options != null) {
            this.options.close();
            this.options = null;
        }
    }
}

