/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.datastore.rocksdb.operations;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import org.locationtech.geowave.core.index.ByteArray;
import org.locationtech.geowave.core.store.entities.GeoWaveRow;
import org.locationtech.geowave.core.store.entities.GeoWaveValue;
import org.locationtech.geowave.core.store.operations.RowWriter;
import org.locationtech.geowave.datastore.rocksdb.util.RocksDBClient;
import org.locationtech.geowave.datastore.rocksdb.util.RocksDBIndexTable;
import org.locationtech.geowave.datastore.rocksdb.util.RocksDBUtils;

public class RocksDBWriter
implements RowWriter {
    private final RocksDBClient client;
    private final String indexNamePrefix;
    private final short adapterId;
    private final LoadingCache<ByteArray, RocksDBIndexTable> tableCache = Caffeine.newBuilder().build(partitionKey -> this.getTable(partitionKey.getBytes()));
    private final boolean isTimestampRequired;

    public RocksDBWriter(RocksDBClient client, short adapterId, String typeName, String indexName, boolean isTimestampRequired) {
        this.client = client;
        this.adapterId = adapterId;
        this.indexNamePrefix = RocksDBUtils.getTablePrefix(typeName, indexName);
        this.isTimestampRequired = isTimestampRequired;
    }

    private RocksDBIndexTable getTable(byte[] partitionKey) {
        return RocksDBUtils.getIndexTableFromPrefix(this.client, this.indexNamePrefix, this.adapterId, partitionKey, this.isTimestampRequired);
    }

    public void write(GeoWaveRow[] rows) {
        for (GeoWaveRow row : rows) {
            this.write(row);
        }
    }

    public void write(GeoWaveRow row) {
        ByteArray partitionKey = row.getPartitionKey() == null || row.getPartitionKey().length == 0 ? RocksDBUtils.EMPTY_PARTITION_KEY : new ByteArray(row.getPartitionKey());
        for (GeoWaveValue value : row.getFieldValues()) {
            ((RocksDBIndexTable)this.tableCache.get((Object)partitionKey)).add(row.getSortKey(), row.getDataId(), (short)row.getNumberOfDuplicates(), value);
        }
    }

    public void flush() {
        this.tableCache.asMap().forEach((k, v) -> v.flush());
    }

    public void close() {
        this.flush();
        this.tableCache.invalidateAll();
    }
}

