/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.datastore.rocksdb.operations;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.Arrays;
import org.locationtech.geowave.core.store.adapter.InternalAdapterStore;
import org.locationtech.geowave.core.store.adapter.InternalDataAdapter;
import org.locationtech.geowave.core.store.adapter.PersistentAdapterStore;
import org.locationtech.geowave.core.store.entities.GeoWaveKey;
import org.locationtech.geowave.core.store.entities.GeoWaveRow;
import org.locationtech.geowave.core.store.entities.GeoWaveRowImpl;
import org.locationtech.geowave.core.store.operations.RowDeleter;
import org.locationtech.geowave.datastore.rocksdb.util.RocksDBClient;
import org.locationtech.geowave.datastore.rocksdb.util.RocksDBIndexTable;
import org.locationtech.geowave.datastore.rocksdb.util.RocksDBRow;
import org.locationtech.geowave.datastore.rocksdb.util.RocksDBUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocksDBRowDeleter
implements RowDeleter {
    private static final Logger LOGGER = LoggerFactory.getLogger(RocksDBRowDeleter.class);
    private final LoadingCache<CacheKey, RocksDBIndexTable> tableCache = Caffeine.newBuilder().build(nameAndAdapterId -> this.getIndexTable((CacheKey)nameAndAdapterId));
    private final RocksDBClient client;
    private final PersistentAdapterStore adapterStore;
    private final InternalAdapterStore internalAdapterStore;
    private final String indexName;

    public RocksDBRowDeleter(RocksDBClient client, PersistentAdapterStore adapterStore, InternalAdapterStore internalAdapterStore, String indexName) {
        this.client = client;
        this.adapterStore = adapterStore;
        this.internalAdapterStore = internalAdapterStore;
        this.indexName = indexName;
    }

    public void close() {
        this.tableCache.asMap().forEach((k, v) -> v.flush());
        this.tableCache.invalidateAll();
    }

    private RocksDBIndexTable getIndexTable(CacheKey cacheKey) {
        return RocksDBUtils.getIndexTable(this.client, cacheKey.tableName, cacheKey.adapterId, cacheKey.partition, RocksDBUtils.isSortByTime((InternalDataAdapter)this.adapterStore.getAdapter((Object)cacheKey.adapterId)));
    }

    public void delete(GeoWaveRow row) {
        RocksDBIndexTable table = (RocksDBIndexTable)this.tableCache.get((Object)new CacheKey(RocksDBUtils.getTableName(this.internalAdapterStore.getTypeName(row.getAdapterId()), this.indexName, row.getPartitionKey()), row.getAdapterId(), row.getPartitionKey()));
        if (row instanceof GeoWaveRowImpl) {
            GeoWaveKey key = ((GeoWaveRowImpl)row).getKey();
            if (key instanceof RocksDBRow) {
                RocksDBRowDeleter.deleteRow(table, (RocksDBRow)key);
            } else {
                LOGGER.info("Unable to convert scanned row into RocksDBRow for deletion.  Row is of type GeoWaveRowImpl.");
                table.delete(key.getSortKey(), key.getDataId());
            }
        } else if (row instanceof RocksDBRow) {
            RocksDBRowDeleter.deleteRow(table, (RocksDBRow)row);
        } else {
            LOGGER.info("Unable to convert scanned row into RocksDBRow for deletion. Row is of type " + row.getClass());
            table.delete(row.getSortKey(), row.getDataId());
        }
    }

    private static void deleteRow(RocksDBIndexTable table, RocksDBRow row) {
        Arrays.stream(row.getKeys()).forEach(k -> table.delete((byte[])k));
    }

    public void flush() {
    }

    private static class CacheKey {
        private final String tableName;
        private final short adapterId;
        private final byte[] partition;

        public CacheKey(String tableName, short adapterId, byte[] partition) {
            this.tableName = tableName;
            this.adapterId = adapterId;
            this.partition = partition;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.tableName == null ? 0 : this.tableName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            return !(this.tableName == null ? other.tableName != null : !this.tableName.equals(other.tableName));
        }
    }
}

