/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.datastore.rocksdb.operations;

import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.locationtech.geowave.core.index.ByteArrayRange;
import org.locationtech.geowave.core.index.SinglePartitionQueryRanges;
import org.locationtech.geowave.core.store.CloseableIterator;
import org.locationtech.geowave.core.store.CloseableIteratorWrapper;
import org.locationtech.geowave.core.store.entities.GeoWaveRow;
import org.locationtech.geowave.core.store.entities.GeoWaveRowIteratorTransformer;
import org.locationtech.geowave.core.store.entities.GeoWaveRowMergingIterator;
import org.locationtech.geowave.core.store.operations.DataIndexReaderParams;
import org.locationtech.geowave.core.store.operations.RangeReaderParams;
import org.locationtech.geowave.core.store.operations.ReaderParams;
import org.locationtech.geowave.core.store.operations.RowReader;
import org.locationtech.geowave.core.store.query.filter.ClientVisibilityFilter;
import org.locationtech.geowave.core.store.util.DataStoreUtils;
import org.locationtech.geowave.datastore.rocksdb.operations.RocksDBQueryExecution;
import org.locationtech.geowave.datastore.rocksdb.util.RocksDBClient;
import org.locationtech.geowave.datastore.rocksdb.util.RocksDBDataIndexTable;
import org.locationtech.geowave.datastore.rocksdb.util.RocksDBUtils;
import org.locationtech.geowave.mapreduce.splits.GeoWaveRowRange;
import org.locationtech.geowave.mapreduce.splits.RecordReaderParams;

public class RocksDBReader<T>
implements RowReader<T> {
    private final CloseableIterator<T> iterator;

    public RocksDBReader(RocksDBClient client, ReaderParams<T> readerParams, boolean async) {
        this.iterator = this.createIteratorForReader(client, readerParams, readerParams.getRowTransformer(), false);
    }

    public RocksDBReader(RocksDBClient client, RecordReaderParams recordReaderParams) {
        this.iterator = this.createIteratorForRecordReader(client, recordReaderParams);
    }

    public RocksDBReader(RocksDBClient client, DataIndexReaderParams dataIndexReaderParams) {
        this.iterator = new CloseableIterator.Wrapper(this.createIteratorForDataIndexReader(client, dataIndexReaderParams));
    }

    private CloseableIterator<T> createIteratorForReader(RocksDBClient client, ReaderParams<T> readerParams, GeoWaveRowIteratorTransformer<T> rowTransformer, boolean async) {
        Collection ranges = readerParams.getQueryRanges().getPartitionQueryRanges();
        HashSet authorizations = Sets.newHashSet((Object[])readerParams.getAdditionalAuthorizations());
        if (ranges != null && !ranges.isEmpty()) {
            return this.createIterator(client, (RangeReaderParams<T>)readerParams, (GeoWaveRowIteratorTransformer<T>)readerParams.getRowTransformer(), ranges, authorizations, async);
        }
        final ArrayList iterators = new ArrayList();
        for (short adapterId : readerParams.getAdapterIds()) {
            Pair<Boolean, Boolean> groupByRowAndSortByTime = RocksDBUtils.isGroupByRowAndIsSortByTime(readerParams, adapterId);
            String indexNamePrefix = RocksDBUtils.getTablePrefix(readerParams.getInternalAdapterStore().getTypeName(adapterId), readerParams.getIndex().getName());
            Stream<CloseableIterator> streamIt = RocksDBUtils.getPartitions(client.getSubDirectory(), indexNamePrefix).stream().map(p -> RocksDBUtils.getIndexTableFromPrefix(client, indexNamePrefix, adapterId, p.getBytes(), (Boolean)groupByRowAndSortByTime.getRight()).iterator());
            iterators.addAll(streamIt.collect(Collectors.toList()));
        }
        return this.wrapResults(new Closeable(){
            AtomicBoolean closed = new AtomicBoolean(false);

            @Override
            public void close() throws IOException {
                if (!this.closed.getAndSet(true)) {
                    iterators.forEach(it -> it.close());
                }
            }
        }, Iterators.concat(iterators.iterator()), (RangeReaderParams<T>)readerParams, rowTransformer, authorizations, client.isVisibilityEnabled());
    }

    private CloseableIterator<T> createIterator(RocksDBClient client, RangeReaderParams<T> readerParams, GeoWaveRowIteratorTransformer<T> rowTransformer, Collection<SinglePartitionQueryRanges> ranges, Set<String> authorizations, boolean async) {
        Iterator it = Arrays.stream(ArrayUtils.toObject((short[])readerParams.getAdapterIds())).map(adapterId -> new RocksDBQueryExecution(client, RocksDBUtils.getTablePrefix(readerParams.getInternalAdapterStore().getTypeName(adapterId.shortValue()), readerParams.getIndex().getName()), (short)adapterId, rowTransformer, ranges, (Predicate<GeoWaveRow>)new ClientVisibilityFilter(authorizations), DataStoreUtils.isMergingIteratorRequired((RangeReaderParams)readerParams, (boolean)client.isVisibilityEnabled()), async, RocksDBUtils.isGroupByRowAndIsSortByTime(readerParams, adapterId), RocksDBUtils.isSortByKeyRequired(readerParams)).results()).iterator();
        final CloseableIterator[] itArray = (CloseableIterator[])Iterators.toArray(it, CloseableIterator.class);
        return new CloseableIteratorWrapper(new Closeable(){
            AtomicBoolean closed = new AtomicBoolean(false);

            @Override
            public void close() throws IOException {
                if (!this.closed.getAndSet(true)) {
                    Arrays.stream(itArray).forEach(it -> it.close());
                }
            }
        }, Iterators.concat((Iterator[])itArray));
    }

    private CloseableIterator<T> createIteratorForRecordReader(RocksDBClient client, RecordReaderParams recordReaderParams) {
        GeoWaveRowRange range = recordReaderParams.getRowRange();
        byte[] startKey = range.isInfiniteStartSortKey() ? null : range.getStartSortKey();
        byte[] stopKey = range.isInfiniteStopSortKey() ? null : range.getEndSortKey();
        SinglePartitionQueryRanges partitionRange = new SinglePartitionQueryRanges(range.getPartitionKey(), Collections.singleton(new ByteArrayRange(startKey, stopKey)));
        HashSet authorizations = Sets.newHashSet((Object[])recordReaderParams.getAdditionalAuthorizations());
        return this.createIterator(client, (RangeReaderParams<T>)recordReaderParams, (GeoWaveRowIteratorTransformer<T>)GeoWaveRowIteratorTransformer.NO_OP_TRANSFORMER, (Collection<SinglePartitionQueryRanges>)Collections.singleton(partitionRange), authorizations, false);
    }

    private Iterator<GeoWaveRow> createIteratorForDataIndexReader(RocksDBClient client, DataIndexReaderParams dataIndexReaderParams) {
        RocksDBDataIndexTable dataIndexTable = RocksDBUtils.getDataIndexTable(client, dataIndexReaderParams.getInternalAdapterStore().getTypeName(dataIndexReaderParams.getAdapterId()), dataIndexReaderParams.getAdapterId());
        Object iterator = dataIndexReaderParams.getDataIds() != null ? dataIndexTable.dataIndexIterator(dataIndexReaderParams.getDataIds()) : dataIndexTable.dataIndexIterator(dataIndexReaderParams.getStartInclusiveDataId(), dataIndexReaderParams.getEndInclusiveDataId(), dataIndexReaderParams.isReverse());
        if (client.isVisibilityEnabled()) {
            Stream stream = Streams.stream(iterator);
            HashSet authorizations = Sets.newHashSet((Object[])dataIndexReaderParams.getAdditionalAuthorizations());
            stream = stream.filter(new ClientVisibilityFilter((Set)authorizations));
            iterator = stream.iterator();
        }
        return iterator;
    }

    private CloseableIterator<T> wrapResults(Closeable closeable, Iterator<GeoWaveRow> results, RangeReaderParams<T> params, GeoWaveRowIteratorTransformer<T> rowTransformer, Set<String> authorizations, boolean visibilityEnabled) {
        Stream stream = Streams.stream(results);
        if (visibilityEnabled) {
            stream = stream.filter(new ClientVisibilityFilter(authorizations));
        }
        GeoWaveRowMergingIterator iterator = stream.iterator();
        return new CloseableIteratorWrapper(closeable, (Iterator)rowTransformer.apply(RocksDBReader.sortBySortKeyIfRequired(params, (Iterator<GeoWaveRow>)(DataStoreUtils.isMergingIteratorRequired(params, (boolean)visibilityEnabled) ? new GeoWaveRowMergingIterator((Iterator)iterator) : iterator))));
    }

    private static Iterator<GeoWaveRow> sortBySortKeyIfRequired(RangeReaderParams<?> params, Iterator<GeoWaveRow> it) {
        if (RocksDBUtils.isSortByKeyRequired(params)) {
            return RocksDBUtils.sortBySortKey(it);
        }
        return it;
    }

    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    public T next() {
        return (T)this.iterator.next();
    }

    public void close() {
        this.iterator.close();
    }
}

