/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.datastore.rocksdb.operations;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.collect.Iterators;
import com.google.common.collect.Streams;
import com.google.common.primitives.UnsignedBytes;
import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.locationtech.geowave.core.index.ByteArray;
import org.locationtech.geowave.core.index.ByteArrayRange;
import org.locationtech.geowave.core.index.SinglePartitionQueryRanges;
import org.locationtech.geowave.core.store.CloseableIterator;
import org.locationtech.geowave.core.store.CloseableIteratorWrapper;
import org.locationtech.geowave.core.store.entities.GeoWaveRow;
import org.locationtech.geowave.core.store.entities.GeoWaveRowIteratorTransformer;
import org.locationtech.geowave.core.store.entities.GeoWaveRowMergingIterator;
import org.locationtech.geowave.datastore.rocksdb.util.RocksDBClient;
import org.locationtech.geowave.datastore.rocksdb.util.RocksDBIndexTable;
import org.locationtech.geowave.datastore.rocksdb.util.RocksDBUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocksDBQueryExecution<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RocksDBQueryExecution.class);
    private static ByteArray EMPTY_PARTITION_KEY = new ByteArray();
    private final LoadingCache<ByteArray, RocksDBIndexTable> setCache = Caffeine.newBuilder().build(partitionKey -> this.getTable(partitionKey.getBytes()));
    private final Collection<SinglePartitionQueryRanges> ranges;
    private final short adapterId;
    private final String indexNamePrefix;
    private final RocksDBClient client;
    private final GeoWaveRowIteratorTransformer<T> rowTransformer;
    private final Predicate<GeoWaveRow> filter;
    private final boolean rowMerging;
    private final Pair<Boolean, Boolean> groupByRowAndSortByTimePair;
    private final boolean isSortFinalResultsBySortKey;

    protected RocksDBQueryExecution(RocksDBClient client, String indexNamePrefix, short adapterId, GeoWaveRowIteratorTransformer<T> rowTransformer, Collection<SinglePartitionQueryRanges> ranges, Predicate<GeoWaveRow> filter, boolean rowMerging, boolean async, Pair<Boolean, Boolean> groupByRowAndSortByTimePair, boolean isSortFinalResultsBySortKey) {
        this.client = client;
        this.indexNamePrefix = indexNamePrefix;
        this.adapterId = adapterId;
        this.rowTransformer = rowTransformer;
        this.ranges = ranges;
        this.filter = filter;
        this.rowMerging = rowMerging;
        this.groupByRowAndSortByTimePair = groupByRowAndSortByTimePair;
        this.isSortFinalResultsBySortKey = isSortFinalResultsBySortKey;
    }

    private RocksDBIndexTable getTable(byte[] partitionKey) {
        return RocksDBUtils.getIndexTableFromPrefix(this.client, this.indexNamePrefix, this.adapterId, partitionKey, (Boolean)this.groupByRowAndSortByTimePair.getRight());
    }

    public CloseableIterator<T> results() {
        ArrayList<RangeReadInfo> reads = new ArrayList<RangeReadInfo>();
        for (SinglePartitionQueryRanges r : this.ranges) {
            for (ByteArrayRange range : r.getSortKeyRanges()) {
                reads.add(new RangeReadInfo(r.getPartitionKey(), range));
            }
        }
        return this.executeQuery(reads);
    }

    public CloseableIterator<T> executeQuery(List<RangeReadInfo> reads) {
        if (this.isSortFinalResultsBySortKey) {
            reads.sort(ScoreOrderComparator.SINGLETON);
        }
        final List iterators = reads.stream().map(r -> {
            ByteArray partitionKey = r.partitionKey == null || r.partitionKey.length == 0 ? EMPTY_PARTITION_KEY : new ByteArray(r.partitionKey);
            return ((RocksDBIndexTable)this.setCache.get((Object)partitionKey)).iterator(r.sortKeyRange);
        }).collect(Collectors.toList());
        return this.transformAndFilter((CloseableIterator<GeoWaveRow>)new CloseableIteratorWrapper(new Closeable(){

            @Override
            public void close() throws IOException {
                iterators.forEach(i -> i.close());
            }
        }, Iterators.concat(iterators.iterator())));
    }

    private CloseableIterator<T> transformAndFilter(CloseableIterator<GeoWaveRow> result) {
        GeoWaveRowMergingIterator iterator = Streams.stream(result).filter(this.filter).iterator();
        return new CloseableIteratorWrapper(result, (Iterator)this.rowTransformer.apply(RocksDBQueryExecution.sortByKeyIfRequired(this.isSortFinalResultsBySortKey, (Iterator<GeoWaveRow>)(this.rowMerging ? new GeoWaveRowMergingIterator((Iterator)iterator) : iterator))));
    }

    private static Iterator<GeoWaveRow> sortByKeyIfRequired(boolean isRequired, Iterator<GeoWaveRow> it) {
        if (isRequired) {
            return RocksDBUtils.sortBySortKey(it);
        }
        return it;
    }

    private static class ScoreOrderComparator
    implements Comparator<RangeReadInfo>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private static final ScoreOrderComparator SINGLETON = new ScoreOrderComparator();

        private ScoreOrderComparator() {
        }

        @Override
        public int compare(RangeReadInfo o1, RangeReadInfo o2) {
            int comp = UnsignedBytes.lexicographicalComparator().compare(o1.sortKeyRange.getStart(), o2.sortKeyRange.getStart());
            if (comp != 0) {
                return comp;
            }
            comp = UnsignedBytes.lexicographicalComparator().compare(o1.sortKeyRange.getEnd(), o2.sortKeyRange.getEnd());
            if (comp != 0) {
                return comp;
            }
            byte[] otherComp = o2.partitionKey == null ? new byte[]{} : o2.partitionKey;
            byte[] thisComp = o1.partitionKey == null ? new byte[]{} : o1.partitionKey;
            return UnsignedBytes.lexicographicalComparator().compare(thisComp, otherComp);
        }
    }

    private static class RangeReadInfo {
        byte[] partitionKey;
        ByteArrayRange sortKeyRange;

        public RangeReadInfo(byte[] partitionKey, ByteArrayRange sortKeyRange) {
            this.partitionKey = partitionKey;
            this.sortKeyRange = sortKeyRange;
        }
    }
}

