/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.datastore.rocksdb.operations;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.io.FileUtils;
import org.locationtech.geowave.core.store.adapter.AdapterIndexMappingStore;
import org.locationtech.geowave.core.store.adapter.InternalAdapterStore;
import org.locationtech.geowave.core.store.adapter.InternalDataAdapter;
import org.locationtech.geowave.core.store.adapter.PersistentAdapterStore;
import org.locationtech.geowave.core.store.adapter.statistics.DataStatisticsStore;
import org.locationtech.geowave.core.store.api.Index;
import org.locationtech.geowave.core.store.entities.GeoWaveRow;
import org.locationtech.geowave.core.store.operations.DataIndexReaderParams;
import org.locationtech.geowave.core.store.operations.Deleter;
import org.locationtech.geowave.core.store.operations.MetadataDeleter;
import org.locationtech.geowave.core.store.operations.MetadataReader;
import org.locationtech.geowave.core.store.operations.MetadataType;
import org.locationtech.geowave.core.store.operations.MetadataWriter;
import org.locationtech.geowave.core.store.operations.QueryAndDeleteByRow;
import org.locationtech.geowave.core.store.operations.ReaderParams;
import org.locationtech.geowave.core.store.operations.RowDeleter;
import org.locationtech.geowave.core.store.operations.RowReader;
import org.locationtech.geowave.core.store.operations.RowWriter;
import org.locationtech.geowave.datastore.rocksdb.config.RocksDBOptions;
import org.locationtech.geowave.datastore.rocksdb.operations.RockDBDataIndexWriter;
import org.locationtech.geowave.datastore.rocksdb.operations.RocksDBMetadataDeleter;
import org.locationtech.geowave.datastore.rocksdb.operations.RocksDBMetadataReader;
import org.locationtech.geowave.datastore.rocksdb.operations.RocksDBMetadataWriter;
import org.locationtech.geowave.datastore.rocksdb.operations.RocksDBReader;
import org.locationtech.geowave.datastore.rocksdb.operations.RocksDBRowDeleter;
import org.locationtech.geowave.datastore.rocksdb.operations.RocksDBWriter;
import org.locationtech.geowave.datastore.rocksdb.util.RocksDBClient;
import org.locationtech.geowave.datastore.rocksdb.util.RocksDBClientCache;
import org.locationtech.geowave.datastore.rocksdb.util.RocksDBDataIndexTable;
import org.locationtech.geowave.datastore.rocksdb.util.RocksDBUtils;
import org.locationtech.geowave.mapreduce.MapReduceDataStoreOperations;
import org.locationtech.geowave.mapreduce.splits.RecordReaderParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocksDBOperations
implements MapReduceDataStoreOperations,
Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(RocksDBOperations.class);
    private static final boolean READER_ASYNC = true;
    private final RocksDBClient client;
    private final String directory;
    private final boolean visibilityEnabled;
    private final boolean compactOnWrite;
    private final boolean walOnBatchWrite;
    private final int batchWriteSize;

    public RocksDBOperations(RocksDBOptions options) {
        this.directory = options.getDirectory() + File.separator + (options.getGeoWaveNamespace() == null || options.getGeoWaveNamespace().trim().isEmpty() || "null".equalsIgnoreCase(options.getGeoWaveNamespace()) ? "default" : options.getGeoWaveNamespace());
        this.visibilityEnabled = options.getStoreOptions().isVisibilityEnabled();
        this.compactOnWrite = options.isCompactOnWrite();
        this.batchWriteSize = options.getBatchWriteSize();
        this.walOnBatchWrite = options.isWalOnBatchWrite();
        this.client = RocksDBClientCache.getInstance().getClient(this.directory, this.visibilityEnabled, this.compactOnWrite, this.batchWriteSize, this.walOnBatchWrite);
    }

    public boolean mergeData(Index index, PersistentAdapterStore adapterStore, InternalAdapterStore internalAdapterStore, AdapterIndexMappingStore adapterIndexMappingStore, Integer maxRangeDecomposition) {
        boolean retVal = super.mergeData(index, adapterStore, internalAdapterStore, adapterIndexMappingStore, maxRangeDecomposition);
        this.compactData();
        return retVal;
    }

    public void compactData() {
        this.client.mergeData();
    }

    public boolean mergeStats(DataStatisticsStore statsStore, InternalAdapterStore internalAdapterStore) {
        boolean retVal = super.mergeStats(statsStore, internalAdapterStore);
        this.compactMetadata();
        return retVal;
    }

    public void compactMetadata() {
        this.client.mergeMetadata();
    }

    public boolean indexExists(String indexName) throws IOException {
        return this.client.indexTableExists(indexName);
    }

    public boolean metadataExists(MetadataType type) throws IOException {
        return this.client.metadataTableExists(type);
    }

    public void deleteAll() throws Exception {
        this.close();
        FileUtils.deleteDirectory((File)new File(this.directory));
    }

    public boolean deleteAll(String indexName, String typeName, Short adapterId, String ... additionalAuthorizations) {
        String prefix = RocksDBUtils.getTablePrefix(typeName, indexName);
        this.client.close(indexName, typeName);
        Arrays.stream(new File(this.directory).listFiles((dir, name) -> name.startsWith(prefix))).forEach(f -> {
            try {
                FileUtils.deleteDirectory((File)f);
            }
            catch (IOException e) {
                LOGGER.warn("Unable to delete directory '" + f.getAbsolutePath() + "'", (Throwable)e);
            }
        });
        return true;
    }

    public boolean ensureAuthorizations(String clientUser, String ... authorizations) {
        return true;
    }

    public RowWriter createWriter(Index index, InternalDataAdapter<?> adapter) {
        return new RocksDBWriter(this.client, adapter.getAdapterId(), adapter.getTypeName(), index.getName(), RocksDBUtils.isSortByTime(adapter));
    }

    public RowWriter createDataIndexWriter(InternalDataAdapter<?> adapter) {
        return new RockDBDataIndexWriter(this.client, adapter.getAdapterId(), adapter.getTypeName());
    }

    public MetadataWriter createMetadataWriter(MetadataType metadataType) {
        return new RocksDBMetadataWriter(RocksDBUtils.getMetadataTable(this.client, metadataType));
    }

    public MetadataReader createMetadataReader(MetadataType metadataType) {
        return new RocksDBMetadataReader(RocksDBUtils.getMetadataTable(this.client, metadataType), metadataType);
    }

    public MetadataDeleter createMetadataDeleter(MetadataType metadataType) {
        return new RocksDBMetadataDeleter(RocksDBUtils.getMetadataTable(this.client, metadataType), metadataType);
    }

    public <T> RowReader<T> createReader(ReaderParams<T> readerParams) {
        return new RocksDBReader<T>(this.client, readerParams, true);
    }

    public RowReader<GeoWaveRow> createReader(DataIndexReaderParams readerParams) {
        return new RocksDBReader<GeoWaveRow>(this.client, readerParams);
    }

    public <T> Deleter<T> createDeleter(ReaderParams<T> readerParams) {
        return new QueryAndDeleteByRow(this.createRowDeleter(readerParams.getIndex().getName(), readerParams.getAdapterStore(), readerParams.getInternalAdapterStore(), readerParams.getAdditionalAuthorizations()), new RocksDBReader<T>(this.client, readerParams, false));
    }

    public void delete(DataIndexReaderParams readerParams) {
        String typeName = readerParams.getInternalAdapterStore().getTypeName(readerParams.getAdapterId());
        this.deleteRowsFromDataIndex(readerParams.getDataIds(), readerParams.getAdapterId(), typeName);
    }

    public void deleteRowsFromDataIndex(byte[][] dataIds, short adapterId, String typeName) {
        RocksDBDataIndexTable table = RocksDBUtils.getDataIndexTable(this.client, typeName, adapterId);
        Arrays.stream(dataIds).forEach(d -> table.delete((byte[])d));
        table.flush();
    }

    public RowReader<GeoWaveRow> createReader(RecordReaderParams readerParams) {
        return new RocksDBReader<GeoWaveRow>(this.client, readerParams);
    }

    public RowDeleter createRowDeleter(String indexName, PersistentAdapterStore adapterStore, InternalAdapterStore internalAdapterStore, String ... authorizations) {
        return new RocksDBRowDeleter(this.client, adapterStore, internalAdapterStore, indexName);
    }

    @Override
    public void close() {
        RocksDBClientCache.getInstance().close(this.directory, this.visibilityEnabled, this.compactOnWrite, this.batchWriteSize, this.walOnBatchWrite);
    }

    public RocksDBClient getClient() {
        return this.client;
    }
}

