/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.datastore.rocksdb.operations;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.io.Closeable;
import java.util.Arrays;
import java.util.Iterator;
import org.locationtech.geowave.core.store.CloseableIterator;
import org.locationtech.geowave.core.store.CloseableIteratorWrapper;
import org.locationtech.geowave.core.store.entities.GeoWaveMetadata;
import org.locationtech.geowave.core.store.operations.MetadataQuery;
import org.locationtech.geowave.core.store.operations.MetadataReader;
import org.locationtech.geowave.core.store.operations.MetadataType;
import org.locationtech.geowave.core.store.util.DataStoreUtils;
import org.locationtech.geowave.core.store.util.StatisticsRowIterator;
import org.locationtech.geowave.datastore.rocksdb.util.RocksDBMetadataTable;

public class RocksDBMetadataReader
implements MetadataReader {
    private final RocksDBMetadataTable table;
    private final MetadataType metadataType;

    public RocksDBMetadataReader(RocksDBMetadataTable table, MetadataType metadataType) {
        this.table = table;
        this.metadataType = metadataType;
    }

    public CloseableIterator<GeoWaveMetadata> query(final MetadataQuery query, boolean mergeStats) {
        UnmodifiableIterator originalResults;
        UnmodifiableIterator resultsIt = query.hasPrimaryId() ? (originalResults = this.table.iterator(query.getPrimaryId())) : (originalResults = this.table.iterator());
        if (query.hasPrimaryId() || query.hasSecondaryId()) {
            resultsIt = Iterators.filter(resultsIt, (Predicate)new Predicate<GeoWaveMetadata>(){

                public boolean apply(GeoWaveMetadata input) {
                    if (query.hasPrimaryId() && !DataStoreUtils.startsWithIfStats((byte[])input.getPrimaryId(), (byte[])query.getPrimaryId(), (MetadataType)RocksDBMetadataReader.this.metadataType)) {
                        return false;
                    }
                    return !query.hasSecondaryId() || Arrays.equals(input.getSecondaryId(), query.getSecondaryId());
                }
            });
        }
        boolean isStats = MetadataType.STATS.equals((Object)this.metadataType) && mergeStats;
        CloseableIteratorWrapper retVal = new CloseableIteratorWrapper((Closeable)originalResults, (Iterator)resultsIt);
        return isStats ? new StatisticsRowIterator((CloseableIterator)retVal, query.getAuthorizations()) : retVal;
    }

    public CloseableIterator<GeoWaveMetadata> query(MetadataQuery query) {
        return this.query(query, true);
    }
}

