/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.datastore.rocksdb.operations;

import org.locationtech.geowave.core.store.CloseableIterator;
import org.locationtech.geowave.core.store.entities.GeoWaveMetadata;
import org.locationtech.geowave.core.store.operations.MetadataDeleter;
import org.locationtech.geowave.core.store.operations.MetadataQuery;
import org.locationtech.geowave.core.store.operations.MetadataType;
import org.locationtech.geowave.datastore.rocksdb.operations.RocksDBMetadataReader;
import org.locationtech.geowave.datastore.rocksdb.util.RocksDBGeoWaveMetadata;
import org.locationtech.geowave.datastore.rocksdb.util.RocksDBMetadataTable;

public class RocksDBMetadataDeleter
implements MetadataDeleter {
    private final RocksDBMetadataTable table;
    private final MetadataType metadataType;
    private boolean closed = false;

    public RocksDBMetadataDeleter(RocksDBMetadataTable table, MetadataType metadataType) {
        this.table = table;
        this.metadataType = metadataType;
    }

    public boolean delete(MetadataQuery query) {
        boolean atLeastOneDeletion = false;
        try (CloseableIterator<GeoWaveMetadata> it = new RocksDBMetadataReader(this.table, this.metadataType).query(query, false);){
            while (it.hasNext()) {
                this.table.remove(((RocksDBGeoWaveMetadata)((Object)it.next())).getKey());
                atLeastOneDeletion = true;
            }
        }
        return atLeastOneDeletion;
    }

    public void flush() {
        this.table.flush();
    }

    public void close() throws Exception {
        if (!this.closed) {
            this.flush();
            this.closed = true;
        }
    }
}

