/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.datastore.rocksdb.operations;

import org.locationtech.geowave.core.store.entities.GeoWaveRow;
import org.locationtech.geowave.core.store.entities.GeoWaveValue;
import org.locationtech.geowave.core.store.operations.RowWriter;
import org.locationtech.geowave.datastore.rocksdb.util.RocksDBClient;
import org.locationtech.geowave.datastore.rocksdb.util.RocksDBDataIndexTable;
import org.locationtech.geowave.datastore.rocksdb.util.RocksDBUtils;

public class RockDBDataIndexWriter
implements RowWriter {
    private final RocksDBDataIndexTable table;

    public RockDBDataIndexWriter(RocksDBClient client, short adapterId, String typeName) {
        this.table = RocksDBUtils.getDataIndexTable(client, typeName, adapterId);
    }

    public void write(GeoWaveRow[] rows) {
        for (GeoWaveRow row : rows) {
            this.write(row);
        }
    }

    public void write(GeoWaveRow row) {
        for (GeoWaveValue value : row.getFieldValues()) {
            this.table.add(row.getDataId(), value);
        }
    }

    public void flush() {
        this.table.flush();
    }

    public void close() {
        this.flush();
    }
}

