/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.datastore.rocksdb.config;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.ParametersDelegate;
import com.beust.jcommander.internal.Console;
import java.io.File;
import java.util.Properties;
import org.locationtech.geowave.core.store.BaseDataStoreOptions;
import org.locationtech.geowave.core.store.DataStoreOptions;
import org.locationtech.geowave.core.store.StoreFactoryFamilySpi;
import org.locationtech.geowave.core.store.StoreFactoryOptions;
import org.locationtech.geowave.datastore.rocksdb.RocksDBStoreFactoryFamily;
import org.locationtech.geowave.datastore.rocksdb.util.RocksDBUtils;

public class RocksDBOptions
extends StoreFactoryOptions {
    @Parameter(names={"--dir"}, description="The directory to read/write to.  Defaults to \"rocksdb\" in the working directory.")
    private String dir = "rocksdb";
    @Parameter(names={"--compactOnWrite"}, description="Whether to compact on every write, if false it will only compact on merge. Defaults to true", arity=1)
    private boolean compactOnWrite = true;
    @Parameter(names={"--batchWriteSize"}, description="The size (in records) for each batched write. Anything <= 1 will use synchronous single record writes without batching. Defaults to 1000.")
    private int batchWriteSize = 1000;
    @Parameter(names={"--walOnBatchWrite"}, description="Whether to enable write-ahead-log on batched writes.")
    private boolean walOnBatchWrite = true;
    @ParametersDelegate
    protected BaseDataStoreOptions baseOptions = new BaseDataStoreOptions(){

        public boolean isServerSideLibraryEnabled() {
            return false;
        }

        protected int defaultMaxRangeDecomposition() {
            return RocksDBUtils.ROCKSDB_DEFAULT_MAX_RANGE_DECOMPOSITION;
        }

        protected int defaultAggregationMaxRangeDecomposition() {
            return RocksDBUtils.ROCKSDB_DEFAULT_AGGREGATION_MAX_RANGE_DECOMPOSITION;
        }

        protected boolean defaultEnableVisibility() {
            return false;
        }
    };

    public void validatePluginOptions(Console console) throws ParameterException {
        this.dir = new File(this.dir).getAbsolutePath();
        super.validatePluginOptions(console);
    }

    public void validatePluginOptions(Properties properties, Console console) throws ParameterException {
        this.dir = new File(this.dir).getAbsolutePath();
        super.validatePluginOptions(properties, console);
    }

    public RocksDBOptions() {
    }

    public RocksDBOptions(String geowaveNamespace) {
        super(geowaveNamespace);
    }

    public boolean isCompactOnWrite() {
        return this.compactOnWrite;
    }

    public void setCompactOnWrite(boolean compactOnWrite) {
        this.compactOnWrite = compactOnWrite;
    }

    public void setDirectory(String dir) {
        this.dir = dir;
    }

    public String getDirectory() {
        return this.dir;
    }

    public StoreFactoryFamilySpi getStoreFactory() {
        return new RocksDBStoreFactoryFamily();
    }

    public DataStoreOptions getStoreOptions() {
        return this.baseOptions;
    }

    public int getBatchWriteSize() {
        return this.batchWriteSize;
    }

    public void setBatchWriteSize(int batchWriteSize) {
        this.batchWriteSize = batchWriteSize;
    }

    public boolean isWalOnBatchWrite() {
        return this.walOnBatchWrite;
    }

    public void setWalOnBatchWrite(boolean walOnBatchWrite) {
        this.walOnBatchWrite = walOnBatchWrite;
    }
}

