/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.util;

import java.time.Instant;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.temporal.object.DefaultInstant;
import org.geotools.temporal.object.DefaultPeriod;
import org.geotools.temporal.object.DefaultPosition;
import org.locationtech.geowave.core.geotime.store.query.TemporalConstraints;
import org.locationtech.geowave.core.geotime.store.query.TemporalConstraintsSet;
import org.locationtech.geowave.core.geotime.util.TimeDescriptors;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.temporal.Period;
import org.opengis.temporal.Position;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.threeten.extra.Interval;

public class TimeUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimeUtils.class);
    public static long RESERVED_MILLIS_FOR_NULL = -113L;

    public static long calendarToGMTMillis(Calendar cal) {
        Date date = cal.getTime();
        long time = date.getTime();
        return time;
    }

    public static Filter toDuringFilter(long startTimeMillis, long endTimeMillis, String singleTimeField) {
        FilterFactory2 factory = CommonFactoryFinder.getFilterFactory2();
        DefaultPosition ip1 = new DefaultPosition(new Date(startTimeMillis - 1L));
        DefaultPosition ip2 = new DefaultPosition(new Date(endTimeMillis));
        DefaultPeriod period = new DefaultPeriod((org.opengis.temporal.Instant)new DefaultInstant((Position)ip1), (org.opengis.temporal.Instant)new DefaultInstant((Position)ip2));
        return factory.during((Expression)factory.property(singleTimeField), (Expression)factory.literal((Object)period));
    }

    public static Filter toFilter(long startTimeMillis, long endTimeMillis, String startTimeField, String endTimeField) {
        FilterFactory2 factory = CommonFactoryFinder.getFilterFactory2();
        if (startTimeField.equals(endTimeField)) {
            return factory.and((Filter)factory.greaterOrEqual((Expression)factory.property(startTimeField), (Expression)factory.literal((Object)new Date(startTimeMillis))), (Filter)factory.lessOrEqual((Expression)factory.property(endTimeField), (Expression)factory.literal((Object)new Date(endTimeMillis))));
        }
        return factory.and((Filter)factory.and((Filter)factory.greaterOrEqual((Expression)factory.property(startTimeField), (Expression)factory.literal((Object)new Date(startTimeMillis))), (Filter)factory.lessOrEqual((Expression)factory.property(startTimeField), (Expression)factory.literal((Object)new Date(endTimeMillis)))), (Filter)factory.and((Filter)factory.greaterOrEqual((Expression)factory.property(endTimeField), (Expression)factory.literal((Object)new Date(startTimeMillis))), (Filter)factory.lessOrEqual((Expression)factory.property(endTimeField), (Expression)factory.literal((Object)new Date(endTimeMillis)))));
    }

    public static long getTimeMillis(Object timeObj) {
        if (timeObj != null) {
            if (timeObj instanceof Calendar) {
                return TimeUtils.calendarToGMTMillis((Calendar)timeObj);
            }
            if (timeObj instanceof Date) {
                return ((Date)timeObj).getTime();
            }
            if (timeObj instanceof Number) {
                return ((Number)timeObj).longValue();
            }
            LOGGER.warn("Time value '" + timeObj + "' of type '" + timeObj.getClass() + "' is not of expected temporal type");
        }
        return RESERVED_MILLIS_FOR_NULL;
    }

    public static boolean isTemporal(Class<?> bindingClass) {
        return Calendar.class.isAssignableFrom(bindingClass) || Date.class.isAssignableFrom(bindingClass);
    }

    public static Object getTimeValue(Class<?> bindingClass, long longVal) {
        if (longVal == RESERVED_MILLIS_FOR_NULL) {
            return null;
        }
        if (Calendar.class.isAssignableFrom(bindingClass)) {
            Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            cal.setTimeInMillis(longVal);
            return cal;
        }
        if (Date.class.isAssignableFrom(bindingClass)) {
            return new Date(longVal);
        }
        if (Long.class.isAssignableFrom(bindingClass)) {
            return longVal;
        }
        LOGGER.warn("Numeric value '" + longVal + "' of type '" + bindingClass + "' is not of expected temporal type");
        return null;
    }

    public static TemporalConstraints getTemporalConstraintsForDescriptors(TimeDescriptors timeDescriptors, TemporalConstraintsSet timeBoundsSet) {
        if (timeBoundsSet == null || timeBoundsSet.isEmpty()) {
            return new TemporalConstraints();
        }
        if (timeDescriptors.getStartRange() != null && timeDescriptors.getEndRange() != null) {
            return TimeUtils.composeRangeTemporalConstraints(timeDescriptors, timeBoundsSet);
        }
        if (timeDescriptors.getTime() != null && timeBoundsSet.hasConstraintsFor(timeDescriptors.getTime().getLocalName())) {
            return timeBoundsSet.getConstraintsFor(timeDescriptors.getTime().getLocalName());
        }
        return new TemporalConstraints();
    }

    public static TemporalConstraints composeRangeTemporalConstraints(TimeDescriptors timeDescriptors, TemporalConstraintsSet constraintsSet) {
        if (timeDescriptors.getEndRange() != null && timeDescriptors.getStartRange() != null) {
            String ename = timeDescriptors.getEndRange().getLocalName();
            String sname = timeDescriptors.getStartRange().getLocalName();
            if (constraintsSet.hasConstraintsForRange(sname, ename)) {
                return constraintsSet.getConstraintsForRange(sname, ename);
            }
        } else if (timeDescriptors.getTime() != null && constraintsSet.hasConstraintsFor(timeDescriptors.getTime().getLocalName())) {
            return constraintsSet.getConstraintsFor(timeDescriptors.getTime().getLocalName());
        }
        return new TemporalConstraints();
    }

    public static Interval getInterval(SimpleFeature entry, String fieldName) {
        return TimeUtils.getInterval(entry.getAttribute(fieldName));
    }

    public static Instant getInstant(Object timeObject) {
        if (timeObject == null) {
            return null;
        }
        if (timeObject instanceof Instant) {
            return (Instant)timeObject;
        }
        if (timeObject instanceof org.opengis.temporal.Instant) {
            return ((org.opengis.temporal.Instant)timeObject).getPosition().getDate().toInstant();
        }
        if (timeObject instanceof Date) {
            return Instant.ofEpochMilli(((Date)timeObject).getTime());
        }
        if (timeObject instanceof Calendar) {
            return Instant.ofEpochMilli(((Calendar)timeObject).getTimeInMillis());
        }
        if (timeObject instanceof Number) {
            return Instant.ofEpochMilli(((Number)timeObject).longValue());
        }
        return null;
    }

    public static Interval getInterval(Object timeObject) {
        if (timeObject instanceof Interval) {
            return (Interval)timeObject;
        }
        if (timeObject instanceof Period) {
            return Interval.of((Instant)((Period)timeObject).getBeginning().getPosition().getDate().toInstant(), (Instant)((Period)timeObject).getEnding().getPosition().getDate().toInstant());
        }
        Instant time = TimeUtils.getInstant(timeObject);
        if (time == null) {
            return null;
        }
        return Interval.of((Instant)time, (Instant)time);
    }

    public static Interval getInterval(Object startTimeObject, Object endTimeObject) {
        Instant startTime = TimeUtils.getInstant(startTimeObject);
        Instant endTime = TimeUtils.getInstant(endTimeObject);
        if (startTime == null) {
            if (endTime != null) {
                return Interval.of((Instant)endTime, (Instant)endTime);
            }
            return null;
        }
        if (endTime == null) {
            return Interval.of((Instant)startTime, (Instant)startTime);
        }
        return Interval.of((Instant)startTime, (Instant)endTime);
    }

    public static Instant getIntervalEnd(Interval interval) {
        if (interval.isEmpty()) {
            return Instant.ofEpochMilli(interval.getStart().toEpochMilli() + 1L);
        }
        return interval.getEnd();
    }

    public static final TimeDescriptors inferTimeAttributeDescriptor(SimpleFeatureType persistType) {
        TimeDescriptors.TimeDescriptorConfiguration config = new TimeDescriptors.TimeDescriptorConfiguration(persistType);
        TimeDescriptors timeDescriptors = new TimeDescriptors(persistType, config);
        config.updateType(persistType);
        return timeDescriptors;
    }
}

