/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.util;

import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.Locale;
import org.locationtech.geowave.core.geotime.util.SimpleFeatureUserDataConfiguration;
import org.locationtech.geowave.core.geotime.util.TimeUtils;
import org.locationtech.geowave.core.index.ByteArrayUtils;
import org.locationtech.geowave.core.index.StringUtils;
import org.locationtech.geowave.core.index.VarintUtils;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;

public class TimeDescriptors {
    private AttributeDescriptor startRange;
    private AttributeDescriptor endRange;
    private AttributeDescriptor time;

    public TimeDescriptors() {
        this.time = null;
        this.startRange = null;
        this.endRange = null;
    }

    public TimeDescriptors(AttributeDescriptor time) {
        this.time = time;
        this.startRange = null;
        this.endRange = null;
    }

    public TimeDescriptors(SimpleFeatureType type, TimeDescriptorConfiguration configuration) {
        this.update(type, configuration);
    }

    public TimeDescriptors(AttributeDescriptor startRange, AttributeDescriptor endRange) {
        this.time = null;
        this.startRange = startRange;
        this.endRange = endRange;
    }

    public void update(SimpleFeatureType type, TimeDescriptorConfiguration configuration) {
        if (configuration.timeName != null) {
            this.time = type.getDescriptor(configuration.timeName);
        }
        if (configuration.startRangeName != null) {
            this.startRange = type.getDescriptor(configuration.startRangeName);
        }
        if (configuration.endRangeName != null) {
            this.endRange = type.getDescriptor(configuration.endRangeName);
        }
    }

    public void setStartRange(AttributeDescriptor startRange) {
        this.startRange = startRange;
    }

    public void setEndRange(AttributeDescriptor endRange) {
        this.endRange = endRange;
    }

    public void setTime(AttributeDescriptor time) {
        this.time = time;
    }

    public AttributeDescriptor getStartRange() {
        return this.startRange;
    }

    public AttributeDescriptor getEndRange() {
        return this.endRange;
    }

    public AttributeDescriptor getTime() {
        return this.time;
    }

    public boolean hasTime() {
        return this.time != null || this.startRange != null && this.endRange != null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.endRange == null ? 0 : this.endRange.hashCode());
        result = 31 * result + (this.startRange == null ? 0 : this.startRange.hashCode());
        result = 31 * result + (this.time == null ? 0 : this.time.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimeDescriptors other = (TimeDescriptors)obj;
        if (this.endRange == null ? other.endRange != null : !this.endRange.equals(other.endRange)) {
            return false;
        }
        if (this.startRange == null ? other.startRange != null : !this.startRange.equals(other.startRange)) {
            return false;
        }
        return !(this.time == null ? other.time != null : !this.time.equals(other.time));
    }

    public static class TimeDescriptorConfiguration
    implements SimpleFeatureUserDataConfiguration {
        private static final long serialVersionUID = 2870075684501325546L;
        private String startRangeName = null;
        private String endRangeName = null;
        private String timeName = null;

        public TimeDescriptorConfiguration() {
        }

        public TimeDescriptorConfiguration(SimpleFeatureType type) {
            this.configureFromType(type);
        }

        public String getStartRangeName() {
            return this.startRangeName;
        }

        public void setStartRangeName(String startRangeName) {
            this.startRangeName = startRangeName;
        }

        public String getEndRangeName() {
            return this.endRangeName;
        }

        public void setEndRangeName(String endRangeName) {
            this.endRangeName = endRangeName;
        }

        public String getTimeName() {
            return this.timeName;
        }

        public void setTimeName(String timeName) {
            this.timeName = timeName;
        }

        @Override
        public void updateType(SimpleFeatureType persistType) {
            for (AttributeDescriptor attrDesc : persistType.getAttributeDescriptors()) {
                Class bindingClass = attrDesc.getType().getBinding();
                if (!TimeUtils.isTemporal(bindingClass)) continue;
                attrDesc.getUserData().put("time", Boolean.FALSE);
            }
            if (this.startRangeName != null) {
                persistType.getDescriptor(this.startRangeName).getUserData().put("start", Boolean.TRUE);
            }
            if (this.endRangeName != null) {
                persistType.getDescriptor(this.endRangeName).getUserData().put("end", Boolean.TRUE);
            }
            if (this.timeName != null) {
                persistType.getDescriptor(this.timeName).getUserData().put("time", Boolean.TRUE);
            }
        }

        @Override
        public void configureFromType(SimpleFeatureType persistType) {
            for (AttributeDescriptor attrDesc : persistType.getAttributeDescriptors()) {
                Class bindingClass = attrDesc.getType().getBinding();
                if (!TimeUtils.isTemporal(bindingClass)) continue;
                Boolean isTime = (Boolean)attrDesc.getUserData().get("time");
                if (isTime != null && isTime.booleanValue()) {
                    this.setTimeName(attrDesc.getLocalName());
                    this.setStartRangeName(null);
                    this.setEndRangeName(null);
                    break;
                }
                Boolean isStart = (Boolean)attrDesc.getUserData().get("start");
                Boolean isEnd = (Boolean)attrDesc.getUserData().get("end");
                if (isStart != null && isStart.booleanValue()) {
                    this.setStartRangeName(attrDesc.getLocalName());
                    continue;
                }
                if (isStart == null && this.getStartRangeName() == null && attrDesc.getLocalName().toLowerCase(Locale.ENGLISH).startsWith("start")) {
                    this.setStartRangeName(attrDesc.getLocalName());
                    continue;
                }
                if (isEnd != null && isEnd.booleanValue()) {
                    this.setEndRangeName(attrDesc.getLocalName());
                    continue;
                }
                if (isEnd == null && this.getEndRangeName() == null && attrDesc.getLocalName().toLowerCase(Locale.ENGLISH).startsWith("end")) {
                    this.setEndRangeName(attrDesc.getLocalName());
                    continue;
                }
                if (isTime != null || this.getTimeName() != null) continue;
                this.setTimeName(attrDesc.getLocalName());
            }
            if (this.getStartRangeName() != null) {
                if (this.getEndRangeName() != null) {
                    this.setTimeName(null);
                } else {
                    if (this.getTimeName() == null) {
                        this.setTimeName(this.getStartRangeName());
                    }
                    this.setStartRangeName(null);
                }
            } else if (this.getEndRangeName() != null && this.getStartRangeName() == null) {
                if (this.getTimeName() == null) {
                    this.setTimeName(this.getEndRangeName());
                }
                this.setEndRangeName(null);
            }
        }

        public byte[] toBinary() {
            byte[] endRangeBytes;
            byte[] startRangeBytes;
            byte[] timeBytes;
            BitSet bits = new BitSet(3);
            int length = 1;
            if (this.timeName != null) {
                bits.set(0);
                timeBytes = StringUtils.stringToBinary((String)this.timeName);
                length += VarintUtils.unsignedIntByteLength((int)timeBytes.length);
                length += timeBytes.length;
            } else {
                timeBytes = null;
            }
            if (this.startRangeName != null) {
                bits.set(1);
                startRangeBytes = StringUtils.stringToBinary((String)this.startRangeName);
                length += VarintUtils.unsignedIntByteLength((int)startRangeBytes.length);
                length += startRangeBytes.length;
            } else {
                startRangeBytes = null;
            }
            if (this.endRangeName != null) {
                bits.set(2);
                endRangeBytes = StringUtils.stringToBinary((String)this.endRangeName);
                length += VarintUtils.unsignedIntByteLength((int)endRangeBytes.length);
                length += endRangeBytes.length;
            } else {
                endRangeBytes = null;
            }
            ByteBuffer buf = ByteBuffer.allocate(length);
            byte[] bitMask = bits.toByteArray();
            buf.put(bitMask.length > 0 ? bitMask[0] : (byte)0);
            if (timeBytes != null) {
                VarintUtils.writeUnsignedInt((int)timeBytes.length, (ByteBuffer)buf);
                buf.put(timeBytes);
            }
            if (startRangeBytes != null) {
                VarintUtils.writeUnsignedInt((int)startRangeBytes.length, (ByteBuffer)buf);
                buf.put(startRangeBytes);
            }
            if (endRangeBytes != null) {
                VarintUtils.writeUnsignedInt((int)endRangeBytes.length, (ByteBuffer)buf);
                buf.put(endRangeBytes);
            }
            return buf.array();
        }

        public void fromBinary(byte[] bytes) {
            ByteBuffer buf = ByteBuffer.wrap(bytes);
            BitSet bitSet = BitSet.valueOf(new byte[]{buf.get()});
            if (bitSet.get(0)) {
                byte[] timeBytes = ByteArrayUtils.safeRead((ByteBuffer)buf, (int)VarintUtils.readUnsignedInt((ByteBuffer)buf));
                this.timeName = StringUtils.stringFromBinary((byte[])timeBytes);
            } else {
                this.timeName = null;
            }
            if (bitSet.get(1)) {
                byte[] startRangeBytes = ByteArrayUtils.safeRead((ByteBuffer)buf, (int)VarintUtils.readUnsignedInt((ByteBuffer)buf));
                this.startRangeName = StringUtils.stringFromBinary((byte[])startRangeBytes);
            } else {
                this.startRangeName = null;
            }
            if (bitSet.get(2)) {
                byte[] endRangeBytes = ByteArrayUtils.safeRead((ByteBuffer)buf, (int)VarintUtils.readUnsignedInt((ByteBuffer)buf));
                this.endRangeName = StringUtils.stringFromBinary((byte[])endRangeBytes);
            } else {
                this.endRangeName = null;
            }
        }
    }
}

