/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.util;

import com.clearspring.analytics.util.Varint;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import org.locationtech.geowave.core.geotime.util.TWKBUtils;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class TWKBWriter {
    private final int maxPrecision;

    public TWKBWriter() {
        this(7);
    }

    public TWKBWriter(int maxPrecision) {
        this.maxPrecision = Math.min(7, maxPrecision);
    }

    /*
     * Exception decompiling
     */
    public byte[] write(Geometry geom) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void write(Geometry geom, DataOutput output) throws IOException {
        PrecisionWriter precision;
        byte type = this.getType(geom);
        if (geom.isEmpty()) {
            output.writeByte(this.getTypeAndPrecisionByte(type, 0));
            output.writeByte(16);
            return;
        }
        int metadata = 0;
        Coordinate[] coordinates = geom.getCoordinates();
        if (Double.isNaN(coordinates[0].getZ()) || Double.isNaN(coordinates[0].getM())) {
            metadata = (byte)(metadata | 8);
            precision = new ExtendedPrecisionWriter().calculate(coordinates, this.maxPrecision);
        } else {
            precision = new PrecisionWriter().calculate(coordinates, this.maxPrecision);
        }
        output.writeByte(this.getTypeAndPrecisionByte(type, precision.precision));
        output.writeByte(metadata);
        precision.writeExtendedPrecision(output);
        switch (type) {
            case 1: {
                this.writePoint((Point)geom, precision, output);
                break;
            }
            case 2: {
                this.writeLineString((LineString)geom, precision, output);
                break;
            }
            case 3: {
                this.writePolygon((Polygon)geom, precision, output);
                break;
            }
            case 4: {
                this.writeMultiPoint((MultiPoint)geom, precision, output);
                break;
            }
            case 5: {
                this.writeMultiLineString((MultiLineString)geom, precision, output);
                break;
            }
            case 6: {
                this.writeMultiPolygon((MultiPolygon)geom, precision, output);
                break;
            }
            case 7: {
                this.writeGeometryCollection((GeometryCollection)geom, precision, output);
                break;
            }
        }
    }

    private void writePoint(Point point, PrecisionWriter precision, DataOutput output) throws IOException {
        precision.writePoint(point.getCoordinate(), output);
    }

    private void writeLineString(LineString line, PrecisionWriter precision, DataOutput output) throws IOException {
        precision.writePointArray(line.getCoordinates(), output);
    }

    private void writePolygon(Polygon polygon, PrecisionWriter precision, DataOutput output) throws IOException {
        Varint.writeUnsignedVarInt((int)(polygon.getNumInteriorRing() + 1), (DataOutput)output);
        precision.writePointArray(polygon.getExteriorRing().getCoordinates(), output);
        for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
            precision.writePointArray(polygon.getInteriorRingN(i).getCoordinates(), output);
        }
    }

    private void writeMultiPoint(MultiPoint multiPoint, PrecisionWriter precision, DataOutput output) throws IOException {
        precision.writePointArray(multiPoint.getCoordinates(), output);
    }

    private void writeMultiLineString(MultiLineString multiLine, PrecisionWriter precision, DataOutput output) throws IOException {
        Varint.writeUnsignedVarInt((int)multiLine.getNumGeometries(), (DataOutput)output);
        for (int i = 0; i < multiLine.getNumGeometries(); ++i) {
            precision.writePointArray(multiLine.getGeometryN(i).getCoordinates(), output);
        }
    }

    private void writeMultiPolygon(MultiPolygon multiPolygon, PrecisionWriter precision, DataOutput output) throws IOException {
        Varint.writeUnsignedVarInt((int)multiPolygon.getNumGeometries(), (DataOutput)output);
        for (int i = 0; i < multiPolygon.getNumGeometries(); ++i) {
            Polygon polygon = (Polygon)multiPolygon.getGeometryN(i);
            if (polygon.isEmpty()) {
                Varint.writeUnsignedVarInt((int)0, (DataOutput)output);
                continue;
            }
            Varint.writeUnsignedVarInt((int)(polygon.getNumInteriorRing() + 1), (DataOutput)output);
            precision.writePointArray(polygon.getExteriorRing().getCoordinates(), output);
            for (int j = 0; j < polygon.getNumInteriorRing(); ++j) {
                precision.writePointArray(polygon.getInteriorRingN(j).getCoordinates(), output);
            }
        }
    }

    private void writeGeometryCollection(GeometryCollection geoms, PrecisionWriter precision, DataOutput output) throws IOException {
        Varint.writeUnsignedVarInt((int)geoms.getNumGeometries(), (DataOutput)output);
        for (int i = 0; i < geoms.getNumGeometries(); ++i) {
            Geometry geom = geoms.getGeometryN(i);
            this.write(geom, output);
        }
    }

    private byte getTypeAndPrecisionByte(byte type, int precision) {
        byte typeAndPrecision = type;
        typeAndPrecision = (byte)(typeAndPrecision | TWKBUtils.zigZagEncode(precision) << 4);
        return typeAndPrecision;
    }

    private byte getType(Geometry geom) {
        if (geom instanceof Point) {
            return 1;
        }
        if (geom instanceof LineString) {
            return 2;
        }
        if (geom instanceof Polygon) {
            return 3;
        }
        if (geom instanceof MultiPoint) {
            return 4;
        }
        if (geom instanceof MultiLineString) {
            return 5;
        }
        if (geom instanceof MultiPolygon) {
            return 6;
        }
        return 7;
    }

    private static class ExtendedPrecisionWriter
    extends PrecisionWriter {
        private boolean hasZ = false;
        private int zPrecision = -4;
        private double zPrecisionMultiplier = 0.0;
        private boolean hasM = false;
        private int mPrecision = -4;
        private double mPrecisionMultiplier = 0.0;

        private ExtendedPrecisionWriter() {
        }

        @Override
        public PrecisionWriter calculate(Coordinate[] coordinates, int maxPrecision) {
            this.hasZ = !Double.isNaN(coordinates[0].getZ());
            this.hasM = !Double.isNaN(coordinates[0].getM());
            super.calculate(coordinates, maxPrecision);
            return this;
        }

        @Override
        protected void checkCoordinate(Coordinate c) {
            super.checkCoordinate(c);
            if (this.hasZ) {
                BigDecimal zCoord = new BigDecimal(Double.toString(c.getZ())).stripTrailingZeros();
                this.zPrecision = Math.max(zCoord.scale(), this.zPrecision);
            }
            if (this.hasM) {
                BigDecimal mCoord = new BigDecimal(Double.toString(c.getM())).stripTrailingZeros();
                this.mPrecision = Math.max(mCoord.scale(), this.mPrecision);
            }
        }

        @Override
        protected void finalize(int maxPrecision) {
            super.finalize(maxPrecision);
            if (this.hasZ) {
                this.zPrecision = Math.min(3, this.zPrecision);
                this.zPrecisionMultiplier = Math.pow(10.0, this.zPrecision);
            }
            if (this.hasM) {
                this.mPrecision = Math.min(3, this.mPrecision);
                this.mPrecisionMultiplier = Math.pow(10.0, this.mPrecision);
            }
        }

        @Override
        public void writeExtendedPrecision(DataOutput output) throws IOException {
            byte extendedDimensions = 0;
            if (this.hasZ) {
                extendedDimensions = (byte)(extendedDimensions | 1);
                extendedDimensions = (byte)(extendedDimensions | TWKBUtils.zigZagEncode(this.zPrecision) << 2);
            }
            if (this.hasM) {
                extendedDimensions = (byte)(extendedDimensions | 2);
                extendedDimensions = (byte)(extendedDimensions | TWKBUtils.zigZagEncode(this.mPrecision) << 5);
            }
            output.writeByte(extendedDimensions);
        }

        @Override
        public void writePoint(Coordinate coordinate, DataOutput output) throws IOException {
            super.writePoint(coordinate, output);
            if (this.hasZ) {
                Varint.writeSignedVarLong((long)Math.round(coordinate.getZ() * this.zPrecisionMultiplier), (DataOutput)output);
            }
            if (this.hasM) {
                Varint.writeSignedVarLong((long)Math.round(coordinate.getM() * this.mPrecisionMultiplier), (DataOutput)output);
            }
        }

        @Override
        public void writePointArray(Coordinate[] coordinates, DataOutput output) throws IOException {
            long lastX = 0L;
            long lastY = 0L;
            long lastZ = 0L;
            long lastM = 0L;
            Varint.writeUnsignedVarInt((int)coordinates.length, (DataOutput)output);
            for (Coordinate c : coordinates) {
                long x = Math.round(c.getX() * this.precisionMultiplier);
                long y = Math.round(c.getY() * this.precisionMultiplier);
                Varint.writeSignedVarLong((long)(x - lastX), (DataOutput)output);
                Varint.writeSignedVarLong((long)(y - lastY), (DataOutput)output);
                lastX = x;
                lastY = y;
                if (this.hasZ) {
                    long z = Math.round(c.getZ() * this.zPrecisionMultiplier);
                    Varint.writeSignedVarLong((long)(z - lastZ), (DataOutput)output);
                    lastZ = z;
                }
                if (!this.hasM) continue;
                long m = Math.round(c.getZ() * this.mPrecisionMultiplier);
                Varint.writeSignedVarLong((long)(m - lastM), (DataOutput)output);
                lastM = m;
            }
        }
    }

    private static class PrecisionWriter {
        private int precision = -8;
        protected double precisionMultiplier = 0.0;

        private PrecisionWriter() {
        }

        public PrecisionWriter calculate(Coordinate[] coordinates, int maxPrecision) {
            for (int i = 0; i < coordinates.length; ++i) {
                this.checkCoordinate(coordinates[i]);
            }
            this.finalize(maxPrecision);
            return this;
        }

        protected void checkCoordinate(Coordinate c) {
            BigDecimal xCoord = new BigDecimal(Double.toString(c.getX())).stripTrailingZeros();
            this.precision = Math.max(xCoord.scale(), this.precision);
            BigDecimal yCoord = new BigDecimal(Double.toString(c.getY())).stripTrailingZeros();
            this.precision = Math.max(yCoord.scale(), this.precision);
        }

        protected void finalize(int maxPrecision) {
            this.precision = Math.min(maxPrecision, this.precision);
            this.precisionMultiplier = Math.pow(10.0, this.precision);
        }

        public void writeExtendedPrecision(DataOutput output) throws IOException {
        }

        public void writePoint(Coordinate coordinate, DataOutput output) throws IOException {
            Varint.writeSignedVarLong((long)Math.round(coordinate.getX() * this.precisionMultiplier), (DataOutput)output);
            Varint.writeSignedVarLong((long)Math.round(coordinate.getY() * this.precisionMultiplier), (DataOutput)output);
        }

        public void writePointArray(Coordinate[] coordinates, DataOutput output) throws IOException {
            long lastX = 0L;
            long lastY = 0L;
            Varint.writeUnsignedVarInt((int)coordinates.length, (DataOutput)output);
            for (Coordinate c : coordinates) {
                long x = Math.round(c.getX() * this.precisionMultiplier);
                long y = Math.round(c.getY() * this.precisionMultiplier);
                Varint.writeSignedVarLong((long)(x - lastX), (DataOutput)output);
                Varint.writeSignedVarLong((long)(y - lastY), (DataOutput)output);
                lastX = x;
                lastY = y;
            }
        }
    }
}

