/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.util;

import org.locationtech.geowave.core.geotime.store.GeotoolsFeatureDataAdapter;
import org.locationtech.geowave.core.geotime.store.InternalGeotoolsFeatureDataAdapter;
import org.locationtech.geowave.core.geotime.store.dimension.CustomCRSSpatialDimension;
import org.locationtech.geowave.core.geotime.store.dimension.CustomCRSSpatialField;
import org.locationtech.geowave.core.geotime.store.dimension.LatitudeField;
import org.locationtech.geowave.core.geotime.store.dimension.LongitudeField;
import org.locationtech.geowave.core.geotime.store.dimension.TimeField;
import org.locationtech.geowave.core.store.api.DataTypeAdapter;
import org.locationtech.geowave.core.store.api.Index;
import org.locationtech.geowave.core.store.dimension.NumericDimensionField;

public class IndexOptimizationUtils {
    public static InternalGeotoolsFeatureDataAdapter unwrapGeotoolsFeatureDataAdapter(DataTypeAdapter<?> adapter) {
        if (adapter instanceof InternalGeotoolsFeatureDataAdapter) {
            return (InternalGeotoolsFeatureDataAdapter)adapter;
        }
        return null;
    }

    public static boolean hasAtLeastSpatial(Index index) {
        if (index == null || index.getIndexModel() == null || index.getIndexModel().getDimensions() == null) {
            return false;
        }
        boolean hasLatitude = false;
        boolean hasLongitude = false;
        for (NumericDimensionField dimension : index.getIndexModel().getDimensions()) {
            if (dimension instanceof LatitudeField) {
                hasLatitude = true;
            }
            if (dimension instanceof LongitudeField) {
                hasLongitude = true;
            }
            if (!(dimension instanceof CustomCRSSpatialField)) continue;
            if (((CustomCRSSpatialDimension)dimension.getBaseDefinition()).getAxis() == 0) {
                hasLongitude = true;
                continue;
            }
            hasLatitude = true;
        }
        return hasLatitude && hasLongitude;
    }

    public static boolean hasTime(Index index, GeotoolsFeatureDataAdapter adapter) {
        return IndexOptimizationUtils.hasTime(index) && adapter.hasTemporalConstraints();
    }

    public static boolean hasTime(Index index) {
        if (index == null || index.getIndexModel() == null || index.getIndexModel().getDimensions() == null) {
            return false;
        }
        for (NumericDimensionField dimension : index.getIndexModel().getDimensions()) {
            if (!(dimension instanceof TimeField)) continue;
            return true;
        }
        return false;
    }
}

