/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.util;

import com.google.uzaygezen.core.BitSetMath;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.geom.Point2D;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import javax.measure.Unit;
import javax.measure.quantity.Length;
import org.apache.commons.lang3.tuple.Pair;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.GeodeticCalculator;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.util.factory.GeoTools;
import org.locationtech.geowave.core.geotime.index.dimension.LatitudeDefinition;
import org.locationtech.geowave.core.geotime.index.dimension.LongitudeDefinition;
import org.locationtech.geowave.core.geotime.store.dimension.CustomCRSBoundedSpatialDimensionX;
import org.locationtech.geowave.core.geotime.store.dimension.CustomCRSBoundedSpatialDimensionY;
import org.locationtech.geowave.core.geotime.store.dimension.CustomCRSUnboundedSpatialDimensionX;
import org.locationtech.geowave.core.geotime.store.dimension.CustomCRSUnboundedSpatialDimensionY;
import org.locationtech.geowave.core.geotime.store.dimension.CustomCrsIndexModel;
import org.locationtech.geowave.core.geotime.util.TWKBReader;
import org.locationtech.geowave.core.geotime.util.TWKBWriter;
import org.locationtech.geowave.core.index.GeoWaveSerializationException;
import org.locationtech.geowave.core.index.numeric.BasicNumericDataset;
import org.locationtech.geowave.core.index.numeric.MultiDimensionalNumericData;
import org.locationtech.geowave.core.index.numeric.NumericData;
import org.locationtech.geowave.core.index.numeric.NumericRange;
import org.locationtech.geowave.core.index.numeric.NumericValue;
import org.locationtech.geowave.core.store.api.Index;
import org.locationtech.geowave.core.store.query.constraints.BasicQueryByClass;
import org.locationtech.geowave.core.store.query.constraints.Constraints;
import org.locationtech.geowave.core.store.util.ClasspathUtils;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.prep.PreparedGeometryFactory;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKBReader;
import org.locationtech.jts.io.WKBWriter;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.spatial.SpatialOperator;
import org.opengis.geometry.BoundingBox;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.uom.NonSI;
import si.uom.SI;
import systems.uom.common.USCustomary;
import tech.units.indriya.AbstractUnit;
import tech.units.indriya.function.Calculus;
import tech.units.indriya.function.DefaultNumberSystem;
import tech.units.indriya.spi.NumberSystem;
import tech.units.indriya.unit.AlternateUnit;
import tech.units.indriya.unit.BaseUnit;
import tech.units.indriya.unit.Units;

public class GeometryUtils {
    public static final GeometryFactory GEOMETRY_FACTORY = new GeometryFactory();
    public static final PreparedGeometryFactory PREPARED_GEOMETRY_FACTORY = new PreparedGeometryFactory();
    private static final Logger LOGGER = LoggerFactory.getLogger(GeometryUtils.class);
    private static final Object MUTEX = new Object();
    private static final Object MUTEX_DEFAULT_CRS = new Object();
    public static final String DEFAULT_CRS_STR = "EPSG:4326";
    private static CoordinateReferenceSystem defaultCrsSingleton;
    private static boolean classLoaderInitialized;
    public static final Integer MAX_GEOMETRY_PRECISION;

    public static SpatialOperator geometryToSpatialOperator(Geometry jtsGeom, String geometryAttributeName, CoordinateReferenceSystem crs) {
        FilterFactory2 factory = CommonFactoryFinder.getFilterFactory2();
        if (jtsGeom.equalsTopo(jtsGeom.getEnvelope())) {
            return factory.bbox((Expression)factory.property(geometryAttributeName), (BoundingBox)new ReferencedEnvelope(jtsGeom.getEnvelopeInternal(), crs));
        }
        return factory.intersects((Expression)factory.property(geometryAttributeName), (Expression)factory.literal((Object)jtsGeom));
    }

    public static void visitGeometry(Geometry geom, GeometryHandler geometryHandler) {
        if (geom == null) {
            return;
        }
        if (geom instanceof GeometryCollection) {
            int numGeom = ((GeometryCollection)geom).getNumGeometries();
            for (int i = 0; i < numGeom; ++i) {
                GeometryUtils.visitGeometry(((GeometryCollection)geom).getGeometryN(i), geometryHandler);
            }
        } else if (geom instanceof LineString) {
            geometryHandler.handleLineString((LineString)geom);
        } else if (geom instanceof Polygon) {
            geometryHandler.handlePolygon((Polygon)geom);
        } else {
            Point centroid = geom.getCentroid();
            geometryHandler.handlePoint(centroid);
        }
    }

    public static CoordinateReferenceSystem decodeCRS(String crsCode) {
        if (crsCode == null) {
            return GeometryUtils.getDefaultCRS();
        }
        try {
            return CRS.decode((String)crsCode, (boolean)true);
        }
        catch (FactoryException e) {
            LOGGER.error("Unable to decode '" + crsCode + "' CRS", (Throwable)e);
            throw new RuntimeException("Unable to decode CRS: '" + crsCode + "'", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings
    public static CoordinateReferenceSystem getDefaultCRS() {
        if (defaultCrsSingleton == null) {
            Object object = MUTEX_DEFAULT_CRS;
            synchronized (object) {
                if (defaultCrsSingleton == null) {
                    try {
                        defaultCrsSingleton = CRS.decode((String)DEFAULT_CRS_STR, (boolean)true);
                    }
                    catch (Exception e) {
                        LOGGER.error("Unable to decode EPSG:4326 CRS", (Throwable)e);
                        defaultCrsSingleton = DefaultGeographicCRS.WGS84;
                    }
                }
            }
        }
        return defaultCrsSingleton;
    }

    public static boolean crsMatches(String crsCode1, String crsCode2) {
        if (GeometryUtils.isDefaultCrs(crsCode1)) {
            return GeometryUtils.isDefaultCrs(crsCode2);
        }
        if (GeometryUtils.isDefaultCrs(crsCode2)) {
            return GeometryUtils.isDefaultCrs(crsCode1);
        }
        return crsCode1.equalsIgnoreCase(crsCode2);
    }

    public static boolean isDefaultCrs(String crsCode) {
        return crsCode == null || crsCode.isEmpty() || crsCode.equalsIgnoreCase(DEFAULT_CRS_STR);
    }

    public static boolean isDefaultCrs(CoordinateReferenceSystem crs) {
        return crs == null || crs.equals(GeometryUtils.getDefaultCRS());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings
    public static void initClassLoader() {
        if (!classLoaderInitialized) {
            Object object = MUTEX;
            synchronized (object) {
                if (!classLoaderInitialized) {
                    Calculus.setCurrentNumberSystem((NumberSystem)new DefaultNumberSystem());
                    ClassLoader myCl = GeometryUtils.class.getClassLoader();
                    ClassLoader classLoader = ClasspathUtils.transformClassLoader((ClassLoader)myCl);
                    if (classLoader != null) {
                        GeoTools.addClassLoader((ClassLoader)classLoader);
                    }
                    classLoaderInitialized = true;
                }
            }
        }
    }

    public static BasicQueryByClass.ConstraintsByClass basicConstraintsFromGeometry(Geometry geometry) {
        LinkedList<BasicQueryByClass.ConstraintSet> set = new LinkedList<BasicQueryByClass.ConstraintSet>();
        GeometryUtils.constructListOfConstraintSetsFromGeometry(geometry, set, false);
        return new BasicQueryByClass.ConstraintsByClass(set);
    }

    public static GeoConstraintsWrapper basicGeoConstraintsWrapperFromGeometry(Geometry geometry) {
        LinkedList<BasicQueryByClass.ConstraintSet> set = new LinkedList<BasicQueryByClass.ConstraintSet>();
        boolean geometryConstraintsExactMatch = GeometryUtils.constructListOfConstraintSetsFromGeometry(geometry, set, true);
        return new GeoConstraintsWrapper(new BasicQueryByClass.ConstraintsByClass(set), geometryConstraintsExactMatch, geometry);
    }

    private static boolean constructListOfConstraintSetsFromGeometry(Geometry geometry, List<BasicQueryByClass.ConstraintSet> destinationListOfSets, boolean checkTopoEquality) {
        int n = geometry.getNumGeometries();
        boolean retVal = true;
        if (n > 1) {
            retVal = false;
            for (int gi = 0; gi < n; ++gi) {
                GeometryUtils.constructListOfConstraintSetsFromGeometry(geometry.getGeometryN(gi), destinationListOfSets, checkTopoEquality);
            }
        } else {
            Envelope env = geometry.getEnvelopeInternal();
            destinationListOfSets.add(GeometryUtils.basicConstraintSetFromEnvelope(env));
            if (checkTopoEquality) {
                retVal = new GeometryFactory().toGeometry(env).equalsTopo(geometry);
            }
        }
        return retVal;
    }

    public static BasicQueryByClass.ConstraintSet basicConstraintSetFromEnvelope(Envelope env) {
        NumericRange rangeLongitude = new NumericRange(env.getMinX(), env.getMaxX());
        NumericRange rangeLatitude = new NumericRange(env.getMinY(), env.getMaxY());
        HashMap<Class, BasicQueryByClass.ConstraintData> constraintsPerDimension = new HashMap<Class, BasicQueryByClass.ConstraintData>();
        BasicQueryByClass.ConstraintData xRange = new BasicQueryByClass.ConstraintData((NumericData)rangeLongitude, false);
        BasicQueryByClass.ConstraintData yRange = new BasicQueryByClass.ConstraintData((NumericData)rangeLatitude, false);
        constraintsPerDimension.put(CustomCRSUnboundedSpatialDimensionX.class, xRange);
        constraintsPerDimension.put(CustomCRSUnboundedSpatialDimensionY.class, yRange);
        constraintsPerDimension.put(CustomCRSBoundedSpatialDimensionX.class, xRange);
        constraintsPerDimension.put(CustomCRSBoundedSpatialDimensionY.class, yRange);
        constraintsPerDimension.put(LongitudeDefinition.class, xRange);
        constraintsPerDimension.put(LatitudeDefinition.class, yRange);
        return new BasicQueryByClass.ConstraintSet(constraintsPerDimension);
    }

    public static Constraints basicConstraintsFromEnvelope(Envelope env) {
        return new BasicQueryByClass.ConstraintsByClass(GeometryUtils.basicConstraintSetFromEnvelope(env));
    }

    public static BasicQueryByClass.ConstraintSet basicConstraintsFromPoint(double latitudeDegrees, double longitudeDegrees) {
        NumericValue latitude = new NumericValue(latitudeDegrees);
        NumericValue longitude = new NumericValue(longitudeDegrees);
        HashMap<Class, BasicQueryByClass.ConstraintData> constraintsPerDimension = new HashMap<Class, BasicQueryByClass.ConstraintData>();
        constraintsPerDimension.put(LongitudeDefinition.class, new BasicQueryByClass.ConstraintData((NumericData)longitude, false));
        constraintsPerDimension.put(LatitudeDefinition.class, new BasicQueryByClass.ConstraintData((NumericData)latitude, false));
        return new BasicQueryByClass.ConstraintSet(constraintsPerDimension);
    }

    public static MultiDimensionalNumericData getBoundsFromEnvelope(Envelope envelope) {
        NumericRange[] boundsPerDimension = new NumericRange[]{new NumericRange(envelope.getMinX(), envelope.getMaxX()), new NumericRange(envelope.getMinY(), envelope.getMaxY())};
        return new BasicNumericDataset((NumericData[])boundsPerDimension);
    }

    public static NumericData xRangeFromGeometry(Geometry geometry) {
        if (geometry == null || geometry.isEmpty()) {
            return new NumericValue(0.0);
        }
        Envelope env = geometry.getEnvelopeInternal();
        if (env.getWidth() <= 0.0) {
            return new NumericValue(env.getMinX());
        }
        return new NumericRange(env.getMinX(), env.getMaxX());
    }

    public static NumericData yRangeFromGeometry(Geometry geometry) {
        if (geometry == null || geometry.isEmpty()) {
            return new NumericValue(0.0);
        }
        Envelope env = geometry.getEnvelopeInternal();
        if (env.getHeight() <= 0.0) {
            return new NumericValue(env.getMinY());
        }
        return new NumericRange(env.getMinY(), env.getMaxY());
    }

    public static byte[] geometryToBinary(Geometry geometry, @Nullable Integer precision) {
        if (precision == null) {
            return new WKBWriter().write(geometry);
        }
        return new TWKBWriter(precision).write(geometry);
    }

    public static Geometry geometryFromBinary(byte[] binary, @Nullable Integer precision) {
        try {
            if (precision == null) {
                return new WKBReader().read(binary);
            }
            return new TWKBReader().read(binary);
        }
        catch (ParseException e) {
            throw new GeoWaveSerializationException("Unable to deserialize geometry data", (Throwable)e);
        }
    }

    public static Geometry geometryFromBinary(byte[] binary, @Nullable Integer precision, byte serializationVersion) {
        if (serializationVersion < 1) {
            try {
                return new WKBReader().read(binary);
            }
            catch (ParseException e) {
                LOGGER.warn("Unable to deserialize geometry data", (Throwable)e);
                throw new GeoWaveSerializationException((Throwable)e);
            }
        }
        return GeometryUtils.geometryFromBinary(binary, precision);
    }

    public static Geometry infinity() {
        return new GeometryFactory().toGeometry(new Envelope(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY));
    }

    public static CoordinateReferenceSystem getIndexCrs(Index[] indices) {
        CoordinateReferenceSystem indexCrs = null;
        for (Index primaryindx : indices) {
            if (indexCrs == null) {
                indexCrs = GeometryUtils.getIndexCrs(primaryindx);
                continue;
            }
            if (!(primaryindx.getIndexModel() instanceof CustomCrsIndexModel)) continue;
            if (!indexCrs.equals(((CustomCrsIndexModel)primaryindx.getIndexModel()).getCrs())) {
                LOGGER.error("Multiple indices with different CRS is not supported");
                throw new RuntimeException("Multiple indices with different CRS is not supported");
            }
            if (indexCrs.equals(GeometryUtils.getDefaultCRS())) continue;
            LOGGER.error("Multiple indices with different CRS is not supported");
            throw new RuntimeException("Multiple indices with different CRS is not supported");
        }
        return indexCrs;
    }

    public static CoordinateReferenceSystem getIndexCrs(Index index) {
        CoordinateReferenceSystem indexCrs = null;
        indexCrs = index != null && index.getIndexModel() instanceof CustomCrsIndexModel ? ((CustomCrsIndexModel)index.getIndexModel()).getCrs() : GeometryUtils.getDefaultCRS();
        return indexCrs;
    }

    public static String getCrsCode(CoordinateReferenceSystem crs) {
        return CRS.toSRS((CoordinateReferenceSystem)crs);
    }

    public static final Pair<Geometry, Double> buffer(CoordinateReferenceSystem crs, Geometry geometry, String distanceUnits, double distance) throws TransformException {
        Unit unit;
        try {
            unit = GeometryUtils.lookup(distanceUnits);
        }
        catch (Exception e) {
            unit = Units.METRE;
            LOGGER.warn("Cannot lookup unit of measure " + distanceUnits, (Throwable)e);
        }
        double meterDistance = unit.getConverterTo(Units.METRE).convert(distance);
        double degrees = GeometryUtils.distanceToDegrees(crs, geometry, meterDistance);
        return Pair.of((Object)GeometryUtils.adjustGeo(crs, geometry.buffer(degrees)), (Object)degrees);
    }

    public static Unit<Length> lookup(String name) {
        Unit<Length> u;
        String lowerCaseName = name.toLowerCase();
        Unit<Length> unit = GeometryUtils.lookup(SI.class, lowerCaseName);
        if (unit != null) {
            return unit;
        }
        unit = GeometryUtils.lookup(NonSI.class, lowerCaseName);
        if (unit != null) {
            return unit;
        }
        if (lowerCaseName.endsWith("s")) {
            return GeometryUtils.lookup(lowerCaseName.substring(0, lowerCaseName.length() - 1));
        }
        if (lowerCaseName.startsWith("kilo") && lowerCaseName.length() > 4 && (u = GeometryUtils.lookup(lowerCaseName.substring(4))) != null) {
            return u.multiply(1000.0);
        }
        if (lowerCaseName.equals("feet")) {
            return USCustomary.FOOT;
        }
        if (lowerCaseName.equals("meter")) {
            return Units.METRE;
        }
        if (lowerCaseName.equals("unity")) {
            return AbstractUnit.ONE;
        }
        return null;
    }

    private static Unit<Length> lookup(Class class1, String name) {
        Unit unit = null;
        Field[] fields = class1.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            String name2 = field.getName();
            if (!field.getType().isAssignableFrom(BaseUnit.class) && !field.getType().isAssignableFrom(AlternateUnit.class) || !name2.equalsIgnoreCase(name)) continue;
            try {
                unit = (Unit)field.get(unit);
                return unit;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return unit;
    }

    public static Geometry adjustGeo(CoordinateReferenceSystem crs, Geometry geometry) {
        List<Polygon> polygons = GeometryUtils.fixRangeOfCoordinates(crs, geometry);
        if (polygons.size() == 1) {
            return (Geometry)polygons.get(0);
        }
        return geometry.getFactory().createMultiPolygon(polygons.toArray(new Polygon[polygons.size()]));
    }

    public static List<Polygon> fixRangeOfCoordinates(CoordinateReferenceSystem crs, Geometry geometry) {
        ArrayList<Polygon> replacements = new ArrayList<Polygon>();
        if (geometry instanceof MultiPolygon) {
            MultiPolygon multi = (MultiPolygon)geometry;
            for (int i = 0; i < multi.getNumGeometries(); ++i) {
                Geometry geo = multi.getGeometryN(i);
                replacements.addAll(GeometryUtils.fixRangeOfCoordinates(crs, geo));
            }
            return replacements;
        }
        if (geometry instanceof GeometryCollection) {
            GeometryCollection multi = (GeometryCollection)geometry;
            for (int i = 0; i < multi.getNumGeometries(); ++i) {
                Geometry geo = multi.getGeometryN(i);
                replacements.addAll(GeometryUtils.fixRangeOfCoordinates(crs, geo));
            }
            return replacements;
        }
        Coordinate[] geoCoords = geometry.getCoordinates();
        Coordinate modifier = GeometryUtils.findModifier(crs, geoCoords);
        replacements.addAll(GeometryUtils.constructGeometriesOverMapRegions(modifier, geometry));
        return replacements;
    }

    private static void updateModifier(Coordinate coord, Coordinate modifier) {
        for (int i = 0; i < 3; ++i) {
            double modifierOrdinateValue;
            double coordOrdinateValue;
            switch (i) {
                case 1: {
                    coordOrdinateValue = coord.getY();
                    modifierOrdinateValue = modifier.getY();
                    break;
                }
                case 2: {
                    coordOrdinateValue = coord.getZ();
                    modifierOrdinateValue = modifier.getZ();
                    break;
                }
                default: {
                    coordOrdinateValue = coord.getX();
                    modifierOrdinateValue = modifier.getX();
                }
            }
            if (Double.isNaN(coordOrdinateValue) || Double.isNaN(modifierOrdinateValue) || !(Math.abs(modifierOrdinateValue) < Math.abs(coordOrdinateValue))) continue;
            modifier.setOrdinate(i, coord.getOrdinate(i));
        }
    }

    private static Coordinate findModifier(CoordinateReferenceSystem crs, Coordinate[] coords) {
        Coordinate maxModifier = new Coordinate(0.0, 0.0, 0.0);
        for (Coordinate coord : coords) {
            Coordinate modifier = GeometryUtils.diff(GeometryUtils.adjustCoordinateToFitInRange(crs, coord), coord);
            GeometryUtils.updateModifier(modifier, maxModifier);
        }
        return maxModifier;
    }

    public static List<Polygon> constructGeometriesOverMapRegions(Coordinate modifier, Geometry geometry) {
        Coordinate[] geoCoords = geometry.getCoordinates();
        LinkedList<Polygon> polygons = new LinkedList<Polygon>();
        Geometry world = GeometryUtils.world(geometry.getFactory(), GeometryUtils.getDefaultCRS());
        Geometry worldIntersections = world.intersection(geometry);
        for (int i = 0; i < worldIntersections.getNumGeometries(); ++i) {
            Polygon polyToAdd = (Polygon)worldIntersections.getGeometryN(i);
            if (polygons.contains(polyToAdd)) continue;
            polygons.add(polyToAdd);
        }
        if (Math.abs(modifier.x) > 1.0E-10) {
            Coordinate[] newCoords = new Coordinate[geoCoords.length];
            int c = 0;
            for (Coordinate geoCoord : geoCoords) {
                newCoords[c++] = new Coordinate(geoCoord.x + modifier.x, geoCoord.y, geoCoord.z);
            }
            Polygon transposedPoly = geometry.getFactory().createPolygon(newCoords);
            Geometry adjustedPolyWorldIntersections = world.intersection((Geometry)transposedPoly);
            for (int i = 0; i < adjustedPolyWorldIntersections.getNumGeometries(); ++i) {
                Polygon polyToAdd = (Polygon)adjustedPolyWorldIntersections.getGeometryN(i);
                if (polygons.contains(polyToAdd)) continue;
                polygons.add(polyToAdd);
            }
        }
        return polygons;
    }

    public static Coordinate adjustCoordinateToFitInRange(CoordinateReferenceSystem crs, Coordinate coord) {
        return new Coordinate(GeometryUtils.adjustCoordinateDimensionToRange(coord.getX(), crs, 0), GeometryUtils.clipRange(coord.getY(), crs, 1), GeometryUtils.clipRange(coord.getZ(), crs, 2));
    }

    private static Coordinate diff(Coordinate coord1, Coordinate coord2) {
        return new Coordinate(coord1.getX() - coord2.getX(), coord1.getY() - coord2.getY(), coord1.getZ() - coord2.getZ());
    }

    private static double clipRange(double val, CoordinateReferenceSystem crs, int axis) {
        CoordinateSystem coordinateSystem = crs.getCoordinateSystem();
        if (coordinateSystem.getDimension() > axis) {
            CoordinateSystemAxis coordinateAxis = coordinateSystem.getAxis(axis);
            if (val < coordinateAxis.getMinimumValue()) {
                return coordinateAxis.getMinimumValue();
            }
            if (val > coordinateAxis.getMaximumValue()) {
                return coordinateAxis.getMaximumValue();
            }
        }
        return val;
    }

    public static double adjustCoordinateDimensionToRange(double val, CoordinateReferenceSystem crs, int axis) {
        CoordinateSystem coordinateSystem = crs.getCoordinateSystem();
        if (coordinateSystem.getDimension() > axis) {
            double lowerBound = coordinateSystem.getAxis(axis).getMinimumValue();
            double bound = coordinateSystem.getAxis(axis).getMaximumValue() - lowerBound;
            double sign = GeometryUtils.sign(val);
            double mult = Math.floor(Math.abs((val + sign * (-1.0 * lowerBound)) / bound));
            return val + mult * bound * sign * -1.0;
        }
        return val;
    }

    private static double sign(double val) {
        return val < 0.0 ? -1.0 : 1.0;
    }

    public static Geometry world(GeometryFactory factory, CoordinateReferenceSystem crs) {
        return factory.createPolygon(GeometryUtils.toPolygonCoordinates(crs.getCoordinateSystem()));
    }

    private static Coordinate[] toPolygonCoordinates(CoordinateSystem coordinateSystem) {
        Coordinate[] coordinates = new Coordinate[(int)Math.pow(2.0, coordinateSystem.getDimension()) + 1];
        BitSet greyCode = new BitSet(coordinateSystem.getDimension());
        BitSet mask = GeometryUtils.getGreyCodeMask(coordinateSystem.getDimension());
        for (int i = 0; i < coordinates.length; ++i) {
            coordinates[i] = new Coordinate(GeometryUtils.getValue(greyCode, coordinateSystem.getAxis(0), 0), GeometryUtils.getValue(greyCode, coordinateSystem.getAxis(1), 1), coordinateSystem.getDimension() > 2 ? GeometryUtils.getValue(greyCode, coordinateSystem.getAxis(2), 2) : Double.NaN);
            GeometryUtils.grayCode(greyCode, mask);
        }
        return coordinates;
    }

    private static BitSet getGreyCodeMask(int dims) {
        BitSet mask = new BitSet(dims);
        for (int i = 0; i < dims; ++i) {
            mask.set(i);
        }
        return mask;
    }

    private static void grayCode(BitSet code, BitSet mask) {
        BitSetMath.grayCodeInverse((BitSet)code);
        BitSetMath.increment((BitSet)code);
        code.and(mask);
        BitSetMath.grayCode((BitSet)code);
    }

    private static double getValue(BitSet set, CoordinateSystemAxis axis, int dimension) {
        return set.get(dimension) ? axis.getMaximumValue() : axis.getMinimumValue();
    }

    private static double distanceToDegrees(CoordinateReferenceSystem crs, Geometry geometry, double meters) throws TransformException {
        GeometryFactory factory = geometry.getFactory();
        return geometry instanceof Point ? geometry.distance((Geometry)GeometryUtils.farthestPoint(crs, (Point)geometry, meters)) : GeometryUtils.distanceToDegrees(crs, geometry.getEnvelopeInternal(), factory == null ? new GeometryFactory() : factory, meters);
    }

    private static double distanceToDegrees(CoordinateReferenceSystem crs, Envelope env, GeometryFactory factory, double meters) throws TransformException {
        return Collections.max(Arrays.asList(GeometryUtils.distanceToDegrees(crs, (Geometry)factory.createPoint(new Coordinate(env.getMaxX(), env.getMaxY())), meters), GeometryUtils.distanceToDegrees(crs, (Geometry)factory.createPoint(new Coordinate(env.getMaxX(), env.getMinY())), meters), GeometryUtils.distanceToDegrees(crs, (Geometry)factory.createPoint(new Coordinate(env.getMinX(), env.getMinY())), meters), GeometryUtils.distanceToDegrees(crs, (Geometry)factory.createPoint(new Coordinate(env.getMinX(), env.getMaxY())), meters)));
    }

    private static Point farthestPoint(CoordinateReferenceSystem crs, Point point, double meters) {
        GeodeticCalculator calc = new GeodeticCalculator(crs);
        calc.setStartingGeographicPoint(point.getX(), point.getY());
        calc.setDirection(90.0, meters);
        Point2D dest2D = calc.getDestinationGeographicPoint();
        if (dest2D.getX() < point.getX()) {
            calc.setDirection(-90.0, meters);
            dest2D = calc.getDestinationGeographicPoint();
        }
        return point.getFactory().createPoint(new Coordinate(dest2D.getX(), dest2D.getY()));
    }

    public static SimpleFeature crsTransform(SimpleFeature entry, SimpleFeatureType reprojectedType, MathTransform transform) {
        SimpleFeature crsEntry = entry;
        if (transform != null) {
            try {
                crsEntry = SimpleFeatureBuilder.retype((SimpleFeature)entry, (SimpleFeatureType)reprojectedType);
                crsEntry.setDefaultGeometry((Object)JTS.transform((Geometry)((Geometry)entry.getDefaultGeometry()), (MathTransform)transform));
            }
            catch (MismatchedDimensionException | TransformException e) {
                LOGGER.warn("Unable to perform transform to specified CRS of the index, the feature geometry will remain in its original CRS", e);
            }
        }
        return crsEntry;
    }

    public static Geometry crsTransform(Geometry geometry, MathTransform transform) {
        if (transform != null) {
            try {
                return JTS.transform((Geometry)geometry, (MathTransform)transform);
            }
            catch (MismatchedDimensionException | TransformException e) {
                LOGGER.warn("Unable to perform transform to specified CRS of the index, the feature geometry will remain in its original CRS", e);
            }
        }
        return null;
    }

    static {
        classLoaderInitialized = false;
        GeometryUtils.initClassLoader();
        MAX_GEOMETRY_PRECISION = 7;
    }

    public static class GeoConstraintsWrapper {
        private final BasicQueryByClass.ConstraintsByClass constraints;
        private final boolean constraintsMatchGeometry;
        private final Geometry jtsBounds;

        public GeoConstraintsWrapper(BasicQueryByClass.ConstraintsByClass constraints, boolean constraintsMatchGeometry, Geometry jtsBounds) {
            this.constraints = constraints;
            this.constraintsMatchGeometry = constraintsMatchGeometry;
            this.jtsBounds = jtsBounds;
        }

        public BasicQueryByClass.ConstraintsByClass getConstraints() {
            return this.constraints;
        }

        public boolean isConstraintsMatchGeometry() {
            return this.constraintsMatchGeometry;
        }

        public Geometry getGeometry() {
            return this.jtsBounds;
        }
    }

    public static interface GeometryHandler {
        public void handlePoint(Point var1);

        public void handleLineString(LineString var1);

        public void handlePolygon(Polygon var1);
    }
}

