/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.util;

import org.geotools.filter.FilterFactoryImpl;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.LiteralExpressionImpl;
import org.geotools.filter.spatial.DWithinImpl;
import org.geotools.filter.spatial.IntersectsImpl;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.ecql.ECQL;
import org.locationtech.geowave.core.geotime.util.DWithinFilterVisitor;
import org.locationtech.geowave.core.geotime.util.GeometryUtils;
import org.locationtech.geowave.core.geotime.util.HasDWithinFilterVisitor;
import org.locationtech.jts.geom.Geometry;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.MultiValuedFilter;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.DWithin;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterToCQLTool {
    private static Logger LOGGER = LoggerFactory.getLogger(FilterToCQLTool.class);

    public static Filter fixDWithin(Filter filter) {
        HasDWithinFilterVisitor dwithinCheck = new HasDWithinFilterVisitor();
        filter.accept((FilterVisitor)dwithinCheck, null);
        if (dwithinCheck.hasDWithin()) {
            try {
                Filter retVal = (Filter)filter.accept((FilterVisitor)new DWithinFilterVisitor(), null);
                return FilterToCQLTool.toFilter(ECQL.toCQL((Filter)retVal));
            }
            catch (CQLException e) {
                LOGGER.trace("Filter is not a CQL Expression", (Throwable)e);
            }
        }
        return filter;
    }

    public static Filter toFilter(String expression) throws CQLException {
        return ECQL.toFilter((String)expression, (FilterFactory)new FilterFactoryImpl(){

            public DWithin dwithin(Expression geometry1, Expression geometry2, double distance, String units, MultiValuedFilter.MatchAction matchAction) {
                try {
                    return matchAction == null ? new FixedDWithinImpl(geometry1, geometry2, units, distance) : new FixedDWithinImpl(geometry1, geometry2, units, distance, matchAction);
                }
                catch (IllegalFilterException | TransformException e) {
                    LOGGER.warn("Cannot convert DWithin Expression to work with WSG84", e);
                    DWithinImpl impl = matchAction == null ? new DWithinImpl(geometry1, geometry2) : new DWithinImpl(geometry1, geometry2, matchAction);
                    impl.setDistance(distance);
                    impl.setUnits(units);
                    return impl;
                }
            }

            public DWithin dwithin(Expression geometry1, Expression geometry2, double distance, String units) {
                return this.dwithin(geometry1, geometry2, distance, units, null);
            }
        });
    }

    public static final class FixedDWithinImpl
    extends IntersectsImpl
    implements DWithin {
        private final double distance;
        private final String units;

        public FixedDWithinImpl(Expression e1, Expression e2, String units, double distance) throws IllegalFilterException, TransformException {
            super((Expression)new LiteralExpressionImpl(GeometryUtils.buffer(FixedDWithinImpl.getCRS(e1, e2), e1 instanceof PropertyName ? (Geometry)e2.evaluate(null, Geometry.class) : (Geometry)e1.evaluate(null, Geometry.class), units, distance).getLeft()), e1 instanceof PropertyName ? e1 : e2);
            this.units = units;
            this.distance = distance;
        }

        private static CoordinateReferenceSystem getCRS(Expression e1, Expression e2) {
            return GeometryUtils.getDefaultCRS();
        }

        public FixedDWithinImpl(Expression e1, Expression e2, String units, double distance, MultiValuedFilter.MatchAction matchAction) throws IllegalFilterException, TransformException {
            super((Expression)new LiteralExpressionImpl(GeometryUtils.buffer(FixedDWithinImpl.getCRS(e1, e2), (Geometry)e1.evaluate(null, Geometry.class), units, distance).getLeft()), e2, matchAction);
            this.units = units;
            this.distance = distance;
        }

        public double getDistance() {
            return this.distance;
        }

        public String getDistanceUnits() {
            return this.units;
        }
    }
}

