/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.util;

import org.apache.commons.lang3.tuple.Pair;
import org.geotools.filter.visitor.NullFilterVisitor;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.locationtech.geowave.core.geotime.store.query.filter.SpatialQueryFilter;
import org.locationtech.geowave.core.geotime.util.ExtractGeometryFilterVisitorResult;
import org.locationtech.geowave.core.geotime.util.GeometryUtils;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.opengis.filter.And;
import org.opengis.filter.ExcludeFilter;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.Id;
import org.opengis.filter.IncludeFilter;
import org.opengis.filter.Not;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsGreaterThanOrEqualTo;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.PropertyIsNotEqualTo;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.expression.Add;
import org.opengis.filter.expression.Divide;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.Multiply;
import org.opengis.filter.expression.NilExpression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.expression.Subtract;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;
import org.opengis.geometry.BoundingBox;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtractGeometryFilterVisitor
extends NullFilterVisitor {
    private static Logger LOGGER = LoggerFactory.getLogger(ExtractGeometryFilterVisitor.class);
    private final CoordinateReferenceSystem crs;
    private final String attributeOfInterest;

    public ExtractGeometryFilterVisitor(CoordinateReferenceSystem crs, String attributeOfInterest) {
        this.crs = crs;
        this.attributeOfInterest = attributeOfInterest;
    }

    public static ExtractGeometryFilterVisitorResult getConstraints(Filter filter, CoordinateReferenceSystem crs, String attributeOfInterest) {
        ExtractGeometryFilterVisitorResult geoAndCompareOpData = (ExtractGeometryFilterVisitorResult)filter.accept((FilterVisitor)new ExtractGeometryFilterVisitor(crs, attributeOfInterest), null);
        if (geoAndCompareOpData == null) {
            return null;
        }
        Geometry geo = geoAndCompareOpData.getGeometry();
        if (geo == null || geo.isEmpty()) {
            return null;
        }
        double area = geo.getArea();
        if (Double.isInfinite(area) || Double.isNaN(area)) {
            return null;
        }
        return geoAndCompareOpData;
    }

    private Geometry bbox(Object data) {
        try {
            if (data == null) {
                return null;
            }
            if (data instanceof Geometry) {
                return (Geometry)data;
            }
            if (data instanceof ReferencedEnvelope) {
                return new GeometryFactory().toGeometry((Envelope)((ReferencedEnvelope)data).transform(this.crs, true));
            }
            if (data instanceof Envelope) {
                return new GeometryFactory().toGeometry((Envelope)data);
            }
            if (data instanceof CoordinateReferenceSystem) {
                return new GeometryFactory().toGeometry((Envelope)new ReferencedEnvelope((CoordinateReferenceSystem)data).transform(this.crs, true));
            }
        }
        catch (FactoryException | TransformException e) {
            LOGGER.warn("Unable to transform geometry", e);
            return null;
        }
        throw new ClassCastException("Could not cast data to ReferencedEnvelope");
    }

    public Object visit(ExcludeFilter filter, Object data) {
        return new ExtractGeometryFilterVisitorResult(null, null);
    }

    public Object visit(IncludeFilter filter, Object data) {
        return new ExtractGeometryFilterVisitorResult(this.infinity(), null);
    }

    private Geometry infinity() {
        return GeometryUtils.infinity();
    }

    public Object visit(BBOX filter, Object data) {
        if (this.attributeOfInterest.equals(filter.getExpression1().toString())) {
            Geometry bbox = this.bbox(data);
            BoundingBox referencedBBox = filter.getBounds();
            Geometry bounds = new GeometryFactory().toGeometry(new Envelope(referencedBBox.getMinX(), referencedBBox.getMaxX(), referencedBBox.getMinY(), referencedBBox.getMaxY()));
            if (this.crs != null && referencedBBox.getCoordinateReferenceSystem() != null && !this.crs.equals(referencedBBox.getCoordinateReferenceSystem())) {
                try {
                    bounds = JTS.transform((Geometry)bounds, (MathTransform)CRS.findMathTransform((CoordinateReferenceSystem)referencedBBox.getCoordinateReferenceSystem(), (CoordinateReferenceSystem)this.crs, (boolean)true));
                }
                catch (MismatchedDimensionException | FactoryException | TransformException e) {
                    LOGGER.error("Unable to transforma bbox", e);
                }
            }
            if (bbox != null) {
                return bbox.union(bounds);
            }
            return new ExtractGeometryFilterVisitorResult(bounds, SpatialQueryFilter.CompareOperation.INTERSECTS);
        }
        return new ExtractGeometryFilterVisitorResult(this.infinity(), null);
    }

    public Object visit(Literal expression, Object data) {
        Object value = expression.getValue();
        if (value instanceof Geometry) {
            Geometry geometry = (Geometry)value;
            return geometry;
        }
        LOGGER.info("LiteralExpression ignored!");
        return this.bbox(data);
    }

    public Object visit(And filter, Object data) {
        ExtractGeometryFilterVisitorResult finalResult = null;
        for (Filter f : filter.getChildren()) {
            Object obj = f.accept((FilterVisitor)this, data);
            if (obj == null || !(obj instanceof ExtractGeometryFilterVisitorResult)) continue;
            ExtractGeometryFilterVisitorResult currentResult = (ExtractGeometryFilterVisitorResult)obj;
            Geometry currentGeom = currentResult.getGeometry();
            double currentArea = currentGeom.getArea();
            if (finalResult == null) {
                finalResult = currentResult;
                continue;
            }
            if (!Double.isInfinite(currentArea) && !Double.isNaN(currentArea)) {
                if (currentResult.matchPredicate(finalResult)) {
                    finalResult = new ExtractGeometryFilterVisitorResult(finalResult.getGeometry().intersection(currentGeom), currentResult.getCompareOp());
                    continue;
                }
                finalResult = new ExtractGeometryFilterVisitorResult(finalResult.getGeometry().intersection(currentGeom), null);
                continue;
            }
            finalResult = new ExtractGeometryFilterVisitorResult(finalResult.getGeometry(), null);
        }
        return finalResult;
    }

    public Object visit(Not filter, Object data) {
        return new ExtractGeometryFilterVisitorResult(this.infinity(), null);
    }

    public Object visit(Or filter, Object data) {
        ExtractGeometryFilterVisitorResult finalResult = new ExtractGeometryFilterVisitorResult(new GeometryFactory().toGeometry(new Envelope()), null);
        for (Filter f : filter.getChildren()) {
            Object obj = f.accept((FilterVisitor)this, data);
            if (obj == null || !(obj instanceof ExtractGeometryFilterVisitorResult)) continue;
            ExtractGeometryFilterVisitorResult currentResult = (ExtractGeometryFilterVisitorResult)obj;
            Geometry currentGeom = currentResult.getGeometry();
            double currentArea = currentGeom.getArea();
            if (finalResult.getGeometry().isEmpty()) {
                finalResult = currentResult;
                continue;
            }
            if (!Double.isInfinite(currentArea) && !Double.isNaN(currentArea)) {
                if (currentResult.matchPredicate(finalResult)) {
                    finalResult = new ExtractGeometryFilterVisitorResult(finalResult.getGeometry().union(currentGeom), currentResult.getCompareOp());
                    continue;
                }
                finalResult = new ExtractGeometryFilterVisitorResult(finalResult.getGeometry().union(currentGeom), null);
                continue;
            }
            finalResult = new ExtractGeometryFilterVisitorResult(finalResult.getGeometry(), null);
        }
        if (finalResult.getGeometry().isEmpty()) {
            return new ExtractGeometryFilterVisitorResult(this.infinity(), null);
        }
        return finalResult;
    }

    public Object visit(Beyond filter, Object data) {
        return new ExtractGeometryFilterVisitorResult(this.infinity(), null);
    }

    public Object visit(Contains filter, Object data) {
        if (!this.attributeOfInterest.equals(filter.getExpression1().toString())) {
            return new ExtractGeometryFilterVisitorResult(this.infinity(), null);
        }
        data = filter.getExpression2().accept((ExpressionVisitor)this, data);
        return new ExtractGeometryFilterVisitorResult((Geometry)data, SpatialQueryFilter.CompareOperation.WITHIN);
    }

    public Object visit(Crosses filter, Object data) {
        if (!this.attributeOfInterest.equals(filter.getExpression1().toString())) {
            return new ExtractGeometryFilterVisitorResult(this.infinity(), null);
        }
        data = filter.getExpression2().accept((ExpressionVisitor)this, data);
        return new ExtractGeometryFilterVisitorResult((Geometry)data, SpatialQueryFilter.CompareOperation.CROSSES);
    }

    public Object visit(Disjoint filter, Object data) {
        return new ExtractGeometryFilterVisitorResult(this.infinity(), null);
    }

    public Object visit(DWithin filter, Object data) {
        Pair geometryAndDegrees;
        Geometry bbox = this.bbox(data);
        if (!this.attributeOfInterest.equals(filter.getExpression1().toString())) {
            return new ExtractGeometryFilterVisitorResult(this.infinity(), null);
        }
        Literal geometry = null;
        if (filter.getExpression1() instanceof PropertyName && filter.getExpression2() instanceof Literal) {
            geometry = (Literal)filter.getExpression2();
        }
        if (filter.getExpression2() instanceof PropertyName && filter.getExpression1() instanceof Literal) {
            geometry = (Literal)filter.getExpression1();
        }
        if (geometry == null) {
            return null;
        }
        Geometry geom = (Geometry)geometry.evaluate(null, Geometry.class);
        if (geom == null) {
            return new ExtractGeometryFilterVisitorResult(this.infinity(), null);
        }
        try {
            geometryAndDegrees = GeometryUtils.buffer(this.crs, geom, filter.getDistanceUnits(), filter.getDistance());
        }
        catch (TransformException e) {
            LOGGER.error("Cannot transform geometry to CRS", (Throwable)e);
            geometryAndDegrees = Pair.of((Object)geom, (Object)filter.getDistance());
        }
        if (bbox != null) {
            return ((Geometry)geometryAndDegrees.getLeft()).union(bbox);
        }
        return new ExtractGeometryFilterVisitorResult((Geometry)geometryAndDegrees.getLeft(), SpatialQueryFilter.CompareOperation.INTERSECTS);
    }

    public Object visit(Equals filter, Object data) {
        if (!this.attributeOfInterest.equals(filter.getExpression1().toString())) {
            return new ExtractGeometryFilterVisitorResult(this.infinity(), null);
        }
        data = filter.getExpression2().accept((ExpressionVisitor)this, data);
        return new ExtractGeometryFilterVisitorResult((Geometry)data, SpatialQueryFilter.CompareOperation.EQUALS);
    }

    public Object visit(Intersects filter, Object data) {
        if (!this.attributeOfInterest.equals(filter.getExpression1().toString())) {
            return new ExtractGeometryFilterVisitorResult(this.infinity(), null);
        }
        data = filter.getExpression2().accept((ExpressionVisitor)this, data);
        return new ExtractGeometryFilterVisitorResult((Geometry)data, SpatialQueryFilter.CompareOperation.INTERSECTS);
    }

    public Object visit(Overlaps filter, Object data) {
        if (!this.attributeOfInterest.equals(filter.getExpression1().toString())) {
            return new ExtractGeometryFilterVisitorResult(this.infinity(), null);
        }
        data = filter.getExpression2().accept((ExpressionVisitor)this, data);
        return new ExtractGeometryFilterVisitorResult((Geometry)data, SpatialQueryFilter.CompareOperation.OVERLAPS);
    }

    public Object visit(Touches filter, Object data) {
        if (!this.attributeOfInterest.equals(filter.getExpression1().toString())) {
            return new ExtractGeometryFilterVisitorResult(this.infinity(), null);
        }
        data = filter.getExpression2().accept((ExpressionVisitor)this, data);
        return new ExtractGeometryFilterVisitorResult((Geometry)data, SpatialQueryFilter.CompareOperation.TOUCHES);
    }

    public Object visit(Within filter, Object data) {
        if (!this.attributeOfInterest.equals(filter.getExpression1().toString())) {
            return new ExtractGeometryFilterVisitorResult(this.infinity(), null);
        }
        data = filter.getExpression2().accept((ExpressionVisitor)this, data);
        return new ExtractGeometryFilterVisitorResult((Geometry)data, SpatialQueryFilter.CompareOperation.CONTAINS);
    }

    public Object visit(Add expression, Object data) {
        return new ExtractGeometryFilterVisitorResult(this.infinity(), null);
    }

    public Object visit(Divide expression, Object data) {
        return new ExtractGeometryFilterVisitorResult(this.infinity(), null);
    }

    public Object visit(Function expression, Object data) {
        return new ExtractGeometryFilterVisitorResult(this.infinity(), null);
    }

    public Object visit(Id filter, Object data) {
        return new ExtractGeometryFilterVisitorResult(this.infinity(), null);
    }

    public Object visit(Multiply expression, Object data) {
        return new ExtractGeometryFilterVisitorResult(this.infinity(), null);
    }

    public Object visit(NilExpression expression, Object data) {
        return new ExtractGeometryFilterVisitorResult(this.infinity(), null);
    }

    public Object visit(PropertyIsBetween filter, Object data) {
        return new ExtractGeometryFilterVisitorResult(this.infinity(), null);
    }

    public Object visit(PropertyIsEqualTo filter, Object data) {
        return new ExtractGeometryFilterVisitorResult(this.infinity(), null);
    }

    public Object visit(PropertyIsGreaterThan filter, Object data) {
        return new ExtractGeometryFilterVisitorResult(this.infinity(), null);
    }

    public Object visit(PropertyIsGreaterThanOrEqualTo filter, Object data) {
        return new ExtractGeometryFilterVisitorResult(this.infinity(), null);
    }

    public Object visit(PropertyIsLessThan filter, Object data) {
        return new ExtractGeometryFilterVisitorResult(this.infinity(), null);
    }

    public Object visit(PropertyIsLessThanOrEqualTo filter, Object data) {
        return new ExtractGeometryFilterVisitorResult(this.infinity(), null);
    }

    public Object visit(PropertyIsLike filter, Object data) {
        return new ExtractGeometryFilterVisitorResult(this.infinity(), null);
    }

    public Object visit(PropertyIsNotEqualTo filter, Object data) {
        return new ExtractGeometryFilterVisitorResult(this.infinity(), null);
    }

    public Object visit(PropertyIsNull filter, Object data) {
        return new ExtractGeometryFilterVisitorResult(this.infinity(), null);
    }

    public Object visit(PropertyName expression, Object data) {
        return new ExtractGeometryFilterVisitorResult(null, null);
    }

    public Object visit(Subtract expression, Object data) {
        return new ExtractGeometryFilterVisitorResult(this.infinity(), null);
    }

    public Object visitNullFilter(Object data) {
        return new ExtractGeometryFilterVisitorResult(this.infinity(), null);
    }
}

