/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.store.statistics.binning;

import com.beust.jcommander.Parameter;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.locationtech.geowave.core.geotime.index.SpatialTemporalDimensionalityTypeProvider;
import org.locationtech.geowave.core.geotime.index.dimension.TemporalBinningStrategy;
import org.locationtech.geowave.core.geotime.util.TimeUtils;
import org.locationtech.geowave.core.index.ByteArray;
import org.locationtech.geowave.core.index.StringUtils;
import org.locationtech.geowave.core.index.VarintUtils;
import org.locationtech.geowave.core.index.dimension.bin.BinRange;
import org.locationtech.geowave.core.store.api.BinConstraints;
import org.locationtech.geowave.core.store.statistics.binning.FieldValueBinningStrategy;
import org.locationtech.geowave.core.store.statistics.query.BinConstraintsImpl;
import org.threeten.extra.Interval;

public class TimeRangeFieldValueBinningStrategy
extends FieldValueBinningStrategy {
    protected static TemporalBinningStrategy.Unit DEFAULT_PERIODICITY = TemporalBinningStrategy.Unit.DAY;
    public static final String NAME = "TIME_RANGE";
    @Parameter(names={"--binInteval"}, required=false, description="The interval or periodicity at which to bin time values.  Defaults to daily.", converter=SpatialTemporalDimensionalityTypeProvider.UnitConverter.class)
    protected TemporalBinningStrategy.Unit periodicity = DEFAULT_PERIODICITY;
    @Parameter(names={"-tz", "--timezone"}, required=false, description="The timezone to convert all incoming time values into. Defaults to GMT.")
    protected String timezone = "GMT";
    private TemporalBinningStrategy binningStrategy;

    public String getStrategyName() {
        return NAME;
    }

    public TimeRangeFieldValueBinningStrategy() {
    }

    public TimeRangeFieldValueBinningStrategy(String ... fields) {
        super(fields);
    }

    public TimeRangeFieldValueBinningStrategy(TemporalBinningStrategy.Unit periodicity, String ... fields) {
        this("GMT", periodicity, fields);
    }

    public TimeRangeFieldValueBinningStrategy(String timezone, TemporalBinningStrategy.Unit periodicity, String ... fields) {
        super(fields);
        this.periodicity = periodicity;
        this.timezone = timezone;
        this.binningStrategy = new TemporalBinningStrategy(periodicity, timezone);
    }

    public String getDescription() {
        return "Bin the statistic by the time value of a specified field.";
    }

    public Class<?>[] supportedConstraintClasses() {
        return (Class[])ArrayUtils.addAll((Object[])super.supportedConstraintClasses(), (Object[])new Class[]{Date.class, Calendar.class, Number.class, Interval.class, Interval[].class});
    }

    public BinConstraints.ByteArrayConstraints singleFieldConstraints(Object constraint) {
        if (constraint instanceof Interval) {
            return new BinConstraintsImpl.ExplicitConstraints(this.getNumericBins((Interval)constraint));
        }
        if (constraint instanceof Interval[]) {
            Stream<ByteArray[]> stream = Arrays.stream((Interval[])constraint).map(this::getNumericBins);
            return new BinConstraintsImpl.ExplicitConstraints((ByteArray[])stream.flatMap(Arrays::stream).toArray(ByteArray[]::new));
        }
        long timeMillis = TimeUtils.getTimeMillis(constraint);
        if (timeMillis != TimeUtils.RESERVED_MILLIS_FOR_NULL) {
            return new BinConstraintsImpl.ExplicitConstraints(new ByteArray[]{this.getTimeBin(timeMillis)});
        }
        return super.constraints(constraint);
    }

    protected ByteArray getSingleBin(Object value) {
        long millis = TimeUtils.getTimeMillis(value);
        if (millis == TimeUtils.RESERVED_MILLIS_FOR_NULL) {
            return new ByteArray();
        }
        return this.getTimeBin(millis);
    }

    private ByteArray getTimeBin(long millis) {
        return new ByteArray(this.binningStrategy.getBinId(millis));
    }

    private ByteArray[] getNumericBins(Interval value) {
        BinRange[] bins = this.binningStrategy.getNormalizedRanges(value);
        return (ByteArray[])Arrays.stream(bins).map(BinRange::getBinId).map(ByteArray::new).toArray(ByteArray[]::new);
    }

    public byte[] toBinary() {
        byte[] parentBinary = super.toBinary();
        byte[] timezoneBytes = StringUtils.stringToBinary((String)this.timezone);
        ByteBuffer buf = ByteBuffer.allocate(parentBinary.length + VarintUtils.unsignedIntByteLength((int)this.periodicity.ordinal()) + VarintUtils.unsignedIntByteLength((int)timezoneBytes.length) + timezoneBytes.length);
        VarintUtils.writeUnsignedInt((int)this.periodicity.ordinal(), (ByteBuffer)buf);
        VarintUtils.writeUnsignedInt((int)timezoneBytes.length, (ByteBuffer)buf);
        buf.put(timezoneBytes);
        buf.put(parentBinary);
        return buf.array();
    }

    public void fromBinary(byte[] bytes) {
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        this.periodicity = TemporalBinningStrategy.Unit.values()[VarintUtils.readUnsignedInt((ByteBuffer)buf)];
        byte[] timezoneBinary = new byte[VarintUtils.readUnsignedInt((ByteBuffer)buf)];
        buf.get(timezoneBinary);
        this.timezone = StringUtils.stringFromBinary((byte[])timezoneBinary);
        this.binningStrategy = new TemporalBinningStrategy(this.periodicity, this.timezone);
        byte[] parentBinary = new byte[buf.remaining()];
        buf.get(parentBinary);
        super.fromBinary(parentBinary);
    }

    public Interval getInterval(ByteArray binId) {
        return this.getInterval(binId.getBytes());
    }

    private Interval getInterval(byte[] binId) {
        return this.binningStrategy.getInterval(binId);
    }

    public String binToString(ByteArray bin) {
        ByteBuffer buffer = ByteBuffer.wrap(bin.getBytes());
        StringBuffer sb = new StringBuffer();
        while (buffer.remaining() > 0) {
            if (buffer.get() == 0) {
                sb.append("<null>");
            } else {
                byte[] binId = new byte[this.binningStrategy.getFixedBinIdSize()];
                buffer.get(binId);
                sb.append(this.getInterval(binId).toString());
            }
            if (buffer.remaining() <= 0) continue;
            sb.append(buffer.getChar());
        }
        return sb.toString();
    }
}

