/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.store.statistics.binning;

import com.beust.jcommander.IStringConverter;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.google.common.primitives.Bytes;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.locationtech.geowave.core.geotime.binning.ComplexGeometryBinningOption;
import org.locationtech.geowave.core.geotime.binning.SpatialBinningType;
import org.locationtech.geowave.core.geotime.util.GeometryUtils;
import org.locationtech.geowave.core.index.ByteArray;
import org.locationtech.geowave.core.index.VarintUtils;
import org.locationtech.geowave.core.store.api.BinConstraints;
import org.locationtech.geowave.core.store.api.DataTypeAdapter;
import org.locationtech.geowave.core.store.entities.GeoWaveRow;
import org.locationtech.geowave.core.store.statistics.binning.BinningStrategyUtils;
import org.locationtech.geowave.core.store.statistics.binning.FieldValueBinningStrategy;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;

public class SpatialFieldValueBinningStrategy
extends FieldValueBinningStrategy {
    public static final String NAME = "SPATIAL";
    @Parameter(names={"--precision", "--resolution", "--length", "--level"}, description="The precision (also called resolution, length, or level) of the binning strategy")
    protected int precision = 8;
    @Parameter(names={"--geometry"}, converter=ComplexGeometryBinningOptionConverter.class, description="Approach for handling complex geometry. Available options are 'USE_CENTROID_ONLY', 'USE_FULL_GEOMETRY', and 'USE_FULL_GEOMETRY_SCALE_BY_OVERLAP'.")
    protected ComplexGeometryBinningOption complexGeometry = ComplexGeometryBinningOption.USE_CENTROID_ONLY;
    @Parameter(names={"--type"}, converter=SpatialBinningTypeConverter.class, description="The type of binning (either h3, s2, or geohash).")
    protected SpatialBinningType type = SpatialBinningType.S2;

    public SpatialFieldValueBinningStrategy() {
    }

    public SpatialFieldValueBinningStrategy(String ... fields) {
        super(fields);
    }

    public SpatialFieldValueBinningStrategy(SpatialBinningType type, int precision, ComplexGeometryBinningOption complexGeometry, String ... fields) {
        super(fields);
        this.type = type;
        this.precision = precision;
        this.complexGeometry = complexGeometry;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public ComplexGeometryBinningOption getComplexGeometry() {
        return this.complexGeometry;
    }

    public void setComplexGeometry(ComplexGeometryBinningOption complexGeometry) {
        this.complexGeometry = complexGeometry;
    }

    public SpatialBinningType getType() {
        return this.type;
    }

    public void setType(SpatialBinningType type) {
        this.type = type;
    }

    public String getDefaultTag() {
        return super.getDefaultTag() + "-" + this.type + "(" + this.precision + ")";
    }

    public String getDescription() {
        return "Bin a statistic by a spatial aggregation (such as geohash, H3, or S2) on a specified geometry field.";
    }

    public String getStrategyName() {
        return NAME;
    }

    protected ByteArray[] getSpatialBins(Geometry geometry) {
        return this.type.getSpatialBins(geometry, this.precision);
    }

    public Class<?>[] supportedConstraintClasses() {
        return (Class[])ArrayUtils.addAll((Object[])super.supportedConstraintClasses(), (Object[])new Class[]{Envelope.class, Envelope[].class, Geometry.class, Geometry[].class});
    }

    private ByteArray[] getSpatialBinsFromObj(Object value) {
        if (value instanceof Geometry) {
            if (ComplexGeometryBinningOption.USE_CENTROID_ONLY.equals((Object)this.complexGeometry)) {
                return this.getSpatialBins((Geometry)((Geometry)value).getCentroid());
            }
            return this.getSpatialBins((Geometry)value);
        }
        return new ByteArray[0];
    }

    public <T> ByteArray[] getBins(DataTypeAdapter<T> adapter, T entry, GeoWaveRow ... rows) {
        if (this.fields.isEmpty()) {
            return new ByteArray[0];
        }
        if (this.fields.size() == 1) {
            Object value = adapter.getFieldValue(entry, (String)this.fields.get(0));
            return this.getSpatialBinsFromObj(value);
        }
        ByteArray[][] fieldValues = (ByteArray[][])this.fields.stream().map(field -> this.getSpatialBinsFromObj(adapter.getFieldValue(entry, field))).toArray(x$0 -> new ByteArray[x$0][]);
        return SpatialFieldValueBinningStrategy.getAllCombinationsNoSeparator(fieldValues);
    }

    public String binToString(ByteArray bin) {
        ByteBuffer buffer = ByteBuffer.wrap(bin.getBytes());
        StringBuffer sb = new StringBuffer();
        while (buffer.remaining() > 0) {
            byte[] binId = new byte[this.type.getBinByteLength(this.precision)];
            buffer.get(binId);
            sb.append(this.type.binToString(binId));
        }
        if (buffer.remaining() > 0) {
            sb.append('|');
        }
        return sb.toString();
    }

    public byte[] toBinary() {
        byte[] parentBinary = super.toBinary();
        ByteBuffer buf = ByteBuffer.allocate(parentBinary.length + VarintUtils.unsignedIntByteLength((int)this.precision) + VarintUtils.unsignedIntByteLength((int)this.complexGeometry.ordinal()) + VarintUtils.unsignedIntByteLength((int)this.type.ordinal()));
        VarintUtils.writeUnsignedInt((int)this.type.ordinal(), (ByteBuffer)buf);
        VarintUtils.writeUnsignedInt((int)this.precision, (ByteBuffer)buf);
        VarintUtils.writeUnsignedInt((int)this.complexGeometry.ordinal(), (ByteBuffer)buf);
        buf.put(parentBinary);
        return buf.array();
    }

    public void fromBinary(byte[] bytes) {
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        this.type = SpatialBinningType.values()[VarintUtils.readUnsignedInt((ByteBuffer)buf)];
        this.precision = VarintUtils.readUnsignedInt((ByteBuffer)buf);
        this.complexGeometry = ComplexGeometryBinningOption.values()[VarintUtils.readUnsignedInt((ByteBuffer)buf)];
        byte[] parentBinary = new byte[buf.remaining()];
        buf.get(parentBinary);
        super.fromBinary(parentBinary);
    }

    public <T> double getWeight(ByteArray bin, DataTypeAdapter<T> type, T entry, GeoWaveRow ... rows) {
        if (ComplexGeometryBinningOption.USE_FULL_GEOMETRY_SCALE_BY_OVERLAP.equals((Object)this.complexGeometry)) {
            ByteBuffer buffer = ByteBuffer.wrap(bin.getBytes());
            double weight = 1.0;
            int i = 0;
            while (buffer.remaining() > 0) {
                Object value;
                byte[] binId = new byte[this.type.getBinByteLength(this.precision)];
                buffer.get(binId);
                Geometry binGeom = this.type.getBinGeometry(new ByteArray(binId), this.precision);
                if (!((value = type.getFieldValue(entry, (String)this.fields.get(i++))) instanceof Geometry)) continue;
                double area = ((Geometry)value).getArea();
                if (area > 0.0) {
                    if (!binGeom.intersects((Geometry)value)) continue;
                    double intersectionArea = binGeom.intersection((Geometry)value).getArea();
                    double fieldWeight = intersectionArea / ((Geometry)value).getArea();
                    weight *= fieldWeight;
                    continue;
                }
                double length = ((Geometry)value).getLength();
                if (!(length > 0.0)) continue;
                double intersectionLength = binGeom.intersection((Geometry)value).getLength();
                double fieldWeight = intersectionLength / ((Geometry)value).getLength();
                weight *= fieldWeight;
            }
            return weight;
        }
        return 1.0;
    }

    protected BinConstraints.ByteArrayConstraints singleFieldConstraints(Object constraints) {
        if (constraints instanceof Envelope[]) {
            return this.type.getGeometryConstraints((Geometry)GeometryUtils.GEOMETRY_FACTORY.createGeometryCollection((Geometry[])Arrays.stream((Envelope[])constraints).map(arg_0 -> ((GeometryFactory)GeometryUtils.GEOMETRY_FACTORY).toGeometry(arg_0)).toArray(Geometry[]::new)), this.precision);
        }
        if (constraints instanceof Envelope) {
            return this.type.getGeometryConstraints(GeometryUtils.GEOMETRY_FACTORY.toGeometry((Envelope)constraints), this.precision);
        }
        if (constraints instanceof Geometry) {
            return this.type.getGeometryConstraints((Geometry)constraints, this.precision);
        }
        if (constraints instanceof Geometry[]) {
            return this.type.getGeometryConstraints((Geometry)GeometryUtils.GEOMETRY_FACTORY.createGeometryCollection((Geometry[])constraints), this.precision);
        }
        return super.singleFieldConstraints(constraints);
    }

    private static ByteArray[] getAllCombinationsNoSeparator(ByteArray[][] perFieldBins) {
        return BinningStrategyUtils.getAllCombinations((ByteArray[][])perFieldBins, a -> new ByteArray(Bytes.concat((byte[][])((byte[][])Arrays.stream(a).map(ByteArray::getBytes).toArray(x$0 -> new byte[x$0][])))));
    }

    public static class SpatialBinningTypeConverter
    implements IStringConverter<SpatialBinningType> {
        public SpatialBinningType convert(String value) {
            SpatialBinningType convertedValue = null;
            try {
                convertedValue = SpatialBinningType.valueOf(value.toUpperCase());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (convertedValue == null) {
                throw new ParameterException("Value " + value + "can not be converted to SpatialBinningType. Available values are: " + Arrays.toString(SpatialBinningType.values()));
            }
            return convertedValue;
        }
    }

    public static class ComplexGeometryBinningOptionConverter
    implements IStringConverter<ComplexGeometryBinningOption> {
        public ComplexGeometryBinningOption convert(String value) {
            ComplexGeometryBinningOption convertedValue = null;
            try {
                convertedValue = ComplexGeometryBinningOption.valueOf(value.toUpperCase());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (convertedValue == null) {
                throw new ParameterException("Value " + value + "can not be converted to ComplexGeometryBinningOption. Available values are: " + Arrays.toString((Object[])ComplexGeometryBinningOption.values()));
            }
            return convertedValue;
        }
    }
}

