/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.store.statistics;

import java.util.Calendar;
import java.util.Date;
import org.locationtech.geowave.core.geotime.store.statistics.AbstractTimeRangeValue;
import org.locationtech.geowave.core.geotime.util.TimeUtils;
import org.locationtech.geowave.core.store.api.DataTypeAdapter;
import org.locationtech.geowave.core.store.api.FieldStatistic;
import org.locationtech.geowave.core.store.api.Statistic;
import org.locationtech.geowave.core.store.entities.GeoWaveRow;
import org.locationtech.geowave.core.store.statistics.field.FieldStatisticType;
import org.threeten.extra.Interval;

public class TimeRangeStatistic
extends FieldStatistic<TimeRangeValue> {
    public static final FieldStatisticType<TimeRangeValue> STATS_TYPE = new FieldStatisticType("TIME_RANGE");

    public TimeRangeStatistic() {
        super(STATS_TYPE);
    }

    public TimeRangeStatistic(String typeName, String fieldName) {
        super(STATS_TYPE, typeName, fieldName);
    }

    public String getDescription() {
        return "Maintains the time range of a temporal field.";
    }

    public TimeRangeValue createEmpty() {
        return new TimeRangeValue((Statistic<?>)this);
    }

    public boolean isCompatibleWith(Class<?> fieldClass) {
        return Date.class.isAssignableFrom(fieldClass) || Calendar.class.isAssignableFrom(fieldClass) || Number.class.isAssignableFrom(fieldClass);
    }

    public static class TimeRangeValue
    extends AbstractTimeRangeValue {
        public TimeRangeValue() {
            this(null);
        }

        public TimeRangeValue(Statistic<?> statistic) {
            super(statistic);
        }

        @Override
        protected <T> Interval getInterval(DataTypeAdapter<T> adapter, T entry, GeoWaveRow ... rows) {
            Object fieldValue = adapter.getFieldValue(entry, ((TimeRangeStatistic)this.statistic).getFieldName());
            return TimeUtils.getInterval(fieldValue);
        }
    }
}

