/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.store.statistics;

import com.beust.jcommander.IStringConverter;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import java.nio.ByteBuffer;
import org.geotools.referencing.CRS;
import org.locationtech.geowave.core.geotime.store.statistics.AbstractBoundingBoxValue;
import org.locationtech.geowave.core.geotime.util.GeometryUtils;
import org.locationtech.geowave.core.index.StringUtils;
import org.locationtech.geowave.core.index.VarintUtils;
import org.locationtech.geowave.core.store.api.DataTypeAdapter;
import org.locationtech.geowave.core.store.api.FieldStatistic;
import org.locationtech.geowave.core.store.api.Statistic;
import org.locationtech.geowave.core.store.entities.GeoWaveRow;
import org.locationtech.geowave.core.store.statistics.field.FieldStatisticType;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public class BoundingBoxStatistic
extends FieldStatistic<BoundingBoxValue> {
    public static final FieldStatisticType<BoundingBoxValue> STATS_TYPE = new FieldStatisticType("BOUNDING_BOX");
    @Parameter(names={"--sourceCrs"}, description="CRS of source geometry.", converter=CRSConverter.class)
    private CoordinateReferenceSystem sourceCrs = null;
    @Parameter(names={"--crs"}, description="CRS of the bounding box statistic.", converter=CRSConverter.class)
    private CoordinateReferenceSystem destinationCrs = null;
    private MathTransform crsTransform = null;
    private byte[] sourceCrsBytes = null;
    private byte[] destinationCrsBytes = null;

    public BoundingBoxStatistic() {
        this(null, null);
    }

    public BoundingBoxStatistic(String typeName, String fieldName) {
        this(typeName, fieldName, null, null);
    }

    public BoundingBoxStatistic(String typeName, String fieldName, CoordinateReferenceSystem sourceCrs, CoordinateReferenceSystem destinationCrs) {
        super(STATS_TYPE, typeName, fieldName);
        this.sourceCrs = sourceCrs;
        this.destinationCrs = destinationCrs;
    }

    public MathTransform getTransform() {
        if (this.sourceCrs != null && this.destinationCrs != null && this.crsTransform == null) {
            try {
                this.crsTransform = CRS.findMathTransform((CoordinateReferenceSystem)this.sourceCrs, (CoordinateReferenceSystem)this.destinationCrs, (boolean)true);
            }
            catch (FactoryException e) {
                throw new ParameterException("Unable to create CRS transform for bounding box statistic.", (Throwable)e);
            }
        }
        return this.crsTransform;
    }

    public void setSourceCrs(CoordinateReferenceSystem sourceCrs) {
        this.sourceCrs = sourceCrs;
    }

    public CoordinateReferenceSystem getSourceCrs() {
        return this.sourceCrs;
    }

    public void setDestinationCrs(CoordinateReferenceSystem destinationCrs) {
        this.destinationCrs = destinationCrs;
    }

    public CoordinateReferenceSystem getDestinationCrs() {
        return this.destinationCrs;
    }

    public boolean isCompatibleWith(Class<?> fieldClass) {
        return Geometry.class.isAssignableFrom(fieldClass);
    }

    public String getDescription() {
        return "Maintains the bounding box for a geometry field.";
    }

    public BoundingBoxValue createEmpty() {
        return new BoundingBoxValue((Statistic<?>)this);
    }

    private void transformToBytes() {
        this.sourceCrsBytes = this.sourceCrs == null ? new byte[]{} : StringUtils.stringToBinary((String)this.sourceCrs.toWKT());
        this.destinationCrsBytes = this.destinationCrs == null ? new byte[]{} : StringUtils.stringToBinary((String)this.destinationCrs.toWKT());
    }

    public int byteLength() {
        if (this.sourceCrsBytes == null) {
            this.transformToBytes();
        }
        return super.byteLength() + this.sourceCrsBytes.length + VarintUtils.unsignedShortByteLength((short)((short)this.sourceCrsBytes.length)) + this.destinationCrsBytes.length + VarintUtils.unsignedShortByteLength((short)((short)this.destinationCrsBytes.length));
    }

    public void writeBytes(ByteBuffer buffer) {
        super.writeBytes(buffer);
        if (this.sourceCrsBytes == null) {
            this.transformToBytes();
        }
        VarintUtils.writeUnsignedShort((short)((short)this.sourceCrsBytes.length), (ByteBuffer)buffer);
        buffer.put(this.sourceCrsBytes);
        VarintUtils.writeUnsignedShort((short)((short)this.destinationCrsBytes.length), (ByteBuffer)buffer);
        buffer.put(this.destinationCrsBytes);
        this.sourceCrsBytes = null;
        this.destinationCrsBytes = null;
    }

    public void readBytes(ByteBuffer buffer) {
        super.readBytes(buffer);
        try {
            short length = VarintUtils.readUnsignedShort((ByteBuffer)buffer);
            this.sourceCrsBytes = new byte[length];
            buffer.get(this.sourceCrsBytes);
            if (length > 0) {
                this.sourceCrs = CRS.parseWKT((String)StringUtils.stringFromBinary((byte[])this.sourceCrsBytes));
            }
            length = VarintUtils.readUnsignedShort((ByteBuffer)buffer);
            this.destinationCrsBytes = new byte[length];
            buffer.get(this.destinationCrsBytes);
            if (length > 0) {
                this.destinationCrs = CRS.parseWKT((String)StringUtils.stringFromBinary((byte[])this.destinationCrsBytes));
            }
        }
        catch (FactoryException e) {
            throw new RuntimeException("Unable to parse statistic CRS", e);
        }
        this.sourceCrsBytes = null;
        this.destinationCrsBytes = null;
    }

    public static class CRSConverter
    implements IStringConverter<CoordinateReferenceSystem> {
        public CoordinateReferenceSystem convert(String value) {
            CoordinateReferenceSystem convertedValue;
            try {
                convertedValue = CRS.decode((String)value);
            }
            catch (Exception e) {
                throw new ParameterException("Unrecognized CRS: " + value);
            }
            return convertedValue;
        }
    }

    public static class BoundingBoxValue
    extends AbstractBoundingBoxValue {
        public BoundingBoxValue() {
            this(null);
        }

        public BoundingBoxValue(Statistic<?> statistic) {
            super(statistic);
        }

        @Override
        public <T> Envelope getEnvelope(DataTypeAdapter<T> adapter, T entry, GeoWaveRow ... rows) {
            BoundingBoxStatistic bboxStatistic = (BoundingBoxStatistic)this.statistic;
            Object fieldValue = adapter.getFieldValue(entry, bboxStatistic.getFieldName());
            if (fieldValue != null && fieldValue instanceof Geometry) {
                Geometry geometry = (Geometry)fieldValue;
                if (bboxStatistic.getTransform() != null) {
                    geometry = GeometryUtils.crsTransform(geometry, bboxStatistic.getTransform());
                }
                if (geometry != null && !geometry.isEmpty()) {
                    return geometry.getEnvelopeInternal();
                }
            }
            return null;
        }
    }
}

