/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.store.statistics;

import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.locationtech.geowave.core.geotime.store.query.TemporalRange;
import org.locationtech.geowave.core.index.Mergeable;
import org.locationtech.geowave.core.index.VarintUtils;
import org.locationtech.geowave.core.store.api.DataTypeAdapter;
import org.locationtech.geowave.core.store.api.Statistic;
import org.locationtech.geowave.core.store.api.StatisticValue;
import org.locationtech.geowave.core.store.entities.GeoWaveRow;
import org.locationtech.geowave.core.store.statistics.StatisticsIngestCallback;
import org.threeten.extra.Interval;

public abstract class AbstractTimeRangeValue
extends StatisticValue<Interval>
implements StatisticsIngestCallback {
    private long min = Long.MAX_VALUE;
    private long max = Long.MIN_VALUE;

    protected AbstractTimeRangeValue(Statistic<?> statistic) {
        super(statistic);
    }

    public boolean isSet() {
        return this.min != Long.MAX_VALUE || this.max != Long.MIN_VALUE;
    }

    public TemporalRange asTemporalRange() {
        return new TemporalRange(new Date(this.getMin()), new Date(this.getMax()));
    }

    public long getMin() {
        return this.min;
    }

    public long getMax() {
        return this.max;
    }

    public long getRange() {
        return this.max - this.min;
    }

    public Date getMaxTime() {
        Calendar c = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        c.setTimeInMillis(this.getMax());
        return c.getTime();
    }

    public Date getMinTime() {
        Calendar c = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        c.setTimeInMillis(this.getMin());
        return c.getTime();
    }

    public byte[] toBinary() {
        ByteBuffer buffer = ByteBuffer.allocate(VarintUtils.timeByteLength((long)this.min) + VarintUtils.timeByteLength((long)this.max));
        VarintUtils.writeTime((long)this.min, (ByteBuffer)buffer);
        VarintUtils.writeTime((long)this.max, (ByteBuffer)buffer);
        return buffer.array();
    }

    public void fromBinary(byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        this.min = VarintUtils.readTime((ByteBuffer)buffer);
        this.max = VarintUtils.readTime((ByteBuffer)buffer);
    }

    public <T> void entryIngested(DataTypeAdapter<T> adapter, T entry, GeoWaveRow ... rows) {
        Interval range = this.getInterval(adapter, entry, rows);
        if (range != null) {
            this.min = Math.min(this.min, range.getStart().toEpochMilli());
            this.max = Math.max(this.max, range.getEnd().toEpochMilli());
        }
    }

    protected abstract <T> Interval getInterval(DataTypeAdapter<T> var1, T var2, GeoWaveRow ... var3);

    public void merge(Mergeable merge) {
        AbstractTimeRangeValue stats;
        if (merge != null && merge instanceof AbstractTimeRangeValue && (stats = (AbstractTimeRangeValue)merge).isSet()) {
            this.min = Math.min(this.min, stats.getMin());
            this.max = Math.max(this.max, stats.getMax());
        }
    }

    public Interval getValue() {
        if (this.isSet()) {
            return Interval.of((Instant)Instant.ofEpochMilli(this.min), (Instant)Instant.ofEpochMilli(this.max));
        }
        return null;
    }
}

