/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.store.statistics;

import java.nio.ByteBuffer;
import org.locationtech.geowave.core.index.Mergeable;
import org.locationtech.geowave.core.store.api.DataTypeAdapter;
import org.locationtech.geowave.core.store.api.Statistic;
import org.locationtech.geowave.core.store.api.StatisticValue;
import org.locationtech.geowave.core.store.entities.GeoWaveRow;
import org.locationtech.geowave.core.store.statistics.StatisticsIngestCallback;
import org.locationtech.jts.geom.Envelope;

public abstract class AbstractBoundingBoxValue
extends StatisticValue<Envelope>
implements StatisticsIngestCallback {
    protected double minX = Double.MAX_VALUE;
    protected double minY = Double.MAX_VALUE;
    protected double maxX = -1.7976931348623157E308;
    protected double maxY = -1.7976931348623157E308;

    protected AbstractBoundingBoxValue(Statistic<?> statistic) {
        super(statistic);
    }

    public boolean isSet() {
        return this.minX != Double.MAX_VALUE && this.minY != Double.MAX_VALUE && this.maxX != -1.7976931348623157E308 && this.maxY != -1.7976931348623157E308;
    }

    public double getMinX() {
        return this.minX;
    }

    public double getMinY() {
        return this.minY;
    }

    public double getMaxX() {
        return this.maxX;
    }

    public double getMaxY() {
        return this.maxY;
    }

    public double getWidth() {
        return this.maxX - this.minX;
    }

    public double getHeight() {
        return this.maxY - this.minY;
    }

    public void merge(Mergeable merge) {
        AbstractBoundingBoxValue bboxStats;
        if (merge != null && merge instanceof AbstractBoundingBoxValue && (bboxStats = (AbstractBoundingBoxValue)merge).isSet()) {
            this.minX = Math.min(this.minX, bboxStats.minX);
            this.minY = Math.min(this.minY, bboxStats.minY);
            this.maxX = Math.max(this.maxX, bboxStats.maxX);
            this.maxY = Math.max(this.maxY, bboxStats.maxY);
        }
    }

    public <T> void entryIngested(DataTypeAdapter<T> adapter, T entry, GeoWaveRow ... rows) {
        Envelope env = this.getEnvelope(adapter, entry, new GeoWaveRow[0]);
        if (env != null) {
            this.minX = Math.min(this.minX, env.getMinX());
            this.minY = Math.min(this.minY, env.getMinY());
            this.maxX = Math.max(this.maxX, env.getMaxX());
            this.maxY = Math.max(this.maxY, env.getMaxY());
        }
    }

    public abstract <T> Envelope getEnvelope(DataTypeAdapter<T> var1, T var2, GeoWaveRow ... var3);

    public Envelope getValue() {
        if (this.isSet()) {
            return new Envelope(this.minX, this.maxX, this.minY, this.maxY);
        }
        return new Envelope();
    }

    public byte[] toBinary() {
        ByteBuffer buffer = ByteBuffer.allocate(32);
        buffer.putDouble(this.minX);
        buffer.putDouble(this.minY);
        buffer.putDouble(this.maxX);
        buffer.putDouble(this.maxY);
        return buffer.array();
    }

    public void fromBinary(byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        this.minX = buffer.getDouble();
        this.minY = buffer.getDouble();
        this.maxX = buffer.getDouble();
        this.maxY = buffer.getDouble();
    }
}

