/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.store.query.gwql;

import java.util.List;
import org.locationtech.geowave.core.geotime.store.query.filter.expression.temporal.TemporalExpression;
import org.locationtech.geowave.core.geotime.store.query.gwql.DateCastableType;
import org.locationtech.geowave.core.store.query.filter.expression.Expression;
import org.locationtech.geowave.core.store.query.filter.expression.Predicate;
import org.locationtech.geowave.core.store.query.gwql.GWQLParseException;
import org.locationtech.geowave.core.store.query.gwql.function.predicate.PredicateFunction;

public class TemporalPredicates {

    public static class OverlapsFunction
    extends TemporalPredicateFunction {
        public String getName() {
            return "TOVERLAPS";
        }

        @Override
        protected Predicate createInternal(TemporalExpression expression1, TemporalExpression expression2) {
            return expression1.overlaps(expression2);
        }
    }

    public static class ContainsFunction
    extends TemporalPredicateFunction {
        public String getName() {
            return "TCONTAINS";
        }

        @Override
        protected Predicate createInternal(TemporalExpression expression1, TemporalExpression expression2) {
            return expression1.contains(expression2);
        }
    }

    private static abstract class TemporalPredicateFunction
    implements PredicateFunction {
        private TemporalPredicateFunction() {
        }

        public Predicate create(List<Expression<?>> arguments) {
            if (arguments.size() == 2) {
                TemporalExpression expression1 = DateCastableType.toTemporalExpression(arguments.get(0));
                TemporalExpression expression2 = DateCastableType.toTemporalExpression(arguments.get(1));
                return this.createInternal(expression1, expression2);
            }
            throw new GWQLParseException("Function expects 2 arguments, got " + arguments.size());
        }

        protected abstract Predicate createInternal(TemporalExpression var1, TemporalExpression var2);
    }
}

