/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.store.query.gwql;

import org.locationtech.geowave.core.geotime.store.query.gwql.DateCastableType;
import org.locationtech.geowave.core.store.query.filter.expression.Expression;
import org.locationtech.geowave.core.store.query.filter.expression.Predicate;
import org.locationtech.geowave.core.store.query.gwql.function.operator.OperatorFunction;

public class TemporalOperators {

    public static class AfterOperator
    implements OperatorFunction {
        public String getName() {
            return "AFTER";
        }

        public Predicate create(Expression<?> expression1, Expression<?> expression2) {
            return DateCastableType.toTemporalExpression(expression1).isAfter(DateCastableType.toTemporalExpression(expression2));
        }
    }

    public static class DuringOrAfterOperator
    implements OperatorFunction {
        public String getName() {
            return "DURING_OR_AFTER";
        }

        public Predicate create(Expression<?> expression1, Expression<?> expression2) {
            return DateCastableType.toTemporalExpression(expression1).isDuringOrAfter(DateCastableType.toTemporalExpression(expression2));
        }
    }

    public static class DuringOperator
    implements OperatorFunction {
        public String getName() {
            return "DURING";
        }

        public Predicate create(Expression<?> expression1, Expression<?> expression2) {
            return DateCastableType.toTemporalExpression(expression1).isDuring(DateCastableType.toTemporalExpression(expression2));
        }
    }

    public static class BeforeOrDuringOperator
    implements OperatorFunction {
        public String getName() {
            return "BEFORE_OR_DURING";
        }

        public Predicate create(Expression<?> expression1, Expression<?> expression2) {
            return DateCastableType.toTemporalExpression(expression1).isBeforeOrDuring(DateCastableType.toTemporalExpression(expression2));
        }
    }

    public static class BeforeOperator
    implements OperatorFunction {
        public String getName() {
            return "BEFORE";
        }

        public Predicate create(Expression<?> expression1, Expression<?> expression2) {
            return DateCastableType.toTemporalExpression(expression1).isBefore(DateCastableType.toTemporalExpression(expression2));
        }
    }
}

