/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.store.query.gwql;

import java.util.List;
import org.locationtech.geowave.core.geotime.store.query.filter.expression.spatial.SpatialExpression;
import org.locationtech.geowave.core.geotime.store.query.gwql.GeometryCastableType;
import org.locationtech.geowave.core.geotime.util.GeometryUtils;
import org.locationtech.geowave.core.store.query.filter.expression.Expression;
import org.locationtech.geowave.core.store.query.filter.expression.Predicate;
import org.locationtech.geowave.core.store.query.filter.expression.numeric.NumericExpression;
import org.locationtech.geowave.core.store.query.filter.expression.text.TextExpression;
import org.locationtech.geowave.core.store.query.gwql.GWQLParseException;
import org.locationtech.geowave.core.store.query.gwql.function.predicate.PredicateFunction;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class SpatialPredicates {

    public static class ContainsFunction
    extends SpatialPredicateFunction {
        public String getName() {
            return "CONTAINS";
        }

        @Override
        protected Predicate createInternal(SpatialExpression expression1, SpatialExpression expression2) {
            return expression1.contains(expression2);
        }
    }

    public static class WithinFunction
    extends SpatialPredicateFunction {
        public String getName() {
            return "WITHIN";
        }

        @Override
        protected Predicate createInternal(SpatialExpression expression1, SpatialExpression expression2) {
            return expression1.within(expression2);
        }
    }

    public static class TouchesFunction
    extends SpatialPredicateFunction {
        public String getName() {
            return "TOUCHES";
        }

        @Override
        protected Predicate createInternal(SpatialExpression expression1, SpatialExpression expression2) {
            return expression1.touches(expression2);
        }
    }

    public static class OverlapsFunction
    extends SpatialPredicateFunction {
        public String getName() {
            return "OVERLAPS";
        }

        @Override
        protected Predicate createInternal(SpatialExpression expression1, SpatialExpression expression2) {
            return expression1.overlaps(expression2);
        }
    }

    public static class CrossesFunction
    extends SpatialPredicateFunction {
        public String getName() {
            return "CROSSES";
        }

        @Override
        protected Predicate createInternal(SpatialExpression expression1, SpatialExpression expression2) {
            return expression1.crosses(expression2);
        }
    }

    public static class DisjointLooseFunction
    extends SpatialPredicateFunction {
        public String getName() {
            return "DISJOINTLOOSE";
        }

        @Override
        protected Predicate createInternal(SpatialExpression expression1, SpatialExpression expression2) {
            return expression1.disjointLoose(expression2);
        }
    }

    public static class DisjointFunction
    extends SpatialPredicateFunction {
        public String getName() {
            return "DISJOINT";
        }

        @Override
        protected Predicate createInternal(SpatialExpression expression1, SpatialExpression expression2) {
            return expression1.disjoint(expression2);
        }
    }

    public static class IntersectsLooseFunction
    extends SpatialPredicateFunction {
        public String getName() {
            return "INTERSECTSLOOSE";
        }

        @Override
        protected Predicate createInternal(SpatialExpression expression1, SpatialExpression expression2) {
            return expression1.intersectsLoose(expression2);
        }
    }

    public static class IntersectsFunction
    extends SpatialPredicateFunction {
        public String getName() {
            return "INTERSECTS";
        }

        @Override
        protected Predicate createInternal(SpatialExpression expression1, SpatialExpression expression2) {
            return expression1.intersects(expression2);
        }
    }

    private static abstract class SpatialPredicateFunction
    implements PredicateFunction {
        private SpatialPredicateFunction() {
        }

        public Predicate create(List<Expression<?>> arguments) {
            if (arguments.size() == 2) {
                SpatialExpression expression1 = GeometryCastableType.toSpatialExpression(arguments.get(0));
                SpatialExpression expression2 = GeometryCastableType.toSpatialExpression(arguments.get(1));
                return this.createInternal(expression1, expression2);
            }
            throw new GWQLParseException("Function expects 2 arguments, got " + arguments.size());
        }

        protected abstract Predicate createInternal(SpatialExpression var1, SpatialExpression var2);
    }

    public static class BboxLooseFunction
    extends AbstractBboxFunction {
        public String getName() {
            return "BBOXLOOSE";
        }

        @Override
        protected Predicate bbox(SpatialExpression expression, double minX, double minY, double maxX, double maxY, CoordinateReferenceSystem crs) {
            if (crs == null) {
                return expression.bboxLoose(minX, minY, maxX, maxY);
            }
            return expression.bboxLoose(minX, minY, maxX, maxY, crs);
        }
    }

    public static class BboxFunction
    extends AbstractBboxFunction {
        public String getName() {
            return "BBOX";
        }

        @Override
        protected Predicate bbox(SpatialExpression expression, double minX, double minY, double maxX, double maxY, CoordinateReferenceSystem crs) {
            if (crs == null) {
                return expression.bbox(minX, minY, maxX, maxY);
            }
            return expression.bbox(minX, minY, maxX, maxY, crs);
        }
    }

    private static abstract class AbstractBboxFunction
    implements PredicateFunction {
        private AbstractBboxFunction() {
        }

        public Predicate create(List<Expression<?>> arguments) {
            if (arguments.size() < 5 && arguments.size() > 6) {
                throw new GWQLParseException("Function expects 5 or 6 arguments, got " + arguments.size());
            }
            SpatialExpression expression = GeometryCastableType.toSpatialExpression(arguments.get(0));
            double minX = this.getNumber(arguments.get(1));
            double minY = this.getNumber(arguments.get(2));
            double maxX = this.getNumber(arguments.get(3));
            double maxY = this.getNumber(arguments.get(4));
            if (arguments.size() == 6) {
                if (arguments.get(5).isLiteral() && arguments.get(5) instanceof TextExpression) {
                    String crsStr = (String)((TextExpression)arguments.get(5)).evaluateValue(null);
                    return this.bbox(expression, minX, minY, maxX, maxY, GeometryUtils.decodeCRS(crsStr));
                }
                throw new GWQLParseException("Expected a text literal for the coordinate reference system.");
            }
            return this.bbox(expression, minX, minY, maxX, maxY, null);
        }

        protected abstract Predicate bbox(SpatialExpression var1, double var2, double var4, double var6, double var8, CoordinateReferenceSystem var10);

        private double getNumber(Expression<?> expression) {
            if (expression.isLiteral() && expression instanceof NumericExpression) {
                return (Double)((NumericExpression)expression).evaluateValue(null);
            }
            throw new GWQLParseException("Expected a numeric literal for bounding box constraints.");
        }
    }
}

