/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.store.query.gwql;

import org.locationtech.geowave.core.geotime.store.query.filter.expression.spatial.FilterGeometry;
import org.locationtech.geowave.core.geotime.store.query.filter.expression.spatial.SpatialExpression;
import org.locationtech.geowave.core.geotime.store.query.filter.expression.spatial.SpatialLiteral;
import org.locationtech.geowave.core.geotime.store.query.filter.expression.spatial.TextToSpatialExpression;
import org.locationtech.geowave.core.store.query.filter.expression.Expression;
import org.locationtech.geowave.core.store.query.filter.expression.InvalidFilterException;
import org.locationtech.geowave.core.store.query.filter.expression.text.TextExpression;
import org.locationtech.geowave.core.store.query.gwql.CastableType;
import org.locationtech.geowave.core.store.query.gwql.GWQLParseException;

public class GeometryCastableType
implements CastableType<FilterGeometry> {
    public String getName() {
        return "geometry";
    }

    public SpatialExpression cast(Object objectOrExpression) {
        return GeometryCastableType.toSpatialExpression(objectOrExpression);
    }

    public static SpatialExpression toSpatialExpression(Object objectOrExpression) {
        if (objectOrExpression instanceof SpatialExpression) {
            return (SpatialExpression)objectOrExpression;
        }
        if (objectOrExpression instanceof Expression && ((Expression)objectOrExpression).isLiteral()) {
            objectOrExpression = ((Expression)objectOrExpression).evaluateValue(null);
        }
        if (objectOrExpression instanceof Expression) {
            if (objectOrExpression instanceof TextExpression) {
                return new TextToSpatialExpression((TextExpression)objectOrExpression);
            }
            throw new GWQLParseException("Unable to cast expression to geometry");
        }
        try {
            return SpatialLiteral.of(objectOrExpression);
        }
        catch (InvalidFilterException e) {
            throw new GWQLParseException("Unable to cast literal to geometry", (Throwable)e);
        }
    }
}

