/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.store.query.gwql;

import org.locationtech.geowave.core.geotime.store.query.filter.expression.temporal.TemporalExpression;
import org.locationtech.geowave.core.geotime.store.query.filter.expression.temporal.TemporalFieldValue;
import org.locationtech.geowave.core.geotime.store.query.filter.expression.temporal.TemporalLiteral;
import org.locationtech.geowave.core.store.query.filter.expression.Expression;
import org.locationtech.geowave.core.store.query.filter.expression.InvalidFilterException;
import org.locationtech.geowave.core.store.query.filter.expression.numeric.NumericFieldValue;
import org.locationtech.geowave.core.store.query.filter.expression.text.TextFieldValue;
import org.locationtech.geowave.core.store.query.gwql.CastableType;
import org.locationtech.geowave.core.store.query.gwql.GWQLParseException;
import org.threeten.extra.Interval;

public class DateCastableType
implements CastableType<Interval> {
    public String getName() {
        return "date";
    }

    public TemporalExpression cast(Object objectOrExpression) {
        return DateCastableType.toTemporalExpression(objectOrExpression);
    }

    public static TemporalExpression toTemporalExpression(Object objectOrExpression) {
        if (objectOrExpression instanceof TemporalExpression) {
            return (TemporalExpression)objectOrExpression;
        }
        if (objectOrExpression instanceof Expression && ((Expression)objectOrExpression).isLiteral()) {
            objectOrExpression = ((Expression)objectOrExpression).evaluateValue(null);
        }
        if (objectOrExpression instanceof Expression) {
            if (objectOrExpression instanceof NumericFieldValue) {
                return new TemporalFieldValue(((NumericFieldValue)objectOrExpression).getFieldName());
            }
            if (objectOrExpression instanceof TextFieldValue) {
                return new TemporalFieldValue(((TextFieldValue)objectOrExpression).getFieldName());
            }
            throw new GWQLParseException("Unable to cast expression to date");
        }
        try {
            return TemporalLiteral.of(objectOrExpression);
        }
        catch (InvalidFilterException e) {
            throw new GWQLParseException("Unable to cast literal to date", (Throwable)e);
        }
    }
}

