/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.store.query.gwql;

import org.locationtech.geowave.core.geotime.store.query.aggregate.VectorBoundingBoxAggregation;
import org.locationtech.geowave.core.store.adapter.FieldDescriptor;
import org.locationtech.geowave.core.store.api.Aggregation;
import org.locationtech.geowave.core.store.api.DataTypeAdapter;
import org.locationtech.geowave.core.store.query.aggregate.FieldNameParam;
import org.locationtech.geowave.core.store.query.gwql.function.aggregation.AggregationFunction;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;

public class BboxFunction
implements AggregationFunction<Envelope> {
    public String getName() {
        return "BBOX";
    }

    public Class<Envelope> getReturnType() {
        return Envelope.class;
    }

    public <T> Aggregation<?, Envelope, T> getAggregation(DataTypeAdapter<T> adapter, String[] functionArgs) {
        FieldNameParam columnName;
        if (functionArgs == null || functionArgs.length != 1) {
            throw new RuntimeException("BBOX takes exactly 1 parameter");
        }
        FieldNameParam fieldNameParam = columnName = functionArgs[0].equals("*") ? null : new FieldNameParam(functionArgs[0]);
        if (columnName != null) {
            FieldDescriptor descriptor = adapter.getFieldDescriptor(columnName.getFieldName());
            if (descriptor == null) {
                throw new RuntimeException("No attribute called '" + columnName.getFieldName() + "' was found in the given type.");
            }
            if (!Geometry.class.isAssignableFrom(descriptor.bindingClass())) {
                throw new RuntimeException("BBOX aggregation only works on geometry fields, given field was of type " + descriptor.bindingClass().getName() + ".");
            }
        }
        return new VectorBoundingBoxAggregation(columnName);
    }
}

