/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.store.query.filter.expression.temporal;

import java.nio.ByteBuffer;
import org.locationtech.geowave.core.geotime.store.field.IntervalSerializationProvider;
import org.locationtech.geowave.core.geotime.store.query.filter.expression.temporal.TemporalExpression;
import org.locationtech.geowave.core.geotime.util.TimeUtils;
import org.locationtech.geowave.core.store.query.filter.expression.Expression;
import org.locationtech.geowave.core.store.query.filter.expression.InvalidFilterException;
import org.locationtech.geowave.core.store.query.filter.expression.Literal;
import org.threeten.extra.Interval;

public class TemporalLiteral
extends Literal<Interval>
implements TemporalExpression {
    public TemporalLiteral() {
    }

    public TemporalLiteral(Interval literal) {
        super((Object)literal);
    }

    public static TemporalLiteral of(Object literal) {
        Interval time;
        Interval interval;
        if (literal == null) {
            return new TemporalLiteral(null);
        }
        if (literal instanceof TemporalLiteral) {
            return (TemporalLiteral)literal;
        }
        if (literal instanceof Expression && ((Expression)literal).isLiteral()) {
            literal = ((Expression)literal).evaluateValue(null);
        }
        if (literal instanceof String && (interval = TemporalExpression.stringToInterval((String)literal)) != null) {
            literal = interval;
        }
        if ((time = TimeUtils.getInterval(literal)) != null) {
            return new TemporalLiteral(time);
        }
        throw new InvalidFilterException("Unable to resolve temporal literal.");
    }

    public String toString() {
        if (((Interval)this.literal).getStart().equals(((Interval)this.literal).getEnd())) {
            return ((Interval)this.literal).getStart().toString();
        }
        return ((Interval)this.literal).getStart().toString() + "/" + ((Interval)this.literal).getEnd().toString();
    }

    public byte[] toBinary() {
        if (this.literal == null) {
            return new byte[]{0};
        }
        byte[] intervalBytes = new IntervalSerializationProvider.IntervalWriter().writeField((Interval)this.literal);
        ByteBuffer buffer = ByteBuffer.allocate(1 + intervalBytes.length);
        buffer.put((byte)1);
        buffer.put(intervalBytes);
        return buffer.array();
    }

    public void fromBinary(byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        byte nullByte = buffer.get();
        if (nullByte == 0) {
            this.literal = null;
            return;
        }
        byte[] intervalBytes = new byte[buffer.remaining()];
        buffer.get(intervalBytes);
        this.literal = new IntervalSerializationProvider.IntervalReader().readField(intervalBytes);
    }
}

