/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.store.query.filter.expression.temporal;

import org.locationtech.geowave.core.geotime.store.query.filter.expression.temporal.TemporalExpression;
import org.locationtech.geowave.core.geotime.util.TimeUtils;
import org.locationtech.geowave.core.store.api.DataTypeAdapter;
import org.locationtech.geowave.core.store.query.filter.expression.FieldValue;
import org.threeten.extra.Interval;

public class TemporalFieldValue
extends FieldValue<Interval>
implements TemporalExpression {
    public TemporalFieldValue() {
    }

    public TemporalFieldValue(String fieldName) {
        super(fieldName);
    }

    public <T> Interval evaluateValue(DataTypeAdapter<T> adapter, T entry) {
        Object value = super.evaluateValue(adapter, entry);
        if (value == null) {
            return null;
        }
        return TimeUtils.getInterval(value);
    }

    public static TemporalFieldValue of(String fieldName) {
        return new TemporalFieldValue(fieldName);
    }

    protected Interval evaluateValueInternal(Object value) {
        if (value instanceof String) {
            Interval interval = TemporalExpression.stringToInterval((String)value);
            if (interval == null) {
                throw new RuntimeException("'" + (String)value + "' is not in a supported date format.");
            }
            return interval;
        }
        return TimeUtils.getInterval(value);
    }
}

