/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.store.query.filter.expression.temporal;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.locationtech.geowave.core.geotime.store.query.filter.expression.temporal.After;
import org.locationtech.geowave.core.geotime.store.query.filter.expression.temporal.Before;
import org.locationtech.geowave.core.geotime.store.query.filter.expression.temporal.BeforeOrDuring;
import org.locationtech.geowave.core.geotime.store.query.filter.expression.temporal.During;
import org.locationtech.geowave.core.geotime.store.query.filter.expression.temporal.DuringOrAfter;
import org.locationtech.geowave.core.geotime.store.query.filter.expression.temporal.TemporalBetween;
import org.locationtech.geowave.core.geotime.store.query.filter.expression.temporal.TemporalEqualTo;
import org.locationtech.geowave.core.geotime.store.query.filter.expression.temporal.TemporalFieldValue;
import org.locationtech.geowave.core.geotime.store.query.filter.expression.temporal.TemporalLiteral;
import org.locationtech.geowave.core.geotime.store.query.filter.expression.temporal.TemporalNotEqualTo;
import org.locationtech.geowave.core.geotime.store.query.filter.expression.temporal.TimeOverlaps;
import org.locationtech.geowave.core.geotime.util.TimeUtils;
import org.locationtech.geowave.core.store.query.filter.expression.ComparableExpression;
import org.locationtech.geowave.core.store.query.filter.expression.FieldValue;
import org.locationtech.geowave.core.store.query.filter.expression.Predicate;
import org.locationtech.geowave.core.store.query.filter.expression.numeric.NumericFieldValue;
import org.locationtech.geowave.core.store.query.filter.expression.text.TextFieldValue;
import org.threeten.extra.Interval;

public interface TemporalExpression
extends ComparableExpression<Interval> {
    public static final ThreadLocal<SimpleDateFormat[]> SUPPORTED_DATE_FORMATS = new ThreadLocal<SimpleDateFormat[]>(){

        @Override
        protected SimpleDateFormat[] initialValue() {
            return new SimpleDateFormat[]{new SimpleDateFormat("yyyy-MM-dd HH:mm:ssZ"), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'"), new SimpleDateFormat("yyyy-MM-dd")};
        }
    };

    default public Predicate isEqualTo(Object other) {
        return new TemporalEqualTo(this, TemporalExpression.toTemporalExpression(other));
    }

    default public Predicate isNotEqualTo(Object other) {
        return new TemporalNotEqualTo(this, TemporalExpression.toTemporalExpression(other));
    }

    default public Predicate isLessThan(Object other) {
        return this.isBefore(TemporalExpression.toTemporalExpression(other));
    }

    default public Predicate isLessThanOrEqualTo(Object other) {
        return this.isBeforeOrDuring(TemporalExpression.toTemporalExpression(other));
    }

    default public Predicate isGreaterThan(Object other) {
        return this.isAfter(TemporalExpression.toTemporalExpression(other));
    }

    default public Predicate isGreaterThanOrEqualTo(Object other) {
        return this.isDuringOrAfter(TemporalExpression.toTemporalExpression(other));
    }

    default public Predicate isBetween(Object lowerBound, Object upperBound) {
        return new TemporalBetween(this, TemporalExpression.toTemporalExpression(lowerBound), TemporalExpression.toTemporalExpression(upperBound));
    }

    default public Predicate isAfter(Object other) {
        return new After(this, TemporalExpression.toTemporalExpression(other));
    }

    default public Predicate isDuringOrAfter(Object other) {
        return new DuringOrAfter(this, TemporalExpression.toTemporalExpression(other));
    }

    default public Predicate isBefore(Object other) {
        return new Before(this, TemporalExpression.toTemporalExpression(other));
    }

    default public Predicate isBeforeOrDuring(Object other) {
        return new BeforeOrDuring(this, TemporalExpression.toTemporalExpression(other));
    }

    default public Predicate isDuring(Object other) {
        return new During(this, TemporalExpression.toTemporalExpression(other));
    }

    default public Predicate contains(Object other) {
        return new During(TemporalExpression.toTemporalExpression(other), this);
    }

    default public Predicate overlaps(Object other) {
        return new TimeOverlaps(this, TemporalExpression.toTemporalExpression(other));
    }

    public static TemporalExpression toTemporalExpression(Object obj) {
        if (obj instanceof TemporalExpression) {
            return (TemporalExpression)obj;
        }
        if (obj instanceof NumericFieldValue || obj instanceof TextFieldValue) {
            return TemporalFieldValue.of(((FieldValue)obj).getFieldName());
        }
        return TemporalLiteral.of(obj);
    }

    public static Date stringToDate(String dateStr) {
        for (SimpleDateFormat format : SUPPORTED_DATE_FORMATS.get()) {
            try {
                return format.parse(dateStr);
            }
            catch (ParseException parseException) {
            }
        }
        return null;
    }

    public static Interval stringToInterval(String intervalStr) {
        if (intervalStr.contains("/")) {
            Date date2;
            Date date1;
            String[] split = intervalStr.split("/");
            if (split.length == 2 && (date1 = TemporalExpression.stringToDate(split[0])) != null && (date2 = TemporalExpression.stringToDate(split[1])) != null) {
                return TimeUtils.getInterval(date1, date2);
            }
            return null;
        }
        return TimeUtils.getInterval(TemporalExpression.stringToDate(intervalStr));
    }
}

