/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.store.query.filter.expression.temporal;

import org.locationtech.geowave.core.geotime.store.query.filter.expression.temporal.BinaryTemporalPredicate;
import org.locationtech.geowave.core.geotime.store.query.filter.expression.temporal.TemporalExpression;
import org.locationtech.geowave.core.geotime.util.TimeUtils;
import org.locationtech.geowave.core.store.query.filter.expression.numeric.NumericFieldConstraints;
import org.threeten.extra.Interval;

public class TemporalEqualTo
extends BinaryTemporalPredicate {
    public TemporalEqualTo() {
    }

    public TemporalEqualTo(TemporalExpression expression1, TemporalExpression expression2) {
        super(expression1, expression2);
    }

    @Override
    public boolean evaluateInternal(Interval value1, Interval value2) {
        if (value1 == null) {
            return value2 == null;
        }
        if (value2 == null) {
            return false;
        }
        return value1.getStart().compareTo(value2.getStart()) == 0 && TimeUtils.getIntervalEnd(value1).compareTo(TimeUtils.getIntervalEnd(value2)) == 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(((TemporalExpression)this.expression1).toString());
        sb.append(" = ");
        sb.append(((TemporalExpression)this.expression2).toString());
        return sb.toString();
    }

    @Override
    public NumericFieldConstraints getConstraints(Interval literal, Double minValue, Double maxValue, boolean reversed, boolean exact) {
        if (exact && literal.isEmpty()) {
            return NumericFieldConstraints.of((Double)Double.valueOf(literal.getStart().toEpochMilli()), (Double)Double.valueOf(literal.getStart().toEpochMilli()), (boolean)true, (boolean)true, (boolean)exact);
        }
        return NumericFieldConstraints.of((Double)Double.valueOf(literal.getStart().toEpochMilli()), (Double)Double.valueOf(TimeUtils.getIntervalEnd(literal).toEpochMilli()), (boolean)true, (boolean)false, (boolean)false);
    }
}

