/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.store.query.filter.expression.temporal;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.locationtech.geowave.core.geotime.store.query.filter.expression.temporal.TemporalExpression;
import org.locationtech.geowave.core.geotime.store.query.filter.expression.temporal.TemporalLiteral;
import org.locationtech.geowave.core.geotime.util.TimeUtils;
import org.locationtech.geowave.core.index.persist.Persistable;
import org.locationtech.geowave.core.index.persist.PersistenceUtils;
import org.locationtech.geowave.core.index.simple.SimpleNumericIndexStrategy;
import org.locationtech.geowave.core.store.AdapterToIndexMapping;
import org.locationtech.geowave.core.store.api.DataTypeAdapter;
import org.locationtech.geowave.core.store.api.Index;
import org.locationtech.geowave.core.store.query.filter.expression.FieldValue;
import org.locationtech.geowave.core.store.query.filter.expression.Filter;
import org.locationtech.geowave.core.store.query.filter.expression.FilterConstraints;
import org.locationtech.geowave.core.store.query.filter.expression.IndexFieldConstraints;
import org.locationtech.geowave.core.store.query.filter.expression.Predicate;
import org.locationtech.geowave.core.store.query.filter.expression.numeric.NumericFieldConstraints;
import org.locationtech.geowave.core.store.statistics.DataStatisticsStore;
import org.threeten.extra.Interval;

public class TemporalBetween
implements Predicate {
    private TemporalExpression valueExpr;
    private TemporalExpression lowerBoundExpr;
    private TemporalExpression upperBoundExpr;

    public TemporalBetween() {
    }

    public TemporalBetween(TemporalExpression value, TemporalExpression lowerBound, TemporalExpression upperBound) {
        this.valueExpr = value;
        this.lowerBoundExpr = lowerBound;
        this.upperBoundExpr = upperBound;
    }

    public TemporalExpression getValue() {
        return this.valueExpr;
    }

    public TemporalExpression getLowerBound() {
        return this.lowerBoundExpr;
    }

    public TemporalExpression getUpperBound() {
        return this.upperBoundExpr;
    }

    public void prepare(DataTypeAdapter<?> adapter, AdapterToIndexMapping indexMapping, Index index) {
        if (this.valueExpr.isLiteral() && !(this.valueExpr instanceof TemporalLiteral)) {
            this.valueExpr = TemporalLiteral.of(this.valueExpr.evaluateValue(null));
        }
        if (this.lowerBoundExpr.isLiteral() && !(this.lowerBoundExpr instanceof TemporalLiteral)) {
            this.lowerBoundExpr = TemporalLiteral.of(this.lowerBoundExpr.evaluateValue(null));
        }
        if (this.upperBoundExpr.isLiteral() && !(this.upperBoundExpr instanceof TemporalLiteral)) {
            this.upperBoundExpr = TemporalLiteral.of(this.upperBoundExpr.evaluateValue(null));
        }
    }

    public void addReferencedFields(Set<String> fields) {
        if (this.valueExpr instanceof FieldValue) {
            fields.add(((FieldValue)this.valueExpr).getFieldName());
        }
        if (this.lowerBoundExpr instanceof FieldValue) {
            fields.add(((FieldValue)this.lowerBoundExpr).getFieldName());
        }
        if (this.upperBoundExpr instanceof FieldValue) {
            fields.add(((FieldValue)this.upperBoundExpr).getFieldName());
        }
    }

    public boolean evaluate(Map<String, Object> fieldValues) {
        Interval value = TimeUtils.getInterval(this.valueExpr.evaluateValue(fieldValues));
        Interval lowerBound = TimeUtils.getInterval(this.lowerBoundExpr.evaluateValue(fieldValues));
        Interval upperBound = TimeUtils.getInterval(this.upperBoundExpr.evaluateValue(fieldValues));
        return this.evaluate(value, lowerBound, upperBound);
    }

    public <T> boolean evaluate(DataTypeAdapter<T> adapter, T entry) {
        Interval value = TimeUtils.getInterval(this.valueExpr.evaluateValue(adapter, entry));
        Interval lowerBound = TimeUtils.getInterval(this.lowerBoundExpr.evaluateValue(adapter, entry));
        Interval upperBound = TimeUtils.getInterval(this.upperBoundExpr.evaluateValue(adapter, entry));
        return this.evaluate(value, lowerBound, upperBound);
    }

    private boolean evaluate(Interval value, Interval lowerBound, Interval upperBound) {
        if (value == null || lowerBound == null || upperBound == null) {
            return false;
        }
        return value.getStart().compareTo(lowerBound.getStart()) >= 0 && TimeUtils.getIntervalEnd(value).compareTo(TimeUtils.getIntervalEnd(upperBound)) <= 0;
    }

    public Filter removePredicatesForFields(Set<String> fields) {
        HashSet referencedFields = Sets.newHashSet();
        this.valueExpr.addReferencedFields(referencedFields);
        this.lowerBoundExpr.addReferencedFields(referencedFields);
        this.upperBoundExpr.addReferencedFields(referencedFields);
        if (fields.containsAll(referencedFields)) {
            return null;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.valueExpr.toString());
        sb.append(" BETWEEN ");
        sb.append(this.lowerBoundExpr.toString());
        sb.append(" AND ");
        sb.append(this.upperBoundExpr.toString());
        return sb.toString();
    }

    public byte[] toBinary() {
        return PersistenceUtils.toBinary((Persistable[])new Persistable[]{this.valueExpr, this.lowerBoundExpr, this.upperBoundExpr});
    }

    public void fromBinary(byte[] bytes) {
        List expressions = PersistenceUtils.fromBinaryAsList((byte[])bytes);
        this.valueExpr = (TemporalExpression)expressions.get(0);
        this.lowerBoundExpr = (TemporalExpression)expressions.get(1);
        this.upperBoundExpr = (TemporalExpression)expressions.get(2);
    }

    public Set<String> getConstrainableFields() {
        if (this.valueExpr instanceof FieldValue && this.lowerBoundExpr.isLiteral() && this.upperBoundExpr.isLiteral()) {
            return Sets.newHashSet((Object[])new String[]{((FieldValue)this.valueExpr).getFieldName()});
        }
        return Sets.newHashSet();
    }

    public <V extends Comparable<V>> FilterConstraints<V> getConstraints(Class<V> constraintClass, DataStatisticsStore statsStore, DataTypeAdapter<?> adapter, AdapterToIndexMapping indexMapping, Index index, Set<String> indexedFields) {
        if (this.valueExpr instanceof FieldValue && indexedFields.contains(((FieldValue)this.valueExpr).getFieldName()) && this.lowerBoundExpr.isLiteral() && this.upperBoundExpr.isLiteral() && constraintClass.isAssignableFrom(Double.class)) {
            Interval lowerBound = (Interval)this.lowerBoundExpr.evaluateValue(null, null);
            Interval upperBound = (Interval)this.upperBoundExpr.evaluateValue(null, null);
            if (lowerBound != null && upperBound != null) {
                return FilterConstraints.of(adapter, (AdapterToIndexMapping)indexMapping, (Index)index, (String)((FieldValue)this.valueExpr).getFieldName(), (IndexFieldConstraints)NumericFieldConstraints.of((Double)Double.valueOf(lowerBound.getStart().toEpochMilli()), (Double)Double.valueOf(TimeUtils.getIntervalEnd(upperBound).toEpochMilli()), (boolean)true, (boolean)false, (boolean)(index.getIndexStrategy() instanceof SimpleNumericIndexStrategy)));
            }
        }
        return FilterConstraints.empty();
    }
}

