/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.store.query.filter.expression.temporal;

import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import org.locationtech.geowave.core.geotime.store.query.filter.expression.temporal.TemporalExpression;
import org.locationtech.geowave.core.geotime.store.query.filter.expression.temporal.TemporalLiteral;
import org.locationtech.geowave.core.geotime.store.statistics.TimeRangeStatistic;
import org.locationtech.geowave.core.geotime.util.TimeUtils;
import org.locationtech.geowave.core.index.simple.SimpleNumericIndexStrategy;
import org.locationtech.geowave.core.store.AdapterToIndexMapping;
import org.locationtech.geowave.core.store.api.DataTypeAdapter;
import org.locationtech.geowave.core.store.api.Index;
import org.locationtech.geowave.core.store.api.IndexFieldMapper;
import org.locationtech.geowave.core.store.query.filter.expression.BinaryPredicate;
import org.locationtech.geowave.core.store.query.filter.expression.Expression;
import org.locationtech.geowave.core.store.query.filter.expression.FieldValue;
import org.locationtech.geowave.core.store.query.filter.expression.FilterConstraints;
import org.locationtech.geowave.core.store.query.filter.expression.IndexFieldConstraints;
import org.locationtech.geowave.core.store.query.filter.expression.numeric.NumericFieldConstraints;
import org.locationtech.geowave.core.store.statistics.DataStatisticsStore;
import org.locationtech.geowave.core.store.statistics.InternalStatisticsHelper;
import org.threeten.extra.Interval;

public abstract class BinaryTemporalPredicate
extends BinaryPredicate<TemporalExpression> {
    public BinaryTemporalPredicate() {
    }

    public BinaryTemporalPredicate(TemporalExpression expression1, TemporalExpression expression2) {
        super((Expression)expression1, (Expression)expression2);
    }

    public void prepare(DataTypeAdapter<?> adapter, AdapterToIndexMapping indexMapping, Index index) {
        if (((TemporalExpression)this.expression1).isLiteral() && !(this.expression1 instanceof TemporalLiteral)) {
            this.expression1 = TemporalLiteral.of(((TemporalExpression)this.expression1).evaluateValue(null));
        }
        if (((TemporalExpression)this.expression2).isLiteral() && !(this.expression2 instanceof TemporalLiteral)) {
            this.expression2 = TemporalLiteral.of(((TemporalExpression)this.expression2).evaluateValue(null));
        }
    }

    public boolean evaluate(Map<String, Object> fieldValues) {
        Interval value1 = TimeUtils.getInterval(((TemporalExpression)this.expression1).evaluateValue(fieldValues));
        Interval value2 = TimeUtils.getInterval(((TemporalExpression)this.expression2).evaluateValue(fieldValues));
        return this.evaluateInternal(value1, value2);
    }

    public <T> boolean evaluate(DataTypeAdapter<T> adapter, T entry) {
        Interval value1 = TimeUtils.getInterval(((TemporalExpression)this.expression1).evaluateValue(adapter, entry));
        Interval value2 = TimeUtils.getInterval(((TemporalExpression)this.expression2).evaluateValue(adapter, entry));
        return this.evaluateInternal(value1, value2);
    }

    protected abstract boolean evaluateInternal(Interval var1, Interval var2);

    public Set<String> getConstrainableFields() {
        if (this.expression1 instanceof FieldValue && ((TemporalExpression)this.expression2).isLiteral()) {
            return Sets.newHashSet((Object[])new String[]{((FieldValue)this.expression1).getFieldName()});
        }
        if (this.expression2 instanceof FieldValue && ((TemporalExpression)this.expression1).isLiteral()) {
            return Sets.newHashSet((Object[])new String[]{((FieldValue)this.expression2).getFieldName()});
        }
        return Sets.newHashSet();
    }

    private boolean isPartOfRange(String fieldName, AdapterToIndexMapping indexMapping) {
        for (IndexFieldMapper mapper : indexMapping.getIndexFieldMappers()) {
            String[] adapterFields = mapper.getAdapterFields();
            for (int i = 0; i < adapterFields.length; ++i) {
                if (!adapterFields[i].equals(fieldName)) continue;
                return adapterFields.length > 1;
            }
        }
        return false;
    }

    public <V extends Comparable<V>> FilterConstraints<V> getConstraints(Class<V> constraintClass, DataStatisticsStore statsStore, DataTypeAdapter<?> adapter, AdapterToIndexMapping indexMapping, Index index, Set<String> indexedFields) {
        if (this.expression1 instanceof FieldValue && indexedFields.contains(((FieldValue)this.expression1).getFieldName()) && ((TemporalExpression)this.expression2).isLiteral() && constraintClass.isAssignableFrom(Double.class)) {
            Double maxValue;
            Double minValue;
            if (index.getIndexStrategy() instanceof SimpleNumericIndexStrategy) {
                minValue = null;
                maxValue = null;
            } else {
                TimeRangeStatistic.TimeRangeValue timeRange = (TimeRangeStatistic.TimeRangeValue)InternalStatisticsHelper.getFieldStatistic((DataStatisticsStore)statsStore, TimeRangeStatistic.STATS_TYPE, (String)adapter.getTypeName(), (String)((FieldValue)this.expression1).getFieldName(), (String[])new String[0]);
                if (timeRange != null) {
                    minValue = timeRange.getMin();
                    maxValue = timeRange.getMax();
                } else {
                    return FilterConstraints.empty();
                }
            }
            String fieldName = ((FieldValue)this.expression1).getFieldName();
            boolean partOfRange = this.isPartOfRange(fieldName, indexMapping);
            Interval literal = (Interval)((TemporalExpression)this.expression2).evaluateValue(null, null);
            if (literal != null) {
                return FilterConstraints.of(adapter, (AdapterToIndexMapping)indexMapping, (Index)index, (String)fieldName, (IndexFieldConstraints)this.getConstraints(literal, minValue, maxValue, false, !partOfRange && index.getIndexStrategy() instanceof SimpleNumericIndexStrategy));
            }
        } else if (this.expression2 instanceof FieldValue && indexedFields.contains(((FieldValue)this.expression2).getFieldName()) && ((TemporalExpression)this.expression1).isLiteral() && constraintClass.isAssignableFrom(Double.class)) {
            Double maxValue;
            Double minValue;
            if (index.getIndexStrategy() instanceof SimpleNumericIndexStrategy) {
                minValue = null;
                maxValue = null;
            } else {
                TimeRangeStatistic.TimeRangeValue timeRange = (TimeRangeStatistic.TimeRangeValue)InternalStatisticsHelper.getFieldStatistic((DataStatisticsStore)statsStore, TimeRangeStatistic.STATS_TYPE, (String)adapter.getTypeName(), (String)((FieldValue)this.expression2).getFieldName(), (String[])new String[0]);
                if (timeRange != null) {
                    minValue = timeRange.getMin();
                    maxValue = timeRange.getMax();
                } else {
                    return FilterConstraints.empty();
                }
            }
            String fieldName = ((FieldValue)this.expression2).getFieldName();
            boolean partOfRange = this.isPartOfRange(fieldName, indexMapping);
            Interval literal = (Interval)((TemporalExpression)this.expression1).evaluateValue(null, null);
            if (literal != null) {
                return FilterConstraints.of(adapter, (AdapterToIndexMapping)indexMapping, (Index)index, (String)fieldName, (IndexFieldConstraints)this.getConstraints(literal, minValue, maxValue, true, !partOfRange && index.getIndexStrategy() instanceof SimpleNumericIndexStrategy));
            }
        }
        return FilterConstraints.empty();
    }

    protected abstract NumericFieldConstraints getConstraints(Interval var1, Double var2, Double var3, boolean var4, boolean var5);
}

