/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.store.query.filter.expression.spatial;

import org.locationtech.geowave.core.geotime.store.query.filter.expression.spatial.FilterGeometry;
import org.locationtech.geowave.core.geotime.store.query.filter.expression.spatial.PreparedFilterGeometry;
import org.locationtech.geowave.core.geotime.util.GeometryUtils;
import org.locationtech.jts.geom.Geometry;

public class UnpreparedFilterGeometry
implements FilterGeometry {
    private Geometry geometry;

    public UnpreparedFilterGeometry() {
    }

    public UnpreparedFilterGeometry(Geometry geometry) {
        this.geometry = geometry;
    }

    @Override
    public Geometry getGeometry() {
        return this.geometry;
    }

    @Override
    public boolean intersects(FilterGeometry other) {
        if (other instanceof PreparedFilterGeometry) {
            return other.intersects(this);
        }
        return this.geometry.intersects(other.getGeometry());
    }

    @Override
    public boolean disjoint(FilterGeometry other) {
        if (other instanceof PreparedFilterGeometry) {
            return other.disjoint(this);
        }
        return this.geometry.disjoint(other.getGeometry());
    }

    @Override
    public boolean crosses(FilterGeometry other) {
        if (other instanceof PreparedFilterGeometry) {
            return other.crosses(this);
        }
        return this.geometry.crosses(other.getGeometry());
    }

    @Override
    public boolean overlaps(FilterGeometry other) {
        if (other instanceof PreparedFilterGeometry) {
            return other.overlaps(this);
        }
        return this.geometry.overlaps(other.getGeometry());
    }

    @Override
    public boolean touches(FilterGeometry other) {
        if (other instanceof PreparedFilterGeometry) {
            return other.touches(this);
        }
        return this.geometry.touches(other.getGeometry());
    }

    @Override
    public boolean within(FilterGeometry other) {
        if (other instanceof PreparedFilterGeometry) {
            return other.contains(this);
        }
        return this.geometry.within(other.getGeometry());
    }

    @Override
    public boolean contains(FilterGeometry other) {
        if (other instanceof PreparedFilterGeometry) {
            return other.within(this);
        }
        return this.geometry.contains(other.getGeometry());
    }

    @Override
    public boolean isEqualTo(FilterGeometry other) {
        return this.geometry.equalsTopo(other.getGeometry());
    }

    public byte[] toBinary() {
        return GeometryUtils.geometryToBinary(this.geometry, null);
    }

    public void fromBinary(byte[] bytes) {
        this.geometry = GeometryUtils.geometryFromBinary(bytes, null);
    }
}

