/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.store.query.filter.expression.spatial;

import java.util.Map;
import java.util.Set;
import org.locationtech.geowave.core.geotime.store.query.filter.expression.spatial.FilterGeometry;
import org.locationtech.geowave.core.geotime.store.query.filter.expression.spatial.SpatialExpression;
import org.locationtech.geowave.core.geotime.store.query.filter.expression.spatial.UnpreparedFilterGeometry;
import org.locationtech.geowave.core.geotime.util.GeometryUtils;
import org.locationtech.geowave.core.index.persist.Persistable;
import org.locationtech.geowave.core.index.persist.PersistenceUtils;
import org.locationtech.geowave.core.store.api.DataTypeAdapter;
import org.locationtech.geowave.core.store.query.filter.expression.text.TextExpression;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class TextToSpatialExpression
implements SpatialExpression {
    private TextExpression baseExpression;
    private WKTReader wktReader = new WKTReader();

    public TextToSpatialExpression() {
    }

    public TextToSpatialExpression(TextExpression baseExpression) {
        this.baseExpression = baseExpression;
    }

    public FilterGeometry evaluateValue(Map<String, Object> fieldValues) {
        return this.evaluateInternal((String)this.baseExpression.evaluateValue(fieldValues));
    }

    public <T> FilterGeometry evaluateValue(DataTypeAdapter<T> adapter, T entry) {
        return this.evaluateInternal((String)this.baseExpression.evaluateValue(adapter, entry));
    }

    private <T> FilterGeometry evaluateInternal(String value) {
        if (value != null) {
            try {
                return new UnpreparedFilterGeometry(this.wktReader.read(value));
            }
            catch (ParseException e) {
                throw new RuntimeException("Unable to cast text expression to geometry: " + value);
            }
        }
        return null;
    }

    public boolean isLiteral() {
        return this.baseExpression.isLiteral();
    }

    public void addReferencedFields(Set<String> fields) {
        this.baseExpression.addReferencedFields(fields);
    }

    public byte[] toBinary() {
        return PersistenceUtils.toBinary((Persistable)this.baseExpression);
    }

    public void fromBinary(byte[] bytes) {
        this.baseExpression = (TextExpression)PersistenceUtils.fromBinary((byte[])bytes);
    }

    @Override
    public CoordinateReferenceSystem getCRS(DataTypeAdapter<?> adapter) {
        return GeometryUtils.getDefaultCRS();
    }
}

