/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.store.query.filter.expression.spatial;

import java.nio.ByteBuffer;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.locationtech.geowave.core.geotime.store.query.filter.expression.spatial.FilterGeometry;
import org.locationtech.geowave.core.geotime.store.query.filter.expression.spatial.PreparedFilterGeometry;
import org.locationtech.geowave.core.geotime.store.query.filter.expression.spatial.SpatialExpression;
import org.locationtech.geowave.core.geotime.store.query.filter.expression.spatial.UnpreparedFilterGeometry;
import org.locationtech.geowave.core.geotime.util.GeometryUtils;
import org.locationtech.geowave.core.index.StringUtils;
import org.locationtech.geowave.core.index.VarintUtils;
import org.locationtech.geowave.core.index.persist.Persistable;
import org.locationtech.geowave.core.index.persist.PersistenceUtils;
import org.locationtech.geowave.core.store.api.DataTypeAdapter;
import org.locationtech.geowave.core.store.query.filter.expression.Expression;
import org.locationtech.geowave.core.store.query.filter.expression.InvalidFilterException;
import org.locationtech.geowave.core.store.query.filter.expression.Literal;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class SpatialLiteral
extends Literal<FilterGeometry>
implements SpatialExpression {
    private CoordinateReferenceSystem crs;

    public SpatialLiteral() {
    }

    public SpatialLiteral(FilterGeometry literal) {
        super((Object)literal);
        this.crs = GeometryUtils.getDefaultCRS();
    }

    public SpatialLiteral(FilterGeometry literal, CoordinateReferenceSystem crs) {
        super((Object)literal);
        this.crs = crs;
    }

    @Override
    public CoordinateReferenceSystem getCRS(DataTypeAdapter<?> adapter) {
        return this.crs;
    }

    public void prepare(CoordinateReferenceSystem targetCRS) {
        if (this.literal != null && this.literal instanceof UnpreparedFilterGeometry) {
            try {
                Geometry transformed = GeometryUtils.crsTransform(((FilterGeometry)this.literal).getGeometry(), CRS.findMathTransform((CoordinateReferenceSystem)this.crs, (CoordinateReferenceSystem)targetCRS));
                this.literal = new PreparedFilterGeometry(GeometryUtils.PREPARED_GEOMETRY_FACTORY.create(transformed));
                this.crs = targetCRS;
            }
            catch (FactoryException e) {
                throw new RuntimeException("Unable to transform spatial literal", e);
            }
        }
    }

    private static FilterGeometry toGeometry(Object literal) {
        Geometry geometry;
        if (literal == null) {
            return null;
        }
        if (literal instanceof Geometry) {
            geometry = (Geometry)literal;
        } else if (literal instanceof Envelope) {
            geometry = GeometryUtils.GEOMETRY_FACTORY.toGeometry((Envelope)literal);
        } else if (literal instanceof String) {
            try {
                geometry = new WKTReader().read((String)literal);
            }
            catch (ParseException e) {
                throw new InvalidFilterException("Unable to parse well-known text geometry", (Throwable)e);
            }
        } else {
            throw new InvalidFilterException("Invalid spatial literal: " + literal.getClass().getName());
        }
        return new UnpreparedFilterGeometry(geometry);
    }

    public static SpatialLiteral of(Object literal) {
        CoordinateReferenceSystem crs = literal instanceof ReferencedEnvelope ? ((ReferencedEnvelope)literal).getCoordinateReferenceSystem() : GeometryUtils.getDefaultCRS();
        return SpatialLiteral.of(literal, crs);
    }

    public static SpatialLiteral of(Object literal, CoordinateReferenceSystem crs) {
        if (literal == null) {
            return new SpatialLiteral(null);
        }
        if (literal instanceof SpatialLiteral) {
            return (SpatialLiteral)literal;
        }
        if (literal instanceof Expression && ((Expression)literal).isLiteral()) {
            literal = ((Expression)literal).evaluateValue(null);
        }
        return new SpatialLiteral(SpatialLiteral.toGeometry(literal), crs);
    }

    public String toString() {
        return ((FilterGeometry)this.literal).getGeometry().toText();
    }

    public byte[] toBinary() {
        if (this.literal == null) {
            return new byte[]{0};
        }
        byte[] crsBytes = StringUtils.stringToBinary((String)this.crs.toWKT());
        byte[] geometryBytes = PersistenceUtils.toBinary((Persistable)((Persistable)this.literal));
        ByteBuffer buffer = ByteBuffer.allocate(1 + VarintUtils.unsignedIntByteLength((int)crsBytes.length) + VarintUtils.unsignedIntByteLength((int)geometryBytes.length) + crsBytes.length + geometryBytes.length);
        buffer.put((byte)1);
        VarintUtils.writeUnsignedInt((int)crsBytes.length, (ByteBuffer)buffer);
        buffer.put(crsBytes);
        VarintUtils.writeUnsignedInt((int)geometryBytes.length, (ByteBuffer)buffer);
        buffer.put(geometryBytes);
        return buffer.array();
    }

    public void fromBinary(byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        byte nullByte = buffer.get();
        if (nullByte == 0) {
            this.literal = null;
            return;
        }
        byte[] crsBytes = new byte[VarintUtils.readUnsignedInt((ByteBuffer)buffer)];
        buffer.get(crsBytes);
        byte[] geometryBytes = new byte[VarintUtils.readUnsignedInt((ByteBuffer)buffer)];
        buffer.get(geometryBytes);
        try {
            this.crs = CRS.parseWKT((String)StringUtils.stringFromBinary((byte[])crsBytes));
        }
        catch (FactoryException e) {
            throw new RuntimeException("Unable to parse CRS from spatial literal.");
        }
        this.literal = (FilterGeometry)PersistenceUtils.fromBinary((byte[])geometryBytes);
    }
}

