/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.store.query.filter.expression.spatial;

import org.locationtech.geowave.core.geotime.adapter.SpatialFieldDescriptor;
import org.locationtech.geowave.core.geotime.store.query.filter.expression.spatial.FilterGeometry;
import org.locationtech.geowave.core.geotime.store.query.filter.expression.spatial.SpatialExpression;
import org.locationtech.geowave.core.geotime.store.query.filter.expression.spatial.UnpreparedFilterGeometry;
import org.locationtech.geowave.core.geotime.util.GeometryUtils;
import org.locationtech.geowave.core.store.adapter.FieldDescriptor;
import org.locationtech.geowave.core.store.api.DataTypeAdapter;
import org.locationtech.geowave.core.store.query.filter.expression.FieldValue;
import org.locationtech.jts.geom.Geometry;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class SpatialFieldValue
extends FieldValue<FilterGeometry>
implements SpatialExpression {
    public SpatialFieldValue() {
    }

    public SpatialFieldValue(String fieldName) {
        super(fieldName);
    }

    @Override
    public CoordinateReferenceSystem getCRS(DataTypeAdapter<?> adapter) {
        FieldDescriptor fieldDescriptor = adapter.getFieldDescriptor(this.fieldName);
        if (fieldDescriptor != null && fieldDescriptor instanceof SpatialFieldDescriptor) {
            return ((SpatialFieldDescriptor)fieldDescriptor).crs();
        }
        return GeometryUtils.getDefaultCRS();
    }

    public static SpatialFieldValue of(String fieldName) {
        return new SpatialFieldValue(fieldName);
    }

    protected FilterGeometry evaluateValueInternal(Object value) {
        return new UnpreparedFilterGeometry((Geometry)value);
    }
}

