/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.store.query.filter.expression.spatial;

import org.locationtech.geowave.core.geotime.store.query.filter.expression.spatial.BBox;
import org.locationtech.geowave.core.geotime.store.query.filter.expression.spatial.Crosses;
import org.locationtech.geowave.core.geotime.store.query.filter.expression.spatial.Disjoint;
import org.locationtech.geowave.core.geotime.store.query.filter.expression.spatial.FilterGeometry;
import org.locationtech.geowave.core.geotime.store.query.filter.expression.spatial.Intersects;
import org.locationtech.geowave.core.geotime.store.query.filter.expression.spatial.Overlaps;
import org.locationtech.geowave.core.geotime.store.query.filter.expression.spatial.SpatialContains;
import org.locationtech.geowave.core.geotime.store.query.filter.expression.spatial.SpatialEqualTo;
import org.locationtech.geowave.core.geotime.store.query.filter.expression.spatial.SpatialLiteral;
import org.locationtech.geowave.core.geotime.store.query.filter.expression.spatial.SpatialNotEqualTo;
import org.locationtech.geowave.core.geotime.store.query.filter.expression.spatial.Touches;
import org.locationtech.geowave.core.geotime.store.query.filter.expression.spatial.Within;
import org.locationtech.geowave.core.store.api.DataTypeAdapter;
import org.locationtech.geowave.core.store.query.filter.expression.Expression;
import org.locationtech.geowave.core.store.query.filter.expression.Predicate;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public interface SpatialExpression
extends Expression<FilterGeometry> {
    public CoordinateReferenceSystem getCRS(DataTypeAdapter<?> var1);

    default public Predicate bbox(double minX, double minY, double maxX, double maxY) {
        return new BBox(this, minX, minY, maxX, maxY, false);
    }

    default public Predicate bbox(double minX, double minY, double maxX, double maxY, CoordinateReferenceSystem crs) {
        return new BBox(this, minX, minY, maxX, maxY, crs, false);
    }

    default public Predicate bboxLoose(double minX, double minY, double maxX, double maxY) {
        return new BBox(this, minX, minY, maxX, maxY, true);
    }

    default public Predicate bboxLoose(double minX, double minY, double maxX, double maxY, CoordinateReferenceSystem crs) {
        return new BBox(this, minX, minY, maxX, maxY, crs, true);
    }

    default public Predicate intersects(Object other) {
        return new Intersects(this, SpatialExpression.toSpatialExpression(other), false);
    }

    default public Predicate intersectsLoose(Object other) {
        return new Intersects(this, SpatialExpression.toSpatialExpression(other), true);
    }

    default public Predicate disjoint(Object other) {
        return new Disjoint(this, SpatialExpression.toSpatialExpression(other), false);
    }

    default public Predicate disjointLoose(Object other) {
        return new Disjoint(this, SpatialExpression.toSpatialExpression(other), true);
    }

    default public Predicate contains(Object other) {
        return new SpatialContains(this, SpatialExpression.toSpatialExpression(other));
    }

    default public Predicate within(Object other) {
        return new Within(this, SpatialExpression.toSpatialExpression(other));
    }

    default public Predicate touches(Object other) {
        return new Touches(this, SpatialExpression.toSpatialExpression(other));
    }

    default public Predicate crosses(Object other) {
        return new Crosses(this, SpatialExpression.toSpatialExpression(other));
    }

    default public Predicate overlaps(Object other) {
        return new Overlaps(this, SpatialExpression.toSpatialExpression(other));
    }

    default public Predicate isEqualTo(Object other) {
        return new SpatialEqualTo(this, SpatialExpression.toSpatialExpression(other));
    }

    default public Predicate isNotEqualTo(Object other) {
        return new SpatialNotEqualTo(this, SpatialExpression.toSpatialExpression(other));
    }

    public static SpatialExpression toSpatialExpression(Object obj) {
        if (obj instanceof SpatialExpression) {
            return (SpatialExpression)obj;
        }
        return SpatialLiteral.of(obj);
    }
}

