/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.store.query.filter.expression.spatial;

import java.nio.ByteBuffer;
import org.locationtech.geowave.core.geotime.store.query.filter.expression.spatial.BinarySpatialPredicate;
import org.locationtech.geowave.core.geotime.store.query.filter.expression.spatial.FilterGeometry;
import org.locationtech.geowave.core.geotime.store.query.filter.expression.spatial.SpatialExpression;

public class Intersects
extends BinarySpatialPredicate {
    protected boolean loose;

    public Intersects() {
    }

    public Intersects(SpatialExpression expression1, SpatialExpression expression2, boolean loose) {
        super(expression1, expression2);
        this.loose = loose;
    }

    @Override
    public boolean evaluateInternal(FilterGeometry value1, FilterGeometry value2) {
        if (this.loose) {
            return value1.getGeometry().getEnvelopeInternal().intersects(value2.getGeometry().getEnvelopeInternal());
        }
        return value1.intersects(value2);
    }

    @Override
    protected boolean isExact() {
        return this.isLoose();
    }

    public boolean isLoose() {
        return this.loose;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.loose ? "LOOSE_INTERSECTS(" : "INTERSECTS(");
        sb.append(((SpatialExpression)this.expression1).toString());
        sb.append(",");
        sb.append(((SpatialExpression)this.expression2).toString());
        sb.append(")");
        return sb.toString();
    }

    public byte[] toBinary() {
        byte[] superBinary = super.toBinary();
        ByteBuffer buffer = ByteBuffer.allocate(1 + superBinary.length);
        buffer.put(this.loose ? (byte)1 : 0);
        buffer.put(superBinary);
        return buffer.array();
    }

    public void fromBinary(byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        this.loose = buffer.get() != 0;
        byte[] superBinary = new byte[buffer.remaining()];
        buffer.get(superBinary);
        super.fromBinary(superBinary);
    }
}

