/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.store.query.filter.expression.spatial;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.geotools.referencing.CRS;
import org.locationtech.geowave.core.geotime.store.query.filter.expression.spatial.FilterGeometry;
import org.locationtech.geowave.core.geotime.store.query.filter.expression.spatial.SpatialExpression;
import org.locationtech.geowave.core.geotime.store.query.filter.expression.spatial.SpatialLiteral;
import org.locationtech.geowave.core.geotime.util.GeometryUtils;
import org.locationtech.geowave.core.store.AdapterToIndexMapping;
import org.locationtech.geowave.core.store.api.DataTypeAdapter;
import org.locationtech.geowave.core.store.api.Index;
import org.locationtech.geowave.core.store.api.IndexFieldMapper;
import org.locationtech.geowave.core.store.query.filter.expression.BinaryPredicate;
import org.locationtech.geowave.core.store.query.filter.expression.Expression;
import org.locationtech.geowave.core.store.query.filter.expression.FieldValue;
import org.locationtech.geowave.core.store.query.filter.expression.FilterConstraints;
import org.locationtech.geowave.core.store.query.filter.expression.FilterRange;
import org.locationtech.geowave.core.store.query.filter.expression.IndexFieldConstraints;
import org.locationtech.geowave.core.store.query.filter.expression.numeric.NumericFieldConstraints;
import org.locationtech.geowave.core.store.statistics.DataStatisticsStore;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public abstract class BinarySpatialPredicate
extends BinaryPredicate<SpatialExpression> {
    public BinarySpatialPredicate() {
    }

    public BinarySpatialPredicate(SpatialExpression expression1, SpatialExpression expression2) {
        super((Expression)expression1, (Expression)expression2);
    }

    public void prepare(DataTypeAdapter<?> adapter, AdapterToIndexMapping indexMapping, Index index) {
        CoordinateReferenceSystem expression1Crs = ((SpatialExpression)this.expression1).getCRS(adapter);
        CoordinateReferenceSystem expression2Crs = ((SpatialExpression)this.expression2).getCRS(adapter);
        if (((SpatialExpression)this.expression1).isLiteral() && !(this.expression1 instanceof SpatialLiteral)) {
            this.expression1 = SpatialLiteral.of(((SpatialExpression)this.expression1).evaluateValue(null), expression1Crs);
        }
        if (((SpatialExpression)this.expression2).isLiteral() && !(this.expression2 instanceof SpatialLiteral)) {
            this.expression2 = SpatialLiteral.of(((SpatialExpression)this.expression2).evaluateValue(null), expression2Crs);
        }
        if (this.expression1 instanceof FieldValue && this.isFieldMappedToIndex(((FieldValue)this.expression1).getFieldName(), indexMapping)) {
            expression1Crs = GeometryUtils.getIndexCrs(index);
        }
        if (this.expression2 instanceof FieldValue && this.isFieldMappedToIndex(((FieldValue)this.expression2).getFieldName(), indexMapping)) {
            expression2Crs = GeometryUtils.getIndexCrs(index);
        }
        if (((SpatialExpression)this.expression1).isLiteral()) {
            ((SpatialLiteral)this.expression1).prepare(expression2Crs);
        } else if (((SpatialExpression)this.expression2).isLiteral()) {
            ((SpatialLiteral)this.expression2).prepare(expression1Crs);
        }
    }

    private boolean isFieldMappedToIndex(String fieldName, AdapterToIndexMapping indexMapping) {
        for (IndexFieldMapper mapper : indexMapping.getIndexFieldMappers()) {
            for (String adapterField : mapper.getAdapterFields()) {
                if (!adapterField.equals(fieldName)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean evaluate(Map<String, Object> fieldValues) {
        Object value1 = ((SpatialExpression)this.expression1).evaluateValue(fieldValues);
        Object value2 = ((SpatialExpression)this.expression2).evaluateValue(fieldValues);
        if (value1 == null || value2 == null) {
            return false;
        }
        return this.evaluateInternal((FilterGeometry)value1, (FilterGeometry)value2);
    }

    public <T> boolean evaluate(DataTypeAdapter<T> adapter, T entry) {
        Object value1 = ((SpatialExpression)this.expression1).evaluateValue(adapter, entry);
        Object value2 = ((SpatialExpression)this.expression2).evaluateValue(adapter, entry);
        if (value1 == null || value2 == null) {
            return false;
        }
        return this.evaluateInternal((FilterGeometry)value1, (FilterGeometry)value2);
    }

    protected abstract boolean evaluateInternal(FilterGeometry var1, FilterGeometry var2);

    public Set<String> getConstrainableFields() {
        if (this.expression1 instanceof FieldValue && ((SpatialExpression)this.expression2).isLiteral()) {
            return Sets.newHashSet((Object[])new String[]{((FieldValue)this.expression1).getFieldName()});
        }
        if (this.expression2 instanceof FieldValue && ((SpatialExpression)this.expression1).isLiteral()) {
            return Sets.newHashSet((Object[])new String[]{((FieldValue)this.expression2).getFieldName()});
        }
        return Sets.newHashSet();
    }

    public <V extends Comparable<V>> FilterConstraints<V> getConstraints(Class<V> constraintClass, DataStatisticsStore statsStore, DataTypeAdapter<?> adapter, AdapterToIndexMapping indexMapping, Index index, Set<String> indexedFields) {
        if (!constraintClass.isAssignableFrom(Double.class)) {
            return FilterConstraints.empty();
        }
        HashMap dimensionRanges = Maps.newHashMap();
        FilterGeometry literal = null;
        String fieldName = null;
        CoordinateReferenceSystem literalCRS = GeometryUtils.getDefaultCRS();
        if (this.expression1 instanceof FieldValue && indexedFields.contains(((FieldValue)this.expression1).getFieldName()) && ((SpatialExpression)this.expression2).isLiteral()) {
            literal = (FilterGeometry)((SpatialExpression)this.expression2).evaluateValue(null, null);
            if (this.expression2 instanceof SpatialExpression) {
                literalCRS = ((SpatialExpression)this.expression2).getCRS(adapter);
            }
            fieldName = ((FieldValue)this.expression1).getFieldName();
        } else if (this.expression2 instanceof FieldValue && indexedFields.contains(((FieldValue)this.expression2).getFieldName()) && ((SpatialExpression)this.expression1).isLiteral()) {
            literal = (FilterGeometry)((SpatialExpression)this.expression1).evaluateValue(null, null);
            if (this.expression1 instanceof SpatialExpression) {
                literalCRS = ((SpatialExpression)this.expression1).getCRS(adapter);
            }
            fieldName = ((FieldValue)this.expression2).getFieldName();
        }
        if (literal != null && fieldName != null) {
            Envelope envelope;
            CoordinateReferenceSystem indexCRS = GeometryUtils.getIndexCrs(index);
            Geometry literalGeometry = literal.getGeometry();
            if (indexCRS != null && !indexCRS.equals(literalCRS)) {
                try {
                    literalGeometry = GeometryUtils.crsTransform(literalGeometry, CRS.findMathTransform((CoordinateReferenceSystem)literalCRS, (CoordinateReferenceSystem)indexCRS));
                }
                catch (FactoryException e) {
                    throw new RuntimeException("Unable to transform spatial literal to the index CRS.");
                }
            }
            if (!(envelope = literalGeometry.getEnvelopeInternal()).isNull()) {
                dimensionRanges.put(0, IndexFieldConstraints.DimensionConstraints.of((List)Lists.newArrayList((Object[])new FilterRange[]{FilterRange.of((Comparable)Double.valueOf(envelope.getMinX()), (Comparable)Double.valueOf(envelope.getMaxX()), (boolean)true, (boolean)true, (boolean)this.isExact())})));
                dimensionRanges.put(1, IndexFieldConstraints.DimensionConstraints.of((List)Lists.newArrayList((Object[])new FilterRange[]{FilterRange.of((Comparable)Double.valueOf(envelope.getMinY()), (Comparable)Double.valueOf(envelope.getMaxY()), (boolean)true, (boolean)true, (boolean)this.isExact())})));
            }
        }
        if (dimensionRanges.isEmpty()) {
            return FilterConstraints.empty();
        }
        return FilterConstraints.of(adapter, (AdapterToIndexMapping)indexMapping, (Index)index, fieldName, (IndexFieldConstraints)NumericFieldConstraints.of((Map)dimensionRanges));
    }

    protected abstract boolean isExact();
}

