/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.store.query.filter.expression.spatial;

import org.geotools.geometry.jts.ReferencedEnvelope;
import org.locationtech.geowave.core.geotime.store.query.filter.expression.spatial.FilterGeometry;
import org.locationtech.geowave.core.geotime.store.query.filter.expression.spatial.Intersects;
import org.locationtech.geowave.core.geotime.store.query.filter.expression.spatial.SpatialExpression;
import org.locationtech.geowave.core.geotime.store.query.filter.expression.spatial.SpatialLiteral;
import org.locationtech.geowave.core.geotime.util.GeometryUtils;
import org.locationtech.jts.geom.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class BBox
extends Intersects {
    public BBox() {
    }

    public BBox(SpatialExpression expression, double minX, double minY, double maxX, double maxY, boolean loose) {
        this(expression, minX, minY, maxX, maxY, null, loose);
    }

    public BBox(SpatialExpression expression, double minX, double minY, double maxX, double maxY, CoordinateReferenceSystem crs, boolean loose) {
        super(expression, SpatialLiteral.of(new ReferencedEnvelope(minX, maxX, minY, maxY, crs == null ? GeometryUtils.getDefaultCRS() : crs)), loose);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.loose ? "BBOXLOOSE(" : "BBOX(");
        Envelope envelope = ((FilterGeometry)((SpatialExpression)this.expression2).evaluateValue(null)).getGeometry().getEnvelopeInternal();
        sb.append(((SpatialExpression)this.expression1).toString());
        sb.append(",");
        sb.append(envelope.getMinX());
        sb.append(",");
        sb.append(envelope.getMinY());
        sb.append(",");
        sb.append(envelope.getMaxX());
        sb.append(",");
        sb.append(envelope.getMaxY());
        sb.append(")");
        return sb.toString();
    }
}

