/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.store.query.filter.expression;

import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.locationtech.geowave.core.geotime.adapter.SpatialFieldDescriptor;
import org.locationtech.geowave.core.geotime.adapter.TemporalFieldDescriptor;
import org.locationtech.geowave.core.geotime.store.query.filter.expression.CQLToGeoWaveConversionException;
import org.locationtech.geowave.core.geotime.store.query.filter.expression.spatial.SpatialExpression;
import org.locationtech.geowave.core.geotime.store.query.filter.expression.spatial.SpatialFieldValue;
import org.locationtech.geowave.core.geotime.store.query.filter.expression.spatial.SpatialLiteral;
import org.locationtech.geowave.core.geotime.store.query.filter.expression.temporal.TemporalExpression;
import org.locationtech.geowave.core.geotime.store.query.filter.expression.temporal.TemporalFieldValue;
import org.locationtech.geowave.core.geotime.store.query.filter.expression.temporal.TemporalLiteral;
import org.locationtech.geowave.core.store.adapter.FieldDescriptor;
import org.locationtech.geowave.core.store.api.DataTypeAdapter;
import org.locationtech.geowave.core.store.query.filter.expression.And;
import org.locationtech.geowave.core.store.query.filter.expression.BooleanFieldValue;
import org.locationtech.geowave.core.store.query.filter.expression.BooleanLiteral;
import org.locationtech.geowave.core.store.query.filter.expression.ComparableExpression;
import org.locationtech.geowave.core.store.query.filter.expression.Expression;
import org.locationtech.geowave.core.store.query.filter.expression.Filter;
import org.locationtech.geowave.core.store.query.filter.expression.GenericFieldValue;
import org.locationtech.geowave.core.store.query.filter.expression.GenericLiteral;
import org.locationtech.geowave.core.store.query.filter.expression.Literal;
import org.locationtech.geowave.core.store.query.filter.expression.Not;
import org.locationtech.geowave.core.store.query.filter.expression.numeric.NumericExpression;
import org.locationtech.geowave.core.store.query.filter.expression.numeric.NumericFieldValue;
import org.locationtech.geowave.core.store.query.filter.expression.numeric.NumericLiteral;
import org.locationtech.geowave.core.store.query.filter.expression.text.TextExpression;
import org.locationtech.geowave.core.store.query.filter.expression.text.TextFieldValue;
import org.locationtech.geowave.core.store.query.filter.expression.text.TextLiteral;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.opengis.filter.ExcludeFilter;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.Id;
import org.opengis.filter.IncludeFilter;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsGreaterThanOrEqualTo;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.PropertyIsNil;
import org.opengis.filter.PropertyIsNotEqualTo;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.expression.Add;
import org.opengis.filter.expression.Divide;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Multiply;
import org.opengis.filter.expression.NilExpression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.expression.Subtract;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;
import org.opengis.filter.temporal.After;
import org.opengis.filter.temporal.AnyInteracts;
import org.opengis.filter.temporal.Before;
import org.opengis.filter.temporal.Begins;
import org.opengis.filter.temporal.BegunBy;
import org.opengis.filter.temporal.During;
import org.opengis.filter.temporal.EndedBy;
import org.opengis.filter.temporal.Ends;
import org.opengis.filter.temporal.Meets;
import org.opengis.filter.temporal.MetBy;
import org.opengis.filter.temporal.OverlappedBy;
import org.opengis.filter.temporal.TContains;
import org.opengis.filter.temporal.TEquals;
import org.opengis.filter.temporal.TOverlaps;

public class CQLToGeoWaveFilterVisitor
implements FilterVisitor,
ExpressionVisitor {
    private final DataTypeAdapter<?> adapter;

    public CQLToGeoWaveFilterVisitor(DataTypeAdapter<?> adapter) {
        this.adapter = adapter;
    }

    public Object visit(NilExpression expression, Object extraData) {
        throw new CQLToGeoWaveConversionException();
    }

    public Object visit(Add expression, Object extraData) {
        Object expr1 = expression.getExpression1().accept((ExpressionVisitor)this, (Object)ExpressionType.NUMERIC);
        Object expr2 = expression.getExpression2().accept((ExpressionVisitor)this, (Object)ExpressionType.NUMERIC);
        if (expr1 instanceof NumericExpression && expr2 instanceof NumericExpression) {
            return ((NumericExpression)expr1).add(expr2);
        }
        throw new CQLToGeoWaveConversionException();
    }

    public Object visit(Subtract expression, Object extraData) {
        Object expr1 = expression.getExpression1().accept((ExpressionVisitor)this, (Object)ExpressionType.NUMERIC);
        Object expr2 = expression.getExpression2().accept((ExpressionVisitor)this, (Object)ExpressionType.NUMERIC);
        if (expr1 instanceof NumericExpression && expr2 instanceof NumericExpression) {
            return ((NumericExpression)expr1).subtract(expr2);
        }
        throw new CQLToGeoWaveConversionException();
    }

    public Object visit(Multiply expression, Object extraData) {
        Object expr1 = expression.getExpression1().accept((ExpressionVisitor)this, (Object)ExpressionType.NUMERIC);
        Object expr2 = expression.getExpression2().accept((ExpressionVisitor)this, (Object)ExpressionType.NUMERIC);
        if (expr1 instanceof NumericExpression && expr2 instanceof NumericExpression) {
            return ((NumericExpression)expr1).multiplyBy(expr2);
        }
        throw new CQLToGeoWaveConversionException();
    }

    public Object visit(Divide expression, Object extraData) {
        Object expr1 = expression.getExpression1().accept((ExpressionVisitor)this, (Object)ExpressionType.NUMERIC);
        Object expr2 = expression.getExpression2().accept((ExpressionVisitor)this, (Object)ExpressionType.NUMERIC);
        if (expr1 instanceof NumericExpression && expr2 instanceof NumericExpression) {
            return ((NumericExpression)expr1).divideBy(expr2);
        }
        throw new CQLToGeoWaveConversionException();
    }

    public Object visit(Function expression, Object extraData) {
        throw new CQLToGeoWaveConversionException();
    }

    public Object visit(org.opengis.filter.expression.Literal expression, Object extraData) {
        Object value = expression.getValue();
        if (extraData != null && extraData instanceof ExpressionType) {
            switch ((ExpressionType)((Object)extraData)) {
                case NUMERIC: {
                    return NumericLiteral.of((Object)((Number)value));
                }
                case SPATIAL: {
                    return SpatialLiteral.of(value);
                }
                case TEMPORAL: {
                    return TemporalLiteral.of(value);
                }
                case TEXT: {
                    return TextLiteral.of((Object)((String)value));
                }
                case BOOLEAN: {
                    return BooleanLiteral.of((Object)value);
                }
            }
        }
        return this.inferLiteral(value);
    }

    private Literal<?> inferLiteral(Object object) {
        if (object instanceof Geometry || object instanceof Envelope) {
            return SpatialLiteral.of(object);
        }
        if (object instanceof Boolean) {
            return BooleanLiteral.of((Object)object);
        }
        if (object instanceof Number) {
            return NumericLiteral.of((Object)((Number)object));
        }
        if (object instanceof String) {
            return TextLiteral.of((Object)((String)object));
        }
        if (object instanceof Date || object instanceof Calendar) {
            return TemporalLiteral.of(object);
        }
        return GenericLiteral.of((Object)object);
    }

    public Object visit(PropertyName expression, Object extraData) {
        String value = expression.getPropertyName();
        FieldDescriptor descriptor = this.adapter.getFieldDescriptor(value);
        if (descriptor == null && (value == null || value.length() == 0) && extraData != null && extraData.equals((Object)ExpressionType.SPATIAL)) {
            FieldDescriptor[] descriptors;
            for (FieldDescriptor field : descriptors = this.adapter.getFieldDescriptors()) {
                if (!Geometry.class.isAssignableFrom(field.bindingClass())) continue;
                value = field.fieldName();
                descriptor = field;
                break;
            }
        }
        if (descriptor == null) {
            throw new CQLToGeoWaveConversionException();
        }
        if (extraData != null && extraData instanceof ExpressionType) {
            switch ((ExpressionType)((Object)extraData)) {
                case NUMERIC: {
                    return NumericFieldValue.of((String)value);
                }
                case SPATIAL: {
                    return SpatialFieldValue.of(value);
                }
                case TEMPORAL: {
                    return TemporalFieldValue.of(value);
                }
                case TEXT: {
                    return TextFieldValue.of((String)value);
                }
                case BOOLEAN: {
                    return BooleanFieldValue.of((String)value);
                }
            }
        }
        if (descriptor instanceof SpatialFieldDescriptor || Geometry.class.isAssignableFrom(descriptor.bindingClass()) || Envelope.class.isAssignableFrom(descriptor.bindingClass())) {
            return SpatialFieldValue.of(value);
        }
        if (descriptor instanceof TemporalFieldDescriptor || Date.class.isAssignableFrom(descriptor.bindingClass()) || Calendar.class.isAssignableFrom(descriptor.bindingClass())) {
            return TemporalFieldValue.of(value);
        }
        if (Boolean.class.isAssignableFrom(descriptor.bindingClass())) {
            return BooleanFieldValue.of((String)value);
        }
        if (Number.class.isAssignableFrom(descriptor.bindingClass())) {
            return NumericFieldValue.of((String)value);
        }
        if (String.class.isAssignableFrom(descriptor.bindingClass())) {
            return TextFieldValue.of((String)value);
        }
        return GenericFieldValue.of((String)value);
    }

    public Object visitNullFilter(Object extraData) {
        throw new CQLToGeoWaveConversionException();
    }

    public Object visit(ExcludeFilter filter, Object extraData) {
        return Filter.exclude();
    }

    public Object visit(IncludeFilter filter, Object extraData) {
        return Filter.include();
    }

    public Object visit(org.opengis.filter.And filter, Object extraData) {
        Filter[] children = (Filter[])filter.getChildren().stream().map(f -> f.accept((FilterVisitor)this, extraData)).filter(f -> f instanceof Filter).toArray(Filter[]::new);
        if (children.length == filter.getChildren().size()) {
            return new And(children);
        }
        throw new CQLToGeoWaveConversionException();
    }

    public Object visit(Or filter, Object extraData) {
        Filter[] children = (Filter[])filter.getChildren().stream().map(f -> f.accept((FilterVisitor)this, extraData)).filter(f -> f instanceof Filter).toArray(Filter[]::new);
        if (children.length == filter.getChildren().size()) {
            return new org.locationtech.geowave.core.store.query.filter.expression.Or(children);
        }
        throw new CQLToGeoWaveConversionException();
    }

    public Object visit(org.opengis.filter.Not filter, Object extraData) {
        Object transformed = filter.getFilter().accept((FilterVisitor)this, extraData);
        if (transformed instanceof Filter) {
            return new Not((Filter)transformed);
        }
        throw new CQLToGeoWaveConversionException();
    }

    public Object visit(Id filter, Object extraData) {
        throw new CQLToGeoWaveConversionException();
    }

    public Object visit(PropertyIsBetween filter, Object extraData) {
        Object expression = filter.getExpression().accept((ExpressionVisitor)this, (Object)ExpressionType.ANY);
        Object lowerBound = filter.getLowerBoundary().accept((ExpressionVisitor)this, (Object)ExpressionType.ANY);
        Object upperBound = filter.getUpperBoundary().accept((ExpressionVisitor)this, (Object)ExpressionType.ANY);
        if (expression instanceof ComparableExpression && lowerBound instanceof ComparableExpression && upperBound instanceof ComparableExpression) {
            return ((ComparableExpression)expression).isBetween(lowerBound, upperBound);
        }
        throw new CQLToGeoWaveConversionException();
    }

    public Object visit(PropertyIsEqualTo filter, Object extraData) {
        Object expression1 = filter.getExpression1().accept((ExpressionVisitor)this, (Object)ExpressionType.ANY);
        Object expression2 = filter.getExpression2().accept((ExpressionVisitor)this, (Object)ExpressionType.ANY);
        if (expression1 instanceof Expression && expression2 instanceof Expression) {
            return ((Expression)expression1).isEqualTo(expression2);
        }
        throw new CQLToGeoWaveConversionException();
    }

    public Object visit(PropertyIsNotEqualTo filter, Object extraData) {
        Object expression1 = filter.getExpression1().accept((ExpressionVisitor)this, (Object)ExpressionType.ANY);
        Object expression2 = filter.getExpression2().accept((ExpressionVisitor)this, (Object)ExpressionType.ANY);
        if (expression1 instanceof Expression && expression2 instanceof Expression) {
            return ((Expression)expression1).isNotEqualTo(expression2);
        }
        throw new CQLToGeoWaveConversionException();
    }

    public Object visit(PropertyIsGreaterThan filter, Object extraData) {
        Object expression1 = filter.getExpression1().accept((ExpressionVisitor)this, (Object)ExpressionType.ANY);
        Object expression2 = filter.getExpression2().accept((ExpressionVisitor)this, (Object)ExpressionType.ANY);
        if (expression1 instanceof ComparableExpression && expression2 instanceof ComparableExpression) {
            return ((ComparableExpression)expression1).isGreaterThan(expression2);
        }
        throw new CQLToGeoWaveConversionException();
    }

    public Object visit(PropertyIsGreaterThanOrEqualTo filter, Object extraData) {
        Object expression1 = filter.getExpression1().accept((ExpressionVisitor)this, (Object)ExpressionType.ANY);
        Object expression2 = filter.getExpression2().accept((ExpressionVisitor)this, (Object)ExpressionType.ANY);
        if (expression1 instanceof ComparableExpression && expression2 instanceof ComparableExpression) {
            return ((ComparableExpression)expression1).isGreaterThanOrEqualTo(expression2);
        }
        throw new CQLToGeoWaveConversionException();
    }

    public Object visit(PropertyIsLessThan filter, Object extraData) {
        Object expression1 = filter.getExpression1().accept((ExpressionVisitor)this, (Object)ExpressionType.ANY);
        Object expression2 = filter.getExpression2().accept((ExpressionVisitor)this, (Object)ExpressionType.ANY);
        if (expression1 instanceof ComparableExpression && expression2 instanceof ComparableExpression) {
            return ((ComparableExpression)expression1).isLessThan(expression2);
        }
        throw new CQLToGeoWaveConversionException();
    }

    public Object visit(PropertyIsLessThanOrEqualTo filter, Object extraData) {
        Object expression1 = filter.getExpression1().accept((ExpressionVisitor)this, (Object)ExpressionType.ANY);
        Object expression2 = filter.getExpression2().accept((ExpressionVisitor)this, (Object)ExpressionType.ANY);
        if (expression1 instanceof ComparableExpression && expression2 instanceof ComparableExpression) {
            return ((ComparableExpression)expression1).isLessThanOrEqualTo(expression2);
        }
        throw new CQLToGeoWaveConversionException();
    }

    public Object visit(PropertyIsLike filter, Object extraData) {
        Object expression = filter.getExpression().accept((ExpressionVisitor)this, (Object)ExpressionType.TEXT);
        if (!(expression instanceof TextExpression)) {
            throw new CQLToGeoWaveConversionException();
        }
        String likeStr = filter.getLiteral();
        if (likeStr.matches(".*(^\\b|[^\\" + filter.getEscape() + "])" + filter.getSingleChar() + ".*")) {
            throw new CQLToGeoWaveConversionException();
        }
        int count = StringUtils.countMatches((String)likeStr, (String)filter.getWildCard());
        if (count == 0) {
            return ((TextExpression)expression).isEqualTo((Object)StringUtils.replace((String)likeStr, (String)filter.getEscape(), (String)""), !filter.isMatchingCase());
        }
        if (count == 1) {
            if (likeStr.startsWith(filter.getWildCard())) {
                return ((TextExpression)expression).endsWith((Object)likeStr.substring(filter.getWildCard().length()), !filter.isMatchingCase());
            }
            if (likeStr.endsWith(filter.getWildCard())) {
                return ((TextExpression)expression).startsWith((Object)likeStr.substring(0, likeStr.length() - filter.getWildCard().length()), !filter.isMatchingCase());
            }
        } else if (count == 2 && likeStr.startsWith(filter.getWildCard()) && likeStr.endsWith(filter.getWildCard())) {
            return ((TextExpression)expression).contains((Object)likeStr.substring(filter.getWildCard().length(), likeStr.length() - filter.getWildCard().length()), !filter.isMatchingCase());
        }
        throw new CQLToGeoWaveConversionException();
    }

    public Object visit(PropertyIsNull filter, Object extraData) {
        Object expression = filter.getExpression().accept((ExpressionVisitor)this, (Object)ExpressionType.ANY);
        if (expression instanceof Expression) {
            return ((Expression)expression).isNull();
        }
        throw new CQLToGeoWaveConversionException();
    }

    public Object visit(PropertyIsNil filter, Object extraData) {
        Object expression = filter.getExpression().accept((ExpressionVisitor)this, (Object)ExpressionType.ANY);
        if (expression instanceof Expression) {
            return ((Expression)expression).isNull();
        }
        throw new CQLToGeoWaveConversionException();
    }

    public Object visit(BBOX filter, Object extraData) {
        Object expression = filter.getExpression1().accept((ExpressionVisitor)this, (Object)ExpressionType.SPATIAL);
        if (expression instanceof SpatialExpression) {
            return ((SpatialExpression)expression).bbox(filter.getBounds().getMinX(), filter.getBounds().getMinY(), filter.getBounds().getMaxX(), filter.getBounds().getMaxY(), filter.getBounds().getCoordinateReferenceSystem());
        }
        throw new CQLToGeoWaveConversionException();
    }

    public Object visit(Beyond filter, Object extraData) {
        throw new CQLToGeoWaveConversionException();
    }

    public Object visit(Contains filter, Object extraData) {
        Object expression1 = filter.getExpression1().accept((ExpressionVisitor)this, (Object)ExpressionType.SPATIAL);
        Object expression2 = filter.getExpression2().accept((ExpressionVisitor)this, (Object)ExpressionType.SPATIAL);
        if (expression1 instanceof SpatialExpression && expression2 instanceof SpatialExpression) {
            return ((SpatialExpression)expression1).contains(expression2);
        }
        throw new CQLToGeoWaveConversionException();
    }

    public Object visit(Crosses filter, Object extraData) {
        Object expression1 = filter.getExpression1().accept((ExpressionVisitor)this, (Object)ExpressionType.SPATIAL);
        Object expression2 = filter.getExpression2().accept((ExpressionVisitor)this, (Object)ExpressionType.SPATIAL);
        if (expression1 instanceof SpatialExpression && expression2 instanceof SpatialExpression) {
            return ((SpatialExpression)expression1).crosses(expression2);
        }
        throw new CQLToGeoWaveConversionException();
    }

    public Object visit(Disjoint filter, Object extraData) {
        Object expression1 = filter.getExpression1().accept((ExpressionVisitor)this, (Object)ExpressionType.SPATIAL);
        Object expression2 = filter.getExpression2().accept((ExpressionVisitor)this, (Object)ExpressionType.SPATIAL);
        if (expression1 instanceof SpatialExpression && expression2 instanceof SpatialExpression) {
            return ((SpatialExpression)expression1).disjoint(expression2);
        }
        throw new CQLToGeoWaveConversionException();
    }

    public Object visit(DWithin filter, Object extraData) {
        throw new CQLToGeoWaveConversionException();
    }

    public Object visit(Equals filter, Object extraData) {
        Object expression1 = filter.getExpression1().accept((ExpressionVisitor)this, (Object)ExpressionType.SPATIAL);
        Object expression2 = filter.getExpression2().accept((ExpressionVisitor)this, (Object)ExpressionType.SPATIAL);
        if (expression1 instanceof SpatialExpression && expression2 instanceof SpatialExpression) {
            return ((SpatialExpression)expression1).isEqualTo(expression2);
        }
        throw new CQLToGeoWaveConversionException();
    }

    public Object visit(Intersects filter, Object extraData) {
        Object expression1 = filter.getExpression1().accept((ExpressionVisitor)this, (Object)ExpressionType.SPATIAL);
        Object expression2 = filter.getExpression2().accept((ExpressionVisitor)this, (Object)ExpressionType.SPATIAL);
        if (expression1 instanceof SpatialExpression && expression2 instanceof SpatialExpression) {
            return ((SpatialExpression)expression1).intersects(expression2);
        }
        throw new CQLToGeoWaveConversionException();
    }

    public Object visit(Overlaps filter, Object extraData) {
        Object expression1 = filter.getExpression1().accept((ExpressionVisitor)this, (Object)ExpressionType.SPATIAL);
        Object expression2 = filter.getExpression2().accept((ExpressionVisitor)this, (Object)ExpressionType.SPATIAL);
        if (expression1 instanceof SpatialExpression && expression2 instanceof SpatialExpression) {
            return ((SpatialExpression)expression1).overlaps(expression2);
        }
        throw new CQLToGeoWaveConversionException();
    }

    public Object visit(Touches filter, Object extraData) {
        Object expression1 = filter.getExpression1().accept((ExpressionVisitor)this, (Object)ExpressionType.SPATIAL);
        Object expression2 = filter.getExpression2().accept((ExpressionVisitor)this, (Object)ExpressionType.SPATIAL);
        if (expression1 instanceof SpatialExpression && expression2 instanceof SpatialExpression) {
            return ((SpatialExpression)expression1).touches(expression2);
        }
        throw new CQLToGeoWaveConversionException();
    }

    public Object visit(Within filter, Object extraData) {
        Object expression1 = filter.getExpression1().accept((ExpressionVisitor)this, (Object)ExpressionType.SPATIAL);
        Object expression2 = filter.getExpression2().accept((ExpressionVisitor)this, (Object)ExpressionType.SPATIAL);
        if (expression1 instanceof SpatialExpression && expression2 instanceof SpatialExpression) {
            return ((SpatialExpression)expression1).within(expression2);
        }
        throw new CQLToGeoWaveConversionException();
    }

    public Object visit(After after, Object extraData) {
        Object expression1 = after.getExpression1().accept((ExpressionVisitor)this, (Object)ExpressionType.TEMPORAL);
        Object expression2 = after.getExpression2().accept((ExpressionVisitor)this, (Object)ExpressionType.TEMPORAL);
        if (expression1 instanceof TemporalExpression && expression2 instanceof TemporalExpression) {
            return ((TemporalExpression)expression1).isAfter(expression2);
        }
        throw new CQLToGeoWaveConversionException();
    }

    public Object visit(AnyInteracts anyInteracts, Object extraData) {
        Object expression1 = anyInteracts.getExpression1().accept((ExpressionVisitor)this, (Object)ExpressionType.TEMPORAL);
        Object expression2 = anyInteracts.getExpression2().accept((ExpressionVisitor)this, (Object)ExpressionType.TEMPORAL);
        if (expression1 instanceof TemporalExpression && expression2 instanceof TemporalExpression) {
            return ((TemporalExpression)expression1).overlaps(expression2);
        }
        throw new CQLToGeoWaveConversionException();
    }

    public Object visit(Before before, Object extraData) {
        Object expression1 = before.getExpression1().accept((ExpressionVisitor)this, (Object)ExpressionType.TEMPORAL);
        Object expression2 = before.getExpression2().accept((ExpressionVisitor)this, (Object)ExpressionType.TEMPORAL);
        if (expression1 instanceof TemporalExpression && expression2 instanceof TemporalExpression) {
            return ((TemporalExpression)expression1).isBefore(expression2);
        }
        throw new CQLToGeoWaveConversionException();
    }

    public Object visit(Begins begins, Object extraData) {
        throw new CQLToGeoWaveConversionException();
    }

    public Object visit(BegunBy begunBy, Object extraData) {
        throw new CQLToGeoWaveConversionException();
    }

    public Object visit(During during, Object extraData) {
        Object expression1 = during.getExpression1().accept((ExpressionVisitor)this, (Object)ExpressionType.TEMPORAL);
        Object expression2 = during.getExpression2().accept((ExpressionVisitor)this, (Object)ExpressionType.TEMPORAL);
        if (expression1 instanceof TemporalExpression && expression2 instanceof TemporalExpression) {
            return ((TemporalExpression)expression1).isDuring(expression2);
        }
        throw new CQLToGeoWaveConversionException();
    }

    public Object visit(EndedBy endedBy, Object extraData) {
        throw new CQLToGeoWaveConversionException();
    }

    public Object visit(Ends ends, Object extraData) {
        throw new CQLToGeoWaveConversionException();
    }

    public Object visit(Meets meets, Object extraData) {
        throw new CQLToGeoWaveConversionException();
    }

    public Object visit(MetBy metBy, Object extraData) {
        throw new CQLToGeoWaveConversionException();
    }

    public Object visit(OverlappedBy overlappedBy, Object extraData) {
        throw new CQLToGeoWaveConversionException();
    }

    public Object visit(TContains contains, Object extraData) {
        Object expression1 = contains.getExpression1().accept((ExpressionVisitor)this, (Object)ExpressionType.TEMPORAL);
        Object expression2 = contains.getExpression2().accept((ExpressionVisitor)this, (Object)ExpressionType.TEMPORAL);
        if (expression1 instanceof TemporalExpression && expression2 instanceof TemporalExpression) {
            return ((TemporalExpression)expression2).isDuring(expression1);
        }
        throw new CQLToGeoWaveConversionException();
    }

    public Object visit(TEquals equals, Object extraData) {
        Object expression1 = equals.getExpression1().accept((ExpressionVisitor)this, (Object)ExpressionType.TEMPORAL);
        Object expression2 = equals.getExpression2().accept((ExpressionVisitor)this, (Object)ExpressionType.TEMPORAL);
        if (expression1 instanceof Expression && expression2 instanceof Expression) {
            return ((TemporalExpression)expression1).isEqualTo(expression2);
        }
        throw new CQLToGeoWaveConversionException();
    }

    public Object visit(TOverlaps contains, Object extraData) {
        throw new CQLToGeoWaveConversionException();
    }

    private static enum ExpressionType {
        ANY,
        NUMERIC,
        TEXT,
        SPATIAL,
        TEMPORAL,
        BOOLEAN;

    }
}

