/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.store.query.filter;

import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.locationtech.geowave.core.geotime.util.GeometryUtils;
import org.locationtech.geowave.core.index.ByteArrayUtils;
import org.locationtech.geowave.core.index.StringUtils;
import org.locationtech.geowave.core.index.VarintUtils;
import org.locationtech.geowave.core.index.numeric.BasicNumericDataset;
import org.locationtech.geowave.core.index.numeric.MultiDimensionalNumericData;
import org.locationtech.geowave.core.index.numeric.NumericData;
import org.locationtech.geowave.core.store.data.IndexedPersistenceEncoding;
import org.locationtech.geowave.core.store.dimension.NumericDimensionField;
import org.locationtech.geowave.core.store.index.CommonIndexModel;
import org.locationtech.geowave.core.store.query.filter.BasicQueryFilter;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.prep.PreparedGeometry;

public class SpatialQueryFilter
extends BasicQueryFilter {
    private static final Interner<GeometryImage> geometryImageInterner = Interners.newWeakInterner();
    private GeometryImage preparedGeometryImage;
    private CompareOperation compareOperation = CompareOperation.INTERSECTS;
    private Set<String> geometryFieldNames;

    public SpatialQueryFilter() {
    }

    public SpatialQueryFilter(MultiDimensionalNumericData query, NumericDimensionField<?>[] orderedConstrainedDimensionDefinitions, NumericDimensionField<?>[] unconstrainedDimensionDefinitions, Geometry queryGeometry, CompareOperation compareOp, BasicQueryFilter.BasicQueryCompareOperation nonSpatialCompareOp) {
        this(SpatialQueryFilter.stripGeometry(query, orderedConstrainedDimensionDefinitions, unconstrainedDimensionDefinitions), queryGeometry, compareOp, nonSpatialCompareOp);
    }

    private SpatialQueryFilter(StrippedGeometry strippedGeometry, Geometry queryGeometry, CompareOperation compareOp, BasicQueryFilter.BasicQueryCompareOperation nonSpatialCompareOp) {
        super(strippedGeometry.strippedQuery, strippedGeometry.strippedDimensionDefinitions, nonSpatialCompareOp);
        this.preparedGeometryImage = new GeometryImage(GeometryUtils.PREPARED_GEOMETRY_FACTORY.create(queryGeometry));
        this.geometryFieldNames = strippedGeometry.geometryFieldNames;
        if (compareOp != null) {
            this.compareOperation = compareOp;
        }
    }

    private static StrippedGeometry stripGeometry(MultiDimensionalNumericData query, NumericDimensionField<?>[] orderedConstrainedDimensionDefinitions, NumericDimensionField<?>[] unconstrainedDimensionDefinitions) {
        int d;
        HashSet<String> geometryFieldNames = new HashSet<String>();
        ArrayList<NumericData> numericDataPerDimension = new ArrayList<NumericData>();
        ArrayList fields = new ArrayList();
        NumericData[] data = query.getDataPerDimension();
        for (d = 0; d < orderedConstrainedDimensionDefinitions.length; ++d) {
            if (SpatialQueryFilter.isSpatial(orderedConstrainedDimensionDefinitions[d])) {
                geometryFieldNames.add(orderedConstrainedDimensionDefinitions[d].getFieldName());
                continue;
            }
            numericDataPerDimension.add(data[d]);
            fields.add(orderedConstrainedDimensionDefinitions[d]);
        }
        for (d = 0; d < unconstrainedDimensionDefinitions.length; ++d) {
            if (!SpatialQueryFilter.isSpatial(unconstrainedDimensionDefinitions[d])) continue;
            geometryFieldNames.add(unconstrainedDimensionDefinitions[d].getFieldName());
        }
        return new StrippedGeometry((MultiDimensionalNumericData)new BasicNumericDataset(numericDataPerDimension.toArray(new NumericData[numericDataPerDimension.size()])), fields.toArray(new NumericDimensionField[fields.size()]), geometryFieldNames);
    }

    public static boolean isSpatial(NumericDimensionField<?> d) {
        return Geometry.class.isAssignableFrom(d.getFieldClass());
    }

    public boolean accept(CommonIndexModel indexModel, IndexedPersistenceEncoding<?> persistenceEncoding) {
        if (this.preparedGeometryImage == null) {
            return true;
        }
        boolean geometryPasses = false;
        for (String fieldName : this.geometryFieldNames) {
            Geometry geom;
            Object geomObj = persistenceEncoding.getCommonData().getValue(fieldName);
            if (persistenceEncoding.isAsync()) {
                return false;
            }
            if (geomObj == null || !(geomObj instanceof Geometry) || !this.geometryPasses(geom = (Geometry)geomObj)) continue;
            geometryPasses = true;
            break;
        }
        if (!geometryPasses) {
            return false;
        }
        if (this.isSpatialOnly()) {
            return true;
        }
        return super.accept(indexModel, persistenceEncoding);
    }

    private boolean geometryPasses(Geometry dataGeometry) {
        if (dataGeometry == null) {
            return false;
        }
        if (this.preparedGeometryImage != null) {
            return this.compareOperation.compare(dataGeometry, this.preparedGeometryImage.preparedGeometry);
        }
        return false;
    }

    protected boolean isSpatialOnly() {
        return this.dimensionFields == null || this.dimensionFields.length == 0;
    }

    public byte[] toBinary() {
        byte[] geometryBinary = this.preparedGeometryImage.geometryBinary;
        byte[] geometryFieldNamesBytes = StringUtils.stringsToBinary((String[])this.geometryFieldNames.toArray(new String[0]));
        byte[] theRest = super.toBinary();
        ByteBuffer buf = ByteBuffer.allocate(VarintUtils.unsignedIntByteLength((int)this.compareOperation.ordinal()) + VarintUtils.unsignedIntByteLength((int)geometryBinary.length) + VarintUtils.unsignedIntByteLength((int)geometryFieldNamesBytes.length) + geometryBinary.length + geometryFieldNamesBytes.length + theRest.length);
        VarintUtils.writeUnsignedInt((int)this.compareOperation.ordinal(), (ByteBuffer)buf);
        VarintUtils.writeUnsignedInt((int)geometryBinary.length, (ByteBuffer)buf);
        VarintUtils.writeUnsignedInt((int)geometryFieldNamesBytes.length, (ByteBuffer)buf);
        buf.put(geometryBinary);
        buf.put(geometryFieldNamesBytes);
        buf.put(theRest);
        return buf.array();
    }

    public void fromBinary(byte[] bytes) {
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        this.compareOperation = CompareOperation.values()[VarintUtils.readUnsignedInt((ByteBuffer)buf)];
        int geometryBinaryLength = VarintUtils.readUnsignedInt((ByteBuffer)buf);
        int geometryFieldNamesByteLength = VarintUtils.readUnsignedInt((ByteBuffer)buf);
        byte[] geometryBinary = ByteArrayUtils.safeRead((ByteBuffer)buf, (int)geometryBinaryLength);
        byte[] geometryFieldNamesBytes = ByteArrayUtils.safeRead((ByteBuffer)buf, (int)geometryFieldNamesByteLength);
        this.geometryFieldNames = new HashSet<String>(Arrays.asList(StringUtils.stringsFromBinary((byte[])geometryFieldNamesBytes)));
        byte[] theRest = new byte[buf.remaining()];
        buf.get(theRest);
        this.preparedGeometryImage = (GeometryImage)geometryImageInterner.intern((Object)new GeometryImage(geometryBinary));
        this.preparedGeometryImage.init();
        super.fromBinary(theRest);
    }

    public static class GeometryImage {
        public byte[] geometryBinary;
        public PreparedGeometry preparedGeometry = null;

        public GeometryImage(PreparedGeometry preparedGeometry) {
            this.preparedGeometry = preparedGeometry;
            this.geometryBinary = GeometryUtils.geometryToBinary(preparedGeometry.getGeometry(), null);
        }

        public GeometryImage(byte[] geometryBinary) {
            this.geometryBinary = geometryBinary;
        }

        public synchronized void init() {
            if (this.preparedGeometry == null) {
                this.preparedGeometry = GeometryUtils.PREPARED_GEOMETRY_FACTORY.create(GeometryUtils.geometryFromBinary(this.geometryBinary, null));
            }
        }

        public PreparedGeometry getGeometry() {
            return this.preparedGeometry;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this.geometryBinary);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            GeometryImage other = (GeometryImage)obj;
            return Arrays.equals(this.geometryBinary, other.geometryBinary);
        }
    }

    private static class StrippedGeometry {
        private final MultiDimensionalNumericData strippedQuery;
        private final NumericDimensionField<?>[] strippedDimensionDefinitions;
        private final Set<String> geometryFieldNames;

        public StrippedGeometry(MultiDimensionalNumericData strippedQuery, NumericDimensionField<?>[] strippedDimensionDefinitions, Set<String> geometryFieldNames) {
            this.strippedQuery = strippedQuery;
            this.strippedDimensionDefinitions = strippedDimensionDefinitions;
            this.geometryFieldNames = geometryFieldNames;
        }
    }

    public static enum CompareOperation implements SpatialQueryCompareOp
    {
        CONTAINS{

            @Override
            public boolean compare(Geometry dataGeometry, PreparedGeometry constraintGeometry) {
                return constraintGeometry.contains(dataGeometry);
            }

            @Override
            public BasicQueryFilter.BasicQueryCompareOperation getBaseCompareOp() {
                return BasicQueryFilter.BasicQueryCompareOperation.CONTAINS;
            }
        }
        ,
        OVERLAPS{

            @Override
            public boolean compare(Geometry dataGeometry, PreparedGeometry constraintGeometry) {
                return constraintGeometry.overlaps(dataGeometry);
            }

            @Override
            public BasicQueryFilter.BasicQueryCompareOperation getBaseCompareOp() {
                return BasicQueryFilter.BasicQueryCompareOperation.OVERLAPS;
            }
        }
        ,
        INTERSECTS{

            @Override
            public boolean compare(Geometry dataGeometry, PreparedGeometry constraintGeometry) {
                return constraintGeometry.intersects(dataGeometry);
            }

            @Override
            public BasicQueryFilter.BasicQueryCompareOperation getBaseCompareOp() {
                return BasicQueryFilter.BasicQueryCompareOperation.INTERSECTS;
            }
        }
        ,
        TOUCHES{

            @Override
            public boolean compare(Geometry dataGeometry, PreparedGeometry constraintGeometry) {
                return constraintGeometry.touches(dataGeometry);
            }

            @Override
            public BasicQueryFilter.BasicQueryCompareOperation getBaseCompareOp() {
                return BasicQueryFilter.BasicQueryCompareOperation.TOUCHES;
            }
        }
        ,
        WITHIN{

            @Override
            public boolean compare(Geometry dataGeometry, PreparedGeometry constraintGeometry) {
                return constraintGeometry.within(dataGeometry);
            }

            @Override
            public BasicQueryFilter.BasicQueryCompareOperation getBaseCompareOp() {
                return BasicQueryFilter.BasicQueryCompareOperation.WITHIN;
            }
        }
        ,
        DISJOINT{

            @Override
            public boolean compare(Geometry dataGeometry, PreparedGeometry constraintGeometry) {
                return constraintGeometry.disjoint(dataGeometry);
            }

            @Override
            public BasicQueryFilter.BasicQueryCompareOperation getBaseCompareOp() {
                return BasicQueryFilter.BasicQueryCompareOperation.DISJOINT;
            }
        }
        ,
        CROSSES{

            @Override
            public boolean compare(Geometry dataGeometry, PreparedGeometry constraintGeometry) {
                return constraintGeometry.crosses(dataGeometry);
            }

            @Override
            public BasicQueryFilter.BasicQueryCompareOperation getBaseCompareOp() {
                return BasicQueryFilter.BasicQueryCompareOperation.CROSSES;
            }
        }
        ,
        EQUALS{

            @Override
            public boolean compare(Geometry dataGeometry, PreparedGeometry constraintGeometry) {
                return constraintGeometry.getGeometry().equals(dataGeometry);
            }

            @Override
            public BasicQueryFilter.BasicQueryCompareOperation getBaseCompareOp() {
                return BasicQueryFilter.BasicQueryCompareOperation.EQUALS;
            }
        };

    }

    protected static interface SpatialQueryCompareOp {
        public boolean compare(Geometry var1, PreparedGeometry var2);

        public BasicQueryFilter.BasicQueryCompareOperation getBaseCompareOp();
    }
}

